/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.client.ResponseException;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.data.client.osc.JsonUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.ResourceNotFoundException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.VersionConflictException;

public class OpenSearchExceptionTranslator
implements PersistenceExceptionTranslator {
    private final JsonpMapper jsonpMapper;

    public OpenSearchExceptionTranslator(JsonpMapper jsonpMapper) {
        this.jsonpMapper = jsonpMapper;
    }

    public RuntimeException translateException(Throwable throwable) {
        RuntimeException ex;
        RuntimeException runtimeException = throwable instanceof RuntimeException ? (ex = (RuntimeException)throwable) : new RuntimeException(throwable.getMessage(), throwable);
        DataAccessException potentiallyTranslatedException = this.translateExceptionIfPossible(runtimeException);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : runtimeException;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        this.checkForConflictException(ex);
        if (ex instanceof OpenSearchException) {
            String errorReason;
            OpenSearchException openSearchException = (OpenSearchException)ex;
            ErrorResponse response = openSearchException.response();
            String errorType = response.error().type();
            String string = errorReason = response.error().reason() != null ? response.error().reason() : "undefined reason";
            if (response.status() == 404) {
                if ("index_not_found_exception".equals(errorType)) {
                    Pattern pattern = Pattern.compile(".*no such index \\[(.*)\\]");
                    String index = "";
                    Matcher matcher = pattern.matcher(errorReason);
                    if (matcher.matches()) {
                        index = matcher.group(1);
                    }
                    return new NoSuchIndexException(index);
                }
                return new ResourceNotFoundException(errorReason);
            }
            if (response.status() == 409) {
                // empty if block
            }
            String body = JsonUtils.toJson(response, this.jsonpMapper);
            if (errorType != null && errorType.contains("validation_exception")) {
                return new DataIntegrityViolationException(errorReason);
            }
            return new UncategorizedElasticsearchException(ex.getMessage(), response.status(), body, (Throwable)ex);
        }
        Throwable cause = ex.getCause();
        if (cause instanceof IOException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private void checkForConflictException(Throwable exception) {
        Integer status = null;
        String message = null;
        if (exception instanceof ResponseException) {
            ResponseException responseException = (ResponseException)exception;
            status = responseException.getResponse().getStatusLine().getStatusCode();
            message = responseException.getMessage();
        } else if (exception.getCause() != null) {
            this.checkForConflictException(exception.getCause());
        }
        if (status != null && message != null && status == 409 && message.contains("type\":\"version_conflict_engine_exception")) {
            if (message.contains("version conflict, required seqNo")) {
                throw new OptimisticLockingFailureException("Cannot index a document due to seq_no+primary_term conflict", exception);
            }
            if (message.contains("version conflict, current version [")) {
                throw new VersionConflictException("Version conflict", exception);
            }
        }
    }
}

