/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.rest_client.RestClientOptions;
import org.opensearch.client.transport.rest_client.RestClientTransport;
import org.opensearch.data.client.osc.AutoCloseableOpenSearchClient;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.support.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class OpenSearchClients {
    public static final String IMPERATIVE_CLIENT = "imperative";
    private static final String X_SPRING_DATA_OPENSEARCH_CLIENT = "X-SpringDataOpenSearch-Client";
    private static final JsonpMapper DEFAULT_JSONP_MAPPER = new JacksonJsonpMapper();

    public static OpenSearchClient createImperative(ClientConfiguration clientConfiguration) {
        return OpenSearchClients.createImperative(OpenSearchClients.getRestClient(clientConfiguration), null, DEFAULT_JSONP_MAPPER);
    }

    public static OpenSearchClient createImperative(ClientConfiguration clientConfiguration, TransportOptions transportOptions) {
        return OpenSearchClients.createImperative(OpenSearchClients.getRestClient(clientConfiguration), transportOptions, DEFAULT_JSONP_MAPPER);
    }

    public static OpenSearchClient createImperative(RestClient restClient) {
        return OpenSearchClients.createImperative(restClient, null, DEFAULT_JSONP_MAPPER);
    }

    public static OpenSearchClient createImperative(RestClient restClient, @Nullable TransportOptions transportOptions) {
        return OpenSearchClients.createImperative(restClient, transportOptions, DEFAULT_JSONP_MAPPER);
    }

    public static OpenSearchClient createImperative(RestClient restClient, @Nullable TransportOptions transportOptions, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        OpenSearchTransport transport = OpenSearchClients.getOpenSearchTransport(restClient, IMPERATIVE_CLIENT, transportOptions, jsonpMapper);
        return OpenSearchClients.createImperative(transport);
    }

    public static AutoCloseableOpenSearchClient createImperative(OpenSearchTransport transport) {
        Assert.notNull((Object)transport, (String)"transport must not be null");
        return new AutoCloseableOpenSearchClient(transport);
    }

    private static RestClientOptions.Builder getRestClientOptionsBuilder(@Nullable TransportOptions transportOptions) {
        if (transportOptions instanceof RestClientOptions) {
            RestClientOptions restClientOptions = (RestClientOptions)transportOptions;
            return restClientOptions.toBuilder();
        }
        RestClientOptions.Builder builder = new RestClientOptions.Builder(RequestOptions.DEFAULT.toBuilder());
        if (transportOptions != null) {
            transportOptions.headers().forEach(header -> builder.addHeader((String)header.getKey(), (String)header.getValue()));
            transportOptions.queryParameters().forEach((arg_0, arg_1) -> ((RestClientOptions.Builder)builder).setParameter(arg_0, arg_1));
            builder.onWarnings(transportOptions.onWarnings());
        }
        return builder;
    }

    public static RestClient getRestClient(ClientConfiguration clientConfiguration) {
        return OpenSearchClients.getRestClientBuilder(clientConfiguration).build();
    }

    private static RestClientBuilder getRestClientBuilder(ClientConfiguration clientConfiguration) {
        HttpHeaders headers;
        HttpHost[] httpHosts = (HttpHost[])OpenSearchClients.formattedHosts(clientConfiguration.getEndpoints(), clientConfiguration.useSsl()).stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        if (clientConfiguration.getPathPrefix() != null) {
            builder.setPathPrefix(clientConfiguration.getPathPrefix());
        }
        if (!(headers = clientConfiguration.getDefaultHeaders()).isEmpty()) {
            builder.setDefaultHeaders(OpenSearchClients.toHeaderArray(headers));
        }
        builder.setHttpClientConfigCallback(clientBuilder -> {
            Duration socketTimeout;
            if (clientConfiguration.getCaFingerprint().isPresent()) {
                clientBuilder.setSSLContext(OpenSearchClients.sslContextFromCaFingerprint((String)clientConfiguration.getCaFingerprint().get()));
            }
            clientConfiguration.getSslContext().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLContext(arg_0));
            clientConfiguration.getHostNameVerifier().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLHostnameVerifier(arg_0));
            clientBuilder.addInterceptorLast((HttpRequestInterceptor)new CustomHeaderInjector(clientConfiguration.getHeadersSupplier()));
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            Duration connectTimeout = clientConfiguration.getConnectTimeout();
            if (!connectTimeout.isNegative()) {
                requestConfigBuilder.setConnectTimeout(Math.toIntExact(connectTimeout.toMillis()));
            }
            if (!(socketTimeout = clientConfiguration.getSocketTimeout()).isNegative()) {
                requestConfigBuilder.setSocketTimeout(Math.toIntExact(socketTimeout.toMillis()));
                requestConfigBuilder.setConnectionRequestTimeout(Math.toIntExact(socketTimeout.toMillis()));
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            clientConfiguration.getProxy().map(HttpHost::create).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setProxy(arg_0));
            for (ClientConfiguration.ClientConfigurationCallback clientConfigurer : clientConfiguration.getClientConfigurers()) {
                if (!(clientConfigurer instanceof OpenSearchHttpClientConfigurationCallback)) continue;
                OpenSearchHttpClientConfigurationCallback restClientConfigurationCallback = (OpenSearchHttpClientConfigurationCallback)clientConfigurer;
                clientBuilder = (HttpAsyncClientBuilder)restClientConfigurationCallback.configure(clientBuilder);
            }
            return clientBuilder;
        });
        for (ClientConfiguration.ClientConfigurationCallback clientConfigurationCallback : clientConfiguration.getClientConfigurers()) {
            if (!(clientConfigurationCallback instanceof OpenSearchRestClientConfigurationCallback)) continue;
            OpenSearchRestClientConfigurationCallback configurationCallback = (OpenSearchRestClientConfigurationCallback)clientConfigurationCallback;
            builder = (RestClientBuilder)configurationCallback.configure(builder);
        }
        return builder;
    }

    public static OpenSearchTransport getOpenSearchTransport(RestClient restClient, String clientType, @Nullable TransportOptions transportOptions, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        Assert.notNull((Object)clientType, (String)"clientType must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        TransportOptions.Builder transportOptionsBuilder = transportOptions != null ? transportOptions.toBuilder() : new RestClientOptions(RequestOptions.DEFAULT).toBuilder();
        RestClientOptions.Builder restClientOptionsBuilder = OpenSearchClients.getRestClientOptionsBuilder(transportOptions);
        ContentType jsonContentType = ContentType.APPLICATION_JSON;
        Consumer<String> setHeaderIfNotPresent = header -> {
            if (restClientOptionsBuilder.build().headers().stream().noneMatch(h -> ((String)h.getKey()).equalsIgnoreCase((String)header))) {
                restClientOptionsBuilder.addHeader(header, jsonContentType.toString());
            }
        };
        setHeaderIfNotPresent.accept("Content-Type");
        setHeaderIfNotPresent.accept("Accept");
        restClientOptionsBuilder.addHeader(X_SPRING_DATA_OPENSEARCH_CLIENT, clientType);
        return new RestClientTransport(restClient, jsonpMapper, (TransportOptions)restClientOptionsBuilder.build());
    }

    private static List<String> formattedHosts(List<InetSocketAddress> hosts, boolean useSsl) {
        return hosts.stream().map(it -> (useSsl ? "https" : "http") + "://" + it.getHostString() + ":" + it.getPort()).collect(Collectors.toList());
    }

    private static Header[] toHeaderArray(HttpHeaders headers) {
        return (Header[])headers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new BasicHeader((String)entry.getKey(), value))).toArray(Header[]::new);
    }

    private static SSLContext sslContextFromCaFingerprint(String fingerPrint) {
        fingerPrint = fingerPrint.replace(":", "");
        int len = fingerPrint.length();
        final byte[] fpBytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            fpBytes[i / 2] = (byte)((Character.digit(fingerPrint.charAt(i), 16) << 4) + Character.digit(fingerPrint.charAt(i + 1), 16));
        }
        try {
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    throw new CertificateException("This is a client-side only trust manager");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    byte[] bytes;
                    X509Certificate anchor = chain[chain.length - 1];
                    try {
                        MessageDigest md = MessageDigest.getInstance("SHA-256");
                        md.update(anchor.getEncoded());
                        bytes = md.digest();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                    if (Arrays.equals(fpBytes, bytes)) {
                        return;
                    }
                    throw new CertificateException("Untrusted certificate: " + anchor.getSubjectX500Principal());
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new X509TrustManager[]{tm}, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface OpenSearchRestClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<RestClientBuilder> {
        public static OpenSearchRestClientConfigurationCallback from(Function<RestClientBuilder, RestClientBuilder> restClientBuilderCallback) {
            Assert.notNull(restClientBuilderCallback, (String)"restClientBuilderCallback must not be null");
            return restClientBuilderCallback::apply;
        }
    }

    private record CustomHeaderInjector(Supplier<HttpHeaders> headersSupplier) implements HttpRequestInterceptor
    {
        public void process(HttpRequest request, HttpContext context) {
            HttpHeaders httpHeaders = this.headersSupplier.get();
            if (httpHeaders != null && !httpHeaders.isEmpty()) {
                Arrays.stream(OpenSearchClients.toHeaderArray(httpHeaders)).forEach(arg_0 -> ((HttpRequest)request).addHeader(arg_0));
            }
        }
    }

    public static interface OpenSearchHttpClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<HttpAsyncClientBuilder> {
        public static OpenSearchHttpClientConfigurationCallback from(Function<HttpAsyncClientBuilder, HttpAsyncClientBuilder> httpClientBuilderCallback) {
            Assert.notNull(httpClientBuilderCallback, (String)"httpClientBuilderCallback must not be null");
            return httpClientBuilderCallback::apply;
        }
    }
}

