/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchType;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.client.Requests;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetIndexTemplatesRequest;
import org.opensearch.client.indices.GetMappingsRequest;
import org.opensearch.client.indices.IndexTemplatesExistRequest;
import org.opensearch.client.indices.PutIndexTemplateRequest;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.common.geo.GeoDistance;
import org.opensearch.common.unit.DistanceUnit;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.data.client.orhlc.CriteriaFilterProcessor;
import org.opensearch.data.client.orhlc.CriteriaQueryProcessor;
import org.opensearch.data.client.orhlc.HighlightQueryBuilder;
import org.opensearch.data.client.orhlc.NativeSearchQuery;
import org.opensearch.data.client.orhlc.ScriptField;
import org.opensearch.index.VersionType;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.MoreLikeThisQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.RemoteInfo;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.rescore.QueryRescoreMode;
import org.opensearch.search.rescore.QueryRescorerBuilder;
import org.opensearch.search.rescore.RescorerBuilder;
import org.opensearch.search.slice.SliceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.GeoDistanceSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortMode;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.search.suggest.SuggestBuilder;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasAction;
import org.springframework.data.elasticsearch.core.index.AliasActionParameters;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.GeoDistanceOrder;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.data.elasticsearch.core.reindex.Remote;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class RequestFactory {
    static final Integer INDEX_MAX_RESULT_WINDOW = 10000;
    private final ElasticsearchConverter elasticsearchConverter;

    public RequestFactory(ElasticsearchConverter elasticsearchConverter) {
        this.elasticsearchConverter = elasticsearchConverter;
    }

    public GetAliasesRequest getAliasesRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new GetAliasesRequest().indices(indexNames);
    }

    public GetAliasesRequest getAliasesRequest(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliasNames);
        if (indexNames != null) {
            getAliasesRequest.indices(indexNames);
        }
        return getAliasesRequest;
    }

    public IndicesAliasesRequest indicesAliasesRequest(AliasActions aliasActions) {
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        aliasActions.getActions().forEach(aliasAction -> {
            IndicesAliasesRequest.AliasActions aliasActionsES = null;
            if (aliasAction instanceof AliasAction.Add) {
                AliasAction.Add add = (AliasAction.Add)aliasAction;
                IndicesAliasesRequest.AliasActions addES = IndicesAliasesRequest.AliasActions.add();
                AliasActionParameters parameters = add.getParameters();
                addES.indices(parameters.getIndices());
                addES.aliases(parameters.getAliases());
                addES.routing(parameters.getRouting());
                addES.indexRouting(parameters.getIndexRouting());
                addES.searchRouting(parameters.getSearchRouting());
                addES.isHidden(parameters.getHidden());
                addES.writeIndex(parameters.getWriteIndex());
                Query filterQuery = parameters.getFilterQuery();
                if (filterQuery != null) {
                    this.elasticsearchConverter.updateQuery(filterQuery, parameters.getFilterQueryClass());
                    QueryBuilder queryBuilder = this.getFilter(filterQuery);
                    if (queryBuilder == null) {
                        queryBuilder = this.getQuery(filterQuery);
                    }
                    addES.filter(queryBuilder);
                }
                aliasActionsES = addES;
            } else if (aliasAction instanceof AliasAction.Remove) {
                AliasAction.Remove remove = (AliasAction.Remove)aliasAction;
                IndicesAliasesRequest.AliasActions removeES = IndicesAliasesRequest.AliasActions.remove();
                AliasActionParameters parameters = remove.getParameters();
                removeES.indices(parameters.getIndices());
                removeES.aliases(parameters.getAliases());
                aliasActionsES = removeES;
            } else if (aliasAction instanceof AliasAction.RemoveIndex) {
                AliasAction.RemoveIndex removeIndex = (AliasAction.RemoveIndex)aliasAction;
                IndicesAliasesRequest.AliasActions removeIndexES = IndicesAliasesRequest.AliasActions.removeIndex();
                AliasActionParameters parameters = removeIndex.getParameters();
                removeIndexES.indices(new String[]{parameters.getIndices()[0]});
                aliasActionsES = removeIndexES;
            }
            if (aliasActionsES != null) {
                request.addAliasAction(aliasActionsES);
            }
        });
        return request;
    }

    public BulkRequest bulkRequest(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequest bulkRequest = new BulkRequest();
        if (bulkOptions.getTimeout() != null) {
            bulkRequest.timeout(TimeValue.timeValueMillis((long)bulkOptions.getTimeout().toMillis()));
        }
        if (bulkOptions.getRefreshPolicy() != null) {
            bulkRequest.setRefreshPolicy(RequestFactory.toOpenSearchRefreshPolicy(bulkOptions.getRefreshPolicy()));
        }
        if (bulkOptions.getWaitForActiveShards() != null) {
            bulkRequest.waitForActiveShards(ActiveShardCount.from((int)bulkOptions.getWaitForActiveShards().value()));
        }
        if (bulkOptions.getPipeline() != null) {
            bulkRequest.pipeline(bulkOptions.getPipeline());
        }
        if (bulkOptions.getRoutingId() != null) {
            bulkRequest.routing(bulkOptions.getRoutingId());
        }
        queries.forEach(query -> {
            if (query instanceof IndexQuery) {
                bulkRequest.add(this.indexRequest((IndexQuery)query, index));
            } else if (query instanceof UpdateQuery) {
                bulkRequest.add(this.updateRequest((UpdateQuery)query, index));
            }
        });
        return bulkRequest;
    }

    public CreateIndexRequest createIndexRequest(IndexCoordinates index, Map<String, Object> settings, @Nullable Document mapping) {
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notNull(settings, (String)"settings must not be null");
        CreateIndexRequest request = new CreateIndexRequest(index.getIndexName());
        if (!settings.isEmpty()) {
            request.settings(settings);
        }
        if (mapping != null && !mapping.isEmpty()) {
            request.mapping((Map)mapping);
        }
        return request;
    }

    public GetIndexRequest getIndexRequest(IndexCoordinates index) {
        return new GetIndexRequest(index.getIndexNames()).humanReadable(false);
    }

    public IndicesExistsRequest indicesExistsRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new IndicesExistsRequest(indexNames);
    }

    public DeleteIndexRequest deleteIndexRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new DeleteIndexRequest(indexNames);
    }

    public RefreshRequest refreshRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new RefreshRequest(indexNames);
    }

    public GetSettingsRequest getSettingsRequest(IndexCoordinates index, boolean includeDefaults) {
        String[] indexNames = index.getIndexNames();
        return new GetSettingsRequest().indices(indexNames).includeDefaults(includeDefaults);
    }

    public PutMappingRequest putMappingRequest(IndexCoordinates index, Document mapping) {
        PutMappingRequest request = new PutMappingRequest(index.getIndexNames());
        request.source((Map)mapping);
        return request;
    }

    public GetSettingsRequest getSettingsRequest(String indexName, boolean includeDefaults) {
        return new GetSettingsRequest().indices(new String[]{indexName}).includeDefaults(includeDefaults);
    }

    public GetMappingsRequest getMappingsRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new GetMappingsRequest().indices(indexNames);
    }

    public PutIndexTemplateRequest putIndexTemplateRequest(PutTemplateRequest putTemplateRequest) {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(putTemplateRequest.getName()).patterns(Arrays.asList(putTemplateRequest.getIndexPatterns()));
        if (putTemplateRequest.getSettings() != null) {
            request.settings((Map)putTemplateRequest.getSettings());
        }
        if (putTemplateRequest.getMappings() != null) {
            request.mapping((Map)putTemplateRequest.getMappings());
        }
        request.order(putTemplateRequest.getOrder()).version(putTemplateRequest.getVersion());
        AliasActions aliasActions = putTemplateRequest.getAliasActions();
        if (aliasActions != null) {
            aliasActions.getActions().forEach(aliasAction -> {
                AliasActionParameters parameters = aliasAction.getParameters();
                String[] parametersAliases = parameters.getAliases();
                if (parametersAliases != null) {
                    for (String aliasName : parametersAliases) {
                        Query filterQuery;
                        Alias alias = new Alias(aliasName);
                        if (parameters.getRouting() != null) {
                            alias.routing(parameters.getRouting());
                        }
                        if (parameters.getIndexRouting() != null) {
                            alias.indexRouting(parameters.getIndexRouting());
                        }
                        if (parameters.getSearchRouting() != null) {
                            alias.searchRouting(parameters.getSearchRouting());
                        }
                        if (parameters.getHidden() != null) {
                            alias.isHidden(parameters.getHidden());
                        }
                        if (parameters.getWriteIndex() != null) {
                            alias.writeIndex(parameters.getWriteIndex());
                        }
                        if ((filterQuery = parameters.getFilterQuery()) != null) {
                            this.elasticsearchConverter.updateQuery(filterQuery, parameters.getFilterQueryClass());
                            QueryBuilder queryBuilder = this.getFilter(filterQuery);
                            if (queryBuilder == null) {
                                queryBuilder = this.getQuery(filterQuery);
                            }
                            alias.filter(queryBuilder);
                        }
                        request.alias(alias);
                    }
                }
            });
        }
        return request;
    }

    public GetIndexTemplatesRequest getIndexTemplatesRequest(GetTemplateRequest getTemplateRequest) {
        return new GetIndexTemplatesRequest(new String[]{getTemplateRequest.getTemplateName()});
    }

    public IndexTemplatesExistRequest indexTemplatesExistsRequest(ExistsTemplateRequest existsTemplateRequest) {
        return new IndexTemplatesExistRequest(new String[]{existsTemplateRequest.getTemplateName()});
    }

    public DeleteIndexTemplateRequest deleteIndexTemplateRequest(DeleteTemplateRequest deleteTemplateRequest) {
        return new DeleteIndexTemplateRequest(deleteTemplateRequest.getTemplateName());
    }

    public org.opensearch.index.reindex.ReindexRequest reindexRequest(ReindexRequest reindexRequest) {
        Duration scroll;
        Duration timeout;
        ReindexRequest.Script script;
        IndexQuery.OpType opType;
        SourceFilter sourceFilter;
        ReindexRequest.Slice slice;
        org.opensearch.index.reindex.ReindexRequest request = new org.opensearch.index.reindex.ReindexRequest();
        if (reindexRequest.getConflicts() != null) {
            request.setConflicts(reindexRequest.getConflicts().getEsName());
        }
        if (reindexRequest.getMaxDocs() != null) {
            request.setMaxDocs(Math.toIntExact(reindexRequest.getMaxDocs()));
        }
        ReindexRequest.Source source = reindexRequest.getSource();
        request.setSourceIndices(source.getIndexes().getIndexNames());
        if (source.getQuery() != null && source.getRemote() == null) {
            request.setSourceQuery(this.getQuery(source.getQuery()));
        }
        if (source.getSize() != null) {
            request.setSourceBatchSize(source.getSize().intValue());
        }
        if (source.getRemote() != null) {
            BytesReference query;
            Remote remote = source.getRemote();
            MatchAllQueryBuilder queryBuilder = source.getQuery() == null ? QueryBuilders.matchAllQuery() : this.getQuery(source.getQuery());
            try {
                XContentBuilder builder = XContentBuilder.builder((XContent)RemoteInfo.QUERY_CONTENT_TYPE).prettyPrint();
                query = BytesReference.bytes((XContentBuilder)queryBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error parsing the source query content", e);
            }
            request.setRemoteInfo(new RemoteInfo(remote.getScheme(), remote.getHost(), remote.getPort(), remote.getPathPrefix(), query, remote.getUsername(), remote.getPassword(), Collections.emptyMap(), remote.getSocketTimeout() == null ? RemoteInfo.DEFAULT_SOCKET_TIMEOUT : TimeValue.timeValueSeconds((long)remote.getSocketTimeout().getSeconds()), remote.getConnectTimeout() == null ? RemoteInfo.DEFAULT_CONNECT_TIMEOUT : TimeValue.timeValueSeconds((long)remote.getConnectTimeout().getSeconds())));
        }
        if ((slice = source.getSlice()) != null) {
            request.getSearchRequest().source().slice(new SliceBuilder(slice.getId(), slice.getMax()));
        }
        if ((sourceFilter = source.getSourceFilter()) != null) {
            request.getSearchRequest().source().fetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        ReindexRequest.Dest dest = reindexRequest.getDest();
        request.setDestIndex(dest.getIndex().getIndexName()).setDestRouting(dest.getRouting()).setDestPipeline(dest.getPipeline());
        Document.VersionType versionType = dest.getVersionType();
        if (versionType != null) {
            request.setDestVersionType(VersionType.fromString((String)versionType.getEsName()));
        }
        if ((opType = dest.getOpType()) != null) {
            request.setDestOpType(opType.getEsName());
        }
        if ((script = reindexRequest.getScript()) != null) {
            request.setScript(new Script(Script.DEFAULT_SCRIPT_TYPE, script.getLang(), script.getSource(), Collections.emptyMap()));
        }
        if ((timeout = reindexRequest.getTimeout()) != null) {
            request.setTimeout(TimeValue.timeValueSeconds((long)timeout.getSeconds()));
        }
        if (reindexRequest.getRefresh() != null) {
            request.setRefresh(reindexRequest.getRefresh().booleanValue());
        }
        if (reindexRequest.getRequireAlias() != null) {
            request.setRequireAlias(reindexRequest.getRequireAlias().booleanValue());
        }
        if (reindexRequest.getRequestsPerSecond() != null) {
            request.setRequestsPerSecond((float)reindexRequest.getRequestsPerSecond().longValue());
        }
        if ((scroll = reindexRequest.getScroll()) != null) {
            request.setScroll(TimeValue.timeValueSeconds((long)scroll.getSeconds()));
        }
        if (reindexRequest.getWaitForActiveShards() != null) {
            request.setWaitForActiveShards(ActiveShardCount.parseString((String)reindexRequest.getWaitForActiveShards()));
        }
        if (reindexRequest.getSlices() != null) {
            request.setSlices(Math.toIntExact(reindexRequest.getSlices()));
        }
        return request;
    }

    public DeleteByQueryRequest deleteByQueryRequest(Query query, @Nullable String routing, Class<?> clazz, IndexCoordinates index, RefreshPolicy refreshPolicy) {
        SearchRequest searchRequest = this.searchRequest(query, routing, clazz, index);
        DeleteByQueryRequest deleteByQueryRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(index.getIndexNames()).setQuery(searchRequest.source().query()).setAbortOnVersionConflict(false)).setRefresh(RequestFactory.deleteByQueryRefresh(refreshPolicy));
        if (query.isLimiting()) {
            deleteByQueryRequest.setBatchSize(query.getMaxResults().intValue());
        }
        if (query.hasScrollTime()) {
            deleteByQueryRequest.setScroll(TimeValue.timeValueMillis((long)query.getScrollTime().toMillis()));
        }
        if (query.getRoute() != null) {
            deleteByQueryRequest.setRouting(query.getRoute());
        }
        return deleteByQueryRequest;
    }

    public DeleteRequest deleteRequest(String id, @Nullable String routing, IndexCoordinates index) {
        String indexName = index.getIndexName();
        DeleteRequest deleteRequest = new DeleteRequest(indexName, id);
        if (routing != null) {
            deleteRequest.routing(routing);
        }
        return deleteRequest;
    }

    public DeleteByQueryRequest documentDeleteByQueryRequest(DeleteQuery query, @Nullable String routing, Class<?> clazz, IndexCoordinates index, RefreshPolicy refreshPolicy) {
        SearchRequest searchRequest = this.searchRequest(query.getQuery(), routing, clazz, index);
        HashSet<IndicesOptions.Option> options = new HashSet<IndicesOptions.Option>();
        HashSet wildcardStates = new HashSet();
        if (query.getExpandWildcards() != null) {
            wildcardStates.addAll(query.getExpandWildcards().stream().map(it -> IndicesOptions.WildcardStates.valueOf((String)it.name().toUpperCase())).collect(Collectors.toSet()));
        }
        if (query.getIgnoreUnavailable() != null && query.getIgnoreUnavailable().booleanValue()) {
            options.add(IndicesOptions.Option.IGNORE_UNAVAILABLE);
        }
        if (query.getAllowNoIndices() != null && query.getAllowNoIndices().booleanValue()) {
            options.add(IndicesOptions.Option.ALLOW_NO_INDICES);
        }
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(index.getIndexNames()).setQuery(searchRequest.source().query()).setAbortOnVersionConflict(false)).setRefresh(RequestFactory.deleteByQueryRefresh(refreshPolicy))).setIndicesOptions(new org.opensearch.action.support.IndicesOptions(options.isEmpty() ? EnumSet.noneOf(IndicesOptions.Option.class) : EnumSet.copyOf(options), wildcardStates.isEmpty() ? EnumSet.noneOf(IndicesOptions.WildcardStates.class) : EnumSet.copyOf(wildcardStates)));
        return deleteByQueryRequest;
    }

    public GetRequest getRequest(String id, @Nullable String routing, IndexCoordinates index) {
        GetRequest getRequest = new GetRequest(index.getIndexName(), id);
        getRequest.routing(routing);
        return getRequest;
    }

    public MultiGetRequest multiGetRequest(Query query, Class<?> clazz, IndexCoordinates index) {
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        this.getMultiRequestItems(query, clazz, index).forEach(arg_0 -> ((MultiGetRequest)multiGetRequest).add(arg_0));
        return multiGetRequest;
    }

    private List<MultiGetRequest.Item> getMultiRequestItems(Query searchQuery, Class<?> clazz, IndexCoordinates index) {
        this.elasticsearchConverter.updateQuery(searchQuery, clazz);
        ArrayList<MultiGetRequest.Item> items = new ArrayList<MultiGetRequest.Item>();
        FetchSourceContext fetchSourceContext = this.getFetchSourceContext(searchQuery);
        if (!CollectionUtils.isEmpty((Collection)searchQuery.getIdsWithRouting())) {
            String indexName = index.getIndexName();
            for (Query.IdWithRouting idWithRouting : searchQuery.getIdsWithRouting()) {
                MultiGetRequest.Item item = new MultiGetRequest.Item(indexName, idWithRouting.id());
                if (idWithRouting.routing() != null) {
                    item = item.routing(idWithRouting.routing());
                }
                if (fetchSourceContext != null) {
                    item.fetchSourceContext(fetchSourceContext);
                }
                items.add(item);
            }
        }
        return items;
    }

    public IndexRequest indexRequest(IndexQuery query, IndexCoordinates index) {
        IndexRequest indexRequest;
        String indexName = query.getIndexName() != null ? query.getIndexName() : index.getIndexName();
        Object queryObject = query.getObject();
        if (queryObject != null) {
            String id = StringUtils.isEmpty((Object)query.getId()) ? this.getPersistentEntityId(queryObject) : query.getId();
            indexRequest = id != null ? new IndexRequest(indexName).id(id) : new IndexRequest(indexName);
            indexRequest.source(this.elasticsearchConverter.mapObject(queryObject).toJson(), Requests.INDEX_CONTENT_TYPE);
        } else if (query.getSource() != null) {
            indexRequest = new IndexRequest(indexName).id(query.getId()).source(query.getSource(), Requests.INDEX_CONTENT_TYPE);
        } else {
            throw new InvalidDataAccessApiUsageException("object or source is null, failed to index the document [id: " + query.getId() + "]");
        }
        if (query.getVersion() != null) {
            indexRequest.version(query.getVersion().longValue());
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(queryObject != null ? queryObject.getClass() : null);
            indexRequest.versionType(versionType);
        }
        if (query.getSeqNo() != null) {
            indexRequest.setIfSeqNo(query.getSeqNo().longValue());
        }
        if (query.getPrimaryTerm() != null) {
            indexRequest.setIfPrimaryTerm(query.getPrimaryTerm().longValue());
        }
        if (query.getRouting() != null) {
            indexRequest.routing(query.getRouting());
        }
        if (query.getOpType() != null) {
            switch (query.getOpType()) {
                case INDEX: {
                    indexRequest.opType(DocWriteRequest.OpType.INDEX);
                    break;
                }
                case CREATE: {
                    indexRequest.opType(DocWriteRequest.OpType.CREATE);
                }
            }
        }
        return indexRequest;
    }

    @Nullable
    public HighlightBuilder highlightBuilder(Query query) {
        NativeSearchQuery searchQuery;
        HighlightBuilder highlightBuilder = query.getHighlightQuery().map(highlightQuery -> new HighlightQueryBuilder(this.elasticsearchConverter.getMappingContext()).getHighlightBuilder(highlightQuery.getHighlight(), highlightQuery.getType())).orElse(null);
        if (highlightBuilder == null && query instanceof NativeSearchQuery && ((searchQuery = (NativeSearchQuery)query).getHighlightFields() != null && searchQuery.getHighlightFields().length > 0 || searchQuery.getHighlightBuilder() != null)) {
            highlightBuilder = searchQuery.getHighlightBuilder();
            if (highlightBuilder == null) {
                highlightBuilder = new HighlightBuilder();
            }
            if (searchQuery.getHighlightFields() != null) {
                for (HighlightBuilder.Field highlightField : searchQuery.getHighlightFields()) {
                    highlightBuilder.field(highlightField);
                }
            }
        }
        return highlightBuilder;
    }

    public MoreLikeThisQueryBuilder moreLikeThisQueryBuilder(MoreLikeThisQuery query, IndexCoordinates index) {
        String indexName = index.getIndexName();
        MoreLikeThisQueryBuilder.Item item = new MoreLikeThisQueryBuilder.Item(indexName, query.getId());
        String[] fields = query.getFields().toArray(new String[0]);
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery((String[])fields, null, (MoreLikeThisQueryBuilder.Item[])new MoreLikeThisQueryBuilder.Item[]{item});
        if (query.getMinTermFreq() != null) {
            moreLikeThisQueryBuilder.minTermFreq(query.getMinTermFreq().intValue());
        }
        if (query.getMaxQueryTerms() != null) {
            moreLikeThisQueryBuilder.maxQueryTerms(query.getMaxQueryTerms().intValue());
        }
        if (!CollectionUtils.isEmpty((Collection)query.getStopWords())) {
            moreLikeThisQueryBuilder.stopWords(query.getStopWords());
        }
        if (query.getMinDocFreq() != null) {
            moreLikeThisQueryBuilder.minDocFreq(query.getMinDocFreq().intValue());
        }
        if (query.getMaxDocFreq() != null) {
            moreLikeThisQueryBuilder.maxDocFreq(query.getMaxDocFreq().intValue());
        }
        if (query.getMinWordLen() != null) {
            moreLikeThisQueryBuilder.minWordLength(query.getMinWordLen().intValue());
        }
        if (query.getMaxWordLen() != null) {
            moreLikeThisQueryBuilder.maxWordLength(query.getMaxWordLen().intValue());
        }
        if (query.getBoostTerms() != null) {
            moreLikeThisQueryBuilder.boostTerms(query.getBoostTerms().floatValue());
        }
        return moreLikeThisQueryBuilder;
    }

    public SearchRequest searchRequest(SuggestBuilder suggestion, IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        SearchRequest searchRequest = new SearchRequest(indexNames);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.suggest(suggestion);
        searchRequest.source(sourceBuilder);
        return searchRequest;
    }

    public SearchRequest searchRequest(Query query, @Nullable String routing, @Nullable Class<?> clazz, IndexCoordinates index) {
        this.elasticsearchConverter.updateQuery(query, clazz);
        SearchRequest searchRequest = this.prepareSearchRequest(query, routing, clazz, index);
        QueryBuilder opensearchQuery = this.getQuery(query);
        QueryBuilder opensearchFilter = this.getFilter(query);
        searchRequest.source().query(opensearchQuery);
        if (opensearchFilter != null) {
            searchRequest.source().postFilter(opensearchFilter);
        }
        return searchRequest;
    }

    private SearchRequest prepareSearchRequest(Query query, @Nullable String routing, @Nullable Class<?> clazz, IndexCoordinates indexCoordinates) {
        SearchRequest request;
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        if (query.getPointInTime() == null) {
            Object[] indexNames = indexCoordinates.getIndexNames();
            Assert.notNull((Object)indexNames, (String)"No index defined for Query");
            Assert.notEmpty((Object[])indexNames, (String)"No index defined for Query");
            request = new SearchRequest((String[])indexNames);
        } else {
            request = new SearchRequest();
            PointInTimeBuilder pointInTimeBuilder = new PointInTimeBuilder(query.getPointInTime().id());
            pointInTimeBuilder.setKeepAlive(TimeValue.timeValueMillis((long)query.getPointInTime().keepAlive().toMillis()));
            sourceBuilder.pointInTimeBuilder(pointInTimeBuilder);
        }
        sourceBuilder.version(Boolean.valueOf(true));
        sourceBuilder.trackScores(query.getTrackScores());
        if (this.hasSeqNoPrimaryTermProperty(clazz)) {
            sourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true));
        }
        if (query.getPageable().isPaged()) {
            sourceBuilder.from((int)query.getPageable().getOffset());
            sourceBuilder.size(query.getPageable().getPageSize());
        } else {
            sourceBuilder.from(0);
            sourceBuilder.size(INDEX_MAX_RESULT_WINDOW.intValue());
        }
        if (query.getSourceFilter() != null) {
            sourceBuilder.fetchSource(this.getFetchSourceContext(query));
            SourceFilter sourceFilter = query.getSourceFilter();
            sourceBuilder.fetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (!query.getFields().isEmpty()) {
            query.getFields().forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).fetchField(arg_0));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getStoredFields())) {
            sourceBuilder.storedFields(query.getStoredFields());
        }
        if (query.getIndicesOptions() != null) {
            request.indicesOptions(this.toOpenSearchIndicesOptions(query.getIndicesOptions()));
        }
        if (query.isLimiting()) {
            sourceBuilder.size(query.getMaxResults().intValue());
        }
        if (query.getMinScore() > 0.0f) {
            sourceBuilder.minScore(query.getMinScore());
        }
        if (query.getPreference() != null) {
            request.preference(query.getPreference());
        }
        request.searchType(SearchType.fromString((String)query.getSearchType().name().toLowerCase()));
        this.prepareSort(query, sourceBuilder, this.getPersistentEntity(clazz));
        HighlightBuilder highlightBuilder = this.highlightBuilder(query);
        if (highlightBuilder != null) {
            sourceBuilder.highlighter(highlightBuilder);
        }
        if (query instanceof NativeSearchQuery) {
            this.prepareNativeSearch((NativeSearchQuery)query, sourceBuilder);
        }
        if (query.getTrackTotalHits() != null) {
            sourceBuilder.trackTotalHits(query.getTrackTotalHits().booleanValue());
        } else if (query.getTrackTotalHitsUpTo() != null) {
            sourceBuilder.trackTotalHitsUpTo(query.getTrackTotalHitsUpTo().intValue());
        }
        if (StringUtils.hasLength((String)query.getRoute())) {
            request.routing(query.getRoute());
        } else if (StringUtils.hasText((String)routing)) {
            request.routing(routing);
        }
        Duration timeout = query.getTimeout();
        if (timeout != null) {
            sourceBuilder.timeout(new TimeValue(timeout.toMillis()));
        }
        sourceBuilder.explain(Boolean.valueOf(query.getExplain()));
        if (query.getSearchAfter() != null) {
            sourceBuilder.searchAfter(query.getSearchAfter().toArray());
        }
        query.getRescorerQueries().forEach(rescorer -> sourceBuilder.addRescorer((RescorerBuilder)this.getQueryRescorerBuilder((RescorerQuery)rescorer)));
        if (query.getRequestCache() != null) {
            request.requestCache(query.getRequestCache());
        }
        if (query.getScrollTime() != null) {
            request.scroll(TimeValue.timeValueMillis((long)query.getScrollTime().toMillis()));
        }
        request.source(sourceBuilder);
        return request;
    }

    private void prepareNativeSearch(NativeSearchQuery query, SearchSourceBuilder sourceBuilder) {
        if (!query.getScriptFields().isEmpty()) {
            for (ScriptField scriptedField : query.getScriptFields()) {
                sourceBuilder.scriptField(scriptedField.fieldName(), scriptedField.script());
            }
        }
        if (query.getCollapseBuilder() != null) {
            sourceBuilder.collapse(query.getCollapseBuilder());
        }
        if (!CollectionUtils.isEmpty((Collection)query.getIndicesBoost())) {
            for (IndexBoost indexBoost : query.getIndicesBoost()) {
                sourceBuilder.indexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!CollectionUtils.isEmpty(query.getAggregations())) {
            query.getAggregations().forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).aggregation(arg_0));
        }
        if (!CollectionUtils.isEmpty(query.getPipelineAggregations())) {
            query.getPipelineAggregations().forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).aggregation(arg_0));
        }
        if (query.getSuggestBuilder() != null) {
            sourceBuilder.suggest(query.getSuggestBuilder());
        }
        if (!CollectionUtils.isEmpty(query.getSearchExtBuilders())) {
            sourceBuilder.ext(query.getSearchExtBuilders());
        }
    }

    private void prepareSort(Query query, SearchSourceBuilder sourceBuilder, @Nullable ElasticsearchPersistentEntity<?> entity) {
        NativeSearchQuery nativeSearchQuery;
        List<SortBuilder<?>> sorts;
        if (query.getSort() != null) {
            query.getSort().forEach(order -> sourceBuilder.sort(this.getSortBuilder((Sort.Order)order, entity)));
        }
        if (query instanceof NativeSearchQuery && (sorts = (nativeSearchQuery = (NativeSearchQuery)query).getOpenSearchSorts()) != null) {
            sorts.forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).sort(arg_0));
        }
    }

    private SortBuilder<?> getSortBuilder(Sort.Order order, @Nullable ElasticsearchPersistentEntity<?> entity) {
        String fieldName;
        SortOrder sortOrder = order.getDirection().isDescending() ? SortOrder.DESC : SortOrder.ASC;
        Order.Mode mode = null;
        String unmappedType = null;
        if (order instanceof Order) {
            Order o = (Order)order;
            mode = o.getMode();
            unmappedType = o.getUnmappedType();
        }
        if (mode == null) {
            mode = Order.Mode.min;
        }
        if ("_score".equals(order.getProperty())) {
            return SortBuilders.scoreSort().order(sortOrder);
        }
        ElasticsearchPersistentProperty property = entity != null ? (ElasticsearchPersistentProperty)entity.getPersistentProperty(order.getProperty()) : null;
        String string = fieldName = property != null ? property.getFieldName() : order.getProperty();
        if (order instanceof GeoDistanceOrder) {
            GeoDistanceOrder geoDistanceOrder = (GeoDistanceOrder)order;
            GeoDistanceSortBuilder sort = SortBuilders.geoDistanceSort((String)fieldName, (double)geoDistanceOrder.getGeoPoint().getLat(), (double)geoDistanceOrder.getGeoPoint().getLon());
            sort.geoDistance(GeoDistance.fromString((String)geoDistanceOrder.getDistanceType().name()));
            sort.sortMode(SortMode.fromString((String)mode.name()));
            sort.unit(DistanceUnit.fromString((String)geoDistanceOrder.getUnit()));
            if (geoDistanceOrder.getIgnoreUnmapped() != GeoDistanceOrder.DEFAULT_IGNORE_UNMAPPED) {
                sort.ignoreUnmapped(geoDistanceOrder.getIgnoreUnmapped().booleanValue());
            }
            return sort;
        }
        FieldSortBuilder sort = ((FieldSortBuilder)SortBuilders.fieldSort((String)fieldName).order(sortOrder)).sortMode(SortMode.fromString((String)mode.name()));
        if (unmappedType != null) {
            sort.unmappedType(unmappedType);
        }
        if (order.getNullHandling() == Sort.NullHandling.NULLS_FIRST) {
            sort.missing((Object)"_first");
        } else if (order.getNullHandling() == Sort.NullHandling.NULLS_LAST) {
            sort.missing((Object)"_last");
        }
        return sort;
    }

    private QueryRescorerBuilder getQueryRescorerBuilder(RescorerQuery rescorerQuery) {
        QueryBuilder queryBuilder = this.getQuery(rescorerQuery.getQuery());
        Assert.notNull((Object)"queryBuilder", (String)"Could not build query for rescorerQuery");
        QueryRescorerBuilder builder = new QueryRescorerBuilder(queryBuilder);
        if (rescorerQuery.getScoreMode() != RescorerQuery.ScoreMode.Default) {
            builder.setScoreMode(QueryRescoreMode.valueOf((String)rescorerQuery.getScoreMode().name()));
        }
        if (rescorerQuery.getQueryWeight() != null) {
            builder.setQueryWeight(rescorerQuery.getQueryWeight().floatValue());
        }
        if (rescorerQuery.getRescoreQueryWeight() != null) {
            builder.setRescoreQueryWeight(rescorerQuery.getRescoreQueryWeight().floatValue());
        }
        if (rescorerQuery.getWindowSize() != null) {
            builder.windowSize(rescorerQuery.getWindowSize().intValue());
        }
        return builder;
    }

    public UpdateRequest updateRequest(UpdateQuery query, IndexCoordinates index) {
        String indexName = query.getIndexName() != null ? query.getIndexName() : index.getIndexName();
        UpdateRequest updateRequest = new UpdateRequest(indexName, query.getId());
        if (query.getScript() != null) {
            HashMap params = query.getParams();
            if (params == null) {
                params = new HashMap();
            }
            Script script = new Script(this.getScriptType(query.getScriptType()), query.getLang(), query.getScript(), params);
            updateRequest.script(script);
        }
        if (query.getDocument() != null) {
            updateRequest.doc((Map)query.getDocument());
        }
        if (query.getUpsert() != null) {
            updateRequest.upsert((Map)query.getUpsert());
        }
        if (query.getRouting() != null) {
            updateRequest.routing(query.getRouting());
        }
        if (query.getScriptedUpsert() != null) {
            updateRequest.scriptedUpsert(query.getScriptedUpsert().booleanValue());
        }
        if (query.getDocAsUpsert() != null) {
            updateRequest.docAsUpsert(query.getDocAsUpsert().booleanValue());
        }
        if (query.getFetchSource() != null) {
            updateRequest.fetchSource(query.getFetchSource().booleanValue());
        }
        if (query.getFetchSourceIncludes() != null || query.getFetchSourceExcludes() != null) {
            List includes = query.getFetchSourceIncludes() != null ? query.getFetchSourceIncludes() : Collections.emptyList();
            List excludes = query.getFetchSourceExcludes() != null ? query.getFetchSourceExcludes() : Collections.emptyList();
            updateRequest.fetchSource(includes.toArray(new String[0]), excludes.toArray(new String[0]));
        }
        if (query.getIfSeqNo() != null) {
            updateRequest.setIfSeqNo((long)query.getIfSeqNo().intValue());
        }
        if (query.getIfPrimaryTerm() != null) {
            updateRequest.setIfPrimaryTerm((long)query.getIfPrimaryTerm().intValue());
        }
        if (query.getRefreshPolicy() != null) {
            updateRequest.setRefreshPolicy(RequestFactory.toOpenSearchRefreshPolicy(query.getRefreshPolicy()));
        }
        if (query.getRetryOnConflict() != null) {
            updateRequest.retryOnConflict(query.getRetryOnConflict().intValue());
        }
        if (query.getTimeout() != null) {
            updateRequest.timeout(query.getTimeout());
        }
        if (query.getWaitForActiveShards() != null) {
            updateRequest.waitForActiveShards(ActiveShardCount.parseString((String)query.getWaitForActiveShards()));
        }
        return updateRequest;
    }

    public UpdateByQueryRequest updateByQueryRequest(UpdateQuery query, IndexCoordinates index) {
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(index.getIndexNames());
        updateByQueryRequest.setScript(this.getScript(query));
        if (query.getAbortOnVersionConflict() != null) {
            updateByQueryRequest.setAbortOnVersionConflict(query.getAbortOnVersionConflict().booleanValue());
        }
        if (query.getBatchSize() != null) {
            updateByQueryRequest.setBatchSize(query.getBatchSize().intValue());
        }
        if (query.getQuery() != null) {
            Query queryQuery = query.getQuery();
            updateByQueryRequest.setQuery(this.getQuery(queryQuery));
            if (queryQuery.getIndicesOptions() != null) {
                updateByQueryRequest.setIndicesOptions(this.toOpenSearchIndicesOptions(queryQuery.getIndicesOptions()));
            }
            if (queryQuery.getScrollTime() != null) {
                updateByQueryRequest.setScroll(TimeValue.timeValueMillis((long)queryQuery.getScrollTime().toMillis()));
            }
        }
        if (query.getMaxDocs() != null) {
            updateByQueryRequest.setMaxDocs(query.getMaxDocs().intValue());
        }
        if (query.getMaxRetries() != null) {
            updateByQueryRequest.setMaxRetries(query.getMaxRetries().intValue());
        }
        if (query.getPipeline() != null) {
            updateByQueryRequest.setPipeline(query.getPipeline());
        }
        if (query.getRefreshPolicy() != null) {
            updateByQueryRequest.setRefresh(query.getRefreshPolicy() == RefreshPolicy.IMMEDIATE);
        }
        if (query.getRequestsPerSecond() != null) {
            updateByQueryRequest.setRequestsPerSecond(query.getRequestsPerSecond().floatValue());
        }
        if (query.getRouting() != null) {
            updateByQueryRequest.setRouting(query.getRouting());
        }
        if (query.getShouldStoreResult() != null) {
            updateByQueryRequest.setShouldStoreResult(query.getShouldStoreResult().booleanValue());
        }
        if (query.getSlices() != null) {
            updateByQueryRequest.setSlices(query.getSlices().intValue());
        }
        if (query.getTimeout() != null) {
            updateByQueryRequest.setTimeout(query.getTimeout());
        }
        if (query.getWaitForActiveShards() != null) {
            updateByQueryRequest.setWaitForActiveShards(ActiveShardCount.parseString((String)query.getWaitForActiveShards()));
        }
        return updateByQueryRequest;
    }

    @Nullable
    private QueryBuilder getQuery(Query query) {
        QueryBuilder opensearchQuery;
        if (query instanceof NativeSearchQuery) {
            NativeSearchQuery searchQuery = (NativeSearchQuery)query;
            opensearchQuery = searchQuery.getQuery();
        } else if (query instanceof CriteriaQuery) {
            CriteriaQuery criteriaQuery = (CriteriaQuery)query;
            opensearchQuery = new CriteriaQueryProcessor().createQuery(criteriaQuery.getCriteria());
        } else if (query instanceof StringQuery) {
            StringQuery stringQuery = (StringQuery)query;
            opensearchQuery = QueryBuilders.wrapperQuery((String)stringQuery.getSource());
        } else {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        return opensearchQuery;
    }

    @Nullable
    private QueryBuilder getFilter(Query query) {
        QueryBuilder opensearchFilter;
        if (query instanceof NativeSearchQuery) {
            NativeSearchQuery searchQuery = (NativeSearchQuery)query;
            opensearchFilter = searchQuery.getFilter();
        } else if (query instanceof CriteriaQuery) {
            CriteriaQuery criteriaQuery = (CriteriaQuery)query;
            opensearchFilter = new CriteriaFilterProcessor().createFilter(criteriaQuery.getCriteria());
        } else if (query instanceof StringQuery) {
            opensearchFilter = null;
        } else {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        return opensearchFilter;
    }

    public static WriteRequest.RefreshPolicy toOpenSearchRefreshPolicy(RefreshPolicy refreshPolicy) {
        switch (refreshPolicy) {
            case IMMEDIATE: {
                return WriteRequest.RefreshPolicy.IMMEDIATE;
            }
            case WAIT_UNTIL: {
                return WriteRequest.RefreshPolicy.WAIT_UNTIL;
            }
        }
        return WriteRequest.RefreshPolicy.NONE;
    }

    @Nullable
    private FetchSourceContext getFetchSourceContext(Query searchQuery) {
        SourceFilter sourceFilter = searchQuery.getSourceFilter();
        if (sourceFilter != null) {
            return new FetchSourceContext(true, sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        return null;
    }

    public org.opensearch.action.support.IndicesOptions toOpenSearchIndicesOptions(IndicesOptions indicesOptions) {
        Assert.notNull((Object)indicesOptions, (String)"indicesOptions must not be null");
        Set options = indicesOptions.getOptions().stream().map(it -> IndicesOptions.Option.valueOf((String)it.name().toUpperCase())).collect(Collectors.toSet());
        Set wildcardStates = indicesOptions.getExpandWildcards().stream().map(it -> IndicesOptions.WildcardStates.valueOf((String)it.name().toUpperCase())).collect(Collectors.toSet());
        return new org.opensearch.action.support.IndicesOptions(options.isEmpty() ? EnumSet.noneOf(IndicesOptions.Option.class) : EnumSet.copyOf(options), wildcardStates.isEmpty() ? EnumSet.noneOf(IndicesOptions.WildcardStates.class) : EnumSet.copyOf(wildcardStates));
    }

    @Nullable
    private ElasticsearchPersistentEntity<?> getPersistentEntity(@Nullable Class<?> clazz) {
        return clazz != null ? (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(clazz) : null;
    }

    @Nullable
    private String getPersistentEntityId(Object entity) {
        Object identifier;
        MappingContext mappingContext = this.elasticsearchConverter.getMappingContext();
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)mappingContext.getPersistentEntity(entity.getClass());
        if (persistentEntity != null && (identifier = persistentEntity.getIdentifierAccessor(entity).getIdentifier()) != null) {
            return identifier.toString();
        }
        return null;
    }

    private VersionType retrieveVersionTypeFromPersistentEntity(@Nullable Class<?> clazz) {
        Document.VersionType entityVersionType;
        MappingContext mappingContext = this.elasticsearchConverter.getMappingContext();
        ElasticsearchPersistentEntity persistentEntity = clazz != null ? (ElasticsearchPersistentEntity)mappingContext.getPersistentEntity(clazz) : null;
        VersionType versionType = null;
        if (persistentEntity != null && (entityVersionType = persistentEntity.getVersionType()) != null) {
            versionType = VersionType.fromString((String)entityVersionType.name().toLowerCase());
        }
        return versionType != null ? versionType : VersionType.EXTERNAL;
    }

    private String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }

    private boolean hasSeqNoPrimaryTermProperty(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            return false;
        }
        if (!this.elasticsearchConverter.getMappingContext().hasPersistentEntityFor(entityClass)) {
            return false;
        }
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(entityClass);
        return entity.hasSeqNoPrimaryTermProperty();
    }

    private ScriptType getScriptType(@Nullable org.springframework.data.elasticsearch.core.query.ScriptType scriptType) {
        if (scriptType == null || org.springframework.data.elasticsearch.core.query.ScriptType.INLINE.equals((Object)scriptType)) {
            return ScriptType.INLINE;
        }
        return ScriptType.STORED;
    }

    @Nullable
    private Script getScript(UpdateQuery query) {
        if (org.springframework.data.elasticsearch.core.query.ScriptType.STORED.equals((Object)query.getScriptType()) && query.getScriptName() != null) {
            Map params = Optional.ofNullable(query.getParams()).orElse(new HashMap());
            return new Script(this.getScriptType(org.springframework.data.elasticsearch.core.query.ScriptType.STORED), null, query.getScriptName(), params);
        }
        if (org.springframework.data.elasticsearch.core.query.ScriptType.INLINE.equals((Object)query.getScriptType()) && query.getScript() != null) {
            Map params = Optional.ofNullable(query.getParams()).orElse(new HashMap());
            return new Script(this.getScriptType(org.springframework.data.elasticsearch.core.query.ScriptType.INLINE), query.getLang(), query.getScript(), params);
        }
        return null;
    }

    static boolean deleteByQueryRefresh(@Nullable RefreshPolicy refreshPolicy) {
        if (refreshPolicy == null) {
            return false;
        }
        return switch (refreshPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case RefreshPolicy.IMMEDIATE -> true;
            case RefreshPolicy.WAIT_UNTIL, RefreshPolicy.NONE -> false;
        };
    }
}

