/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spring.boot.autoconfigure.data;

import java.util.Collections;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.data.client.osc.OpenSearchTemplate;
import org.opensearch.data.client.osc.ReactiveOpenSearchClient;
import org.opensearch.data.client.osc.ReactiveOpenSearchTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.persistence.autoconfigure.EntityScanner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchCustomConversions;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.mapping.context.MappingContext;

abstract class OpenSearchDataConfiguration {
    OpenSearchDataConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OpenSearchClient.class})
    static class ReactiveRestClientConfiguration {
        ReactiveRestClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveElasticsearchOperations.class}, name={"reactiveElasticsearchTemplate", "reactiveOpensearchTemplate"})
        @ConditionalOnBean(value={ReactiveOpenSearchClient.class})
        ReactiveOpenSearchTemplate reactiveElasticsearchTemplate(ReactiveOpenSearchClient client, ElasticsearchConverter converter) {
            return new ReactiveOpenSearchTemplate(client, converter);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OpenSearchClient.class})
    static class JavaClientConfiguration {
        JavaClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ElasticsearchOperations.class}, name={"elasticsearchTemplate", "opensearchTemplate"})
        @ConditionalOnBean(value={OpenSearchClient.class})
        OpenSearchTemplate elasticsearchTemplate(OpenSearchClient client, ElasticsearchConverter converter) {
            return new OpenSearchTemplate(client, converter);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class BaseConfiguration {
        BaseConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ElasticsearchCustomConversions elasticsearchCustomConversions() {
            return new ElasticsearchCustomConversions(Collections.emptyList());
        }

        @Bean
        @ConditionalOnMissingBean
        SimpleElasticsearchMappingContext mappingContext(ApplicationContext applicationContext, ElasticsearchCustomConversions elasticsearchCustomConversions) throws ClassNotFoundException {
            SimpleElasticsearchMappingContext mappingContext = new SimpleElasticsearchMappingContext();
            mappingContext.setInitialEntitySet(new EntityScanner(applicationContext).scan(new Class[]{Document.class}));
            mappingContext.setSimpleTypeHolder(elasticsearchCustomConversions.getSimpleTypeHolder());
            return mappingContext;
        }

        @Bean
        @ConditionalOnMissingBean
        ElasticsearchConverter elasticsearchConverter(SimpleElasticsearchMappingContext mappingContext, ElasticsearchCustomConversions elasticsearchCustomConversions) {
            MappingElasticsearchConverter converter = new MappingElasticsearchConverter((MappingContext)mappingContext);
            converter.setConversions((CustomConversions)elasticsearchCustomConversions);
            return converter;
        }
    }
}

