/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FingerprintAnalyzer
implements AnalyzerVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, FingerprintAnalyzer> {
    private final int maxOutputSize;
    private final boolean preserveOriginal;
    @Nonnull
    private final String separator;
    @Nonnull
    private final List<String> stopwords;
    @Nullable
    private final String stopwordsPath;
    @Nullable
    private final String version;
    public static final JsonpDeserializer<FingerprintAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FingerprintAnalyzer::setupFingerprintAnalyzerDeserializer);

    private FingerprintAnalyzer(Builder builder) {
        this.maxOutputSize = ApiTypeHelper.requireNonNull(builder.maxOutputSize, this, "maxOutputSize");
        this.preserveOriginal = ApiTypeHelper.requireNonNull(builder.preserveOriginal, this, "preserveOriginal");
        this.separator = ApiTypeHelper.requireNonNull(builder.separator, this, "separator");
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
        this.stopwordsPath = builder.stopwordsPath;
        this.version = builder.version;
    }

    public static FingerprintAnalyzer of(Function<Builder, ObjectBuilder<FingerprintAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Fingerprint;
    }

    public final int maxOutputSize() {
        return this.maxOutputSize;
    }

    public final boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Nonnull
    public final String separator() {
        return this.separator;
    }

    @Nonnull
    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Nullable
    public final String stopwordsPath() {
        return this.stopwordsPath;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "fingerprint");
        generator.writeKey("max_output_size");
        generator.write(this.maxOutputSize);
        generator.writeKey("preserve_original");
        generator.write(this.preserveOriginal);
        generator.writeKey("separator");
        generator.write(this.separator);
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.stopwordsPath != null) {
            generator.writeKey("stopwords_path");
            generator.write(this.stopwordsPath);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFingerprintAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxOutputSize, JsonpDeserializer.integerDeserializer(), "max_output_size");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.add(Builder::stopwordsPath, JsonpDeserializer.stringDeserializer(), "stopwords_path");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.maxOutputSize);
        result = 31 * result + Boolean.hashCode(this.preserveOriginal);
        result = 31 * result + this.separator.hashCode();
        result = 31 * result + Objects.hashCode(this.stopwords);
        result = 31 * result + Objects.hashCode(this.stopwordsPath);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FingerprintAnalyzer other = (FingerprintAnalyzer)o;
        return this.maxOutputSize == other.maxOutputSize && this.preserveOriginal == other.preserveOriginal && this.separator.equals(other.separator) && Objects.equals(this.stopwords, other.stopwords) && Objects.equals(this.stopwordsPath, other.stopwordsPath) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FingerprintAnalyzer> {
        private Integer maxOutputSize;
        private Boolean preserveOriginal;
        private String separator;
        @Nullable
        private List<String> stopwords;
        @Nullable
        private String stopwordsPath;
        @Nullable
        private String version;

        public Builder() {
        }

        private Builder(FingerprintAnalyzer o) {
            this.maxOutputSize = o.maxOutputSize;
            this.preserveOriginal = o.preserveOriginal;
            this.separator = o.separator;
            this.stopwords = Builder._listCopy(o.stopwords);
            this.stopwordsPath = o.stopwordsPath;
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.maxOutputSize = o.maxOutputSize;
            this.preserveOriginal = o.preserveOriginal;
            this.separator = o.separator;
            this.stopwords = Builder._listCopy(o.stopwords);
            this.stopwordsPath = o.stopwordsPath;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder maxOutputSize(int value) {
            this.maxOutputSize = value;
            return this;
        }

        @Nonnull
        public final Builder preserveOriginal(boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Nonnull
        public final Builder separator(String value) {
            this.separator = value;
            return this;
        }

        @Nonnull
        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        @Nonnull
        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        @Nonnull
        public final Builder stopwordsPath(@Nullable String value) {
            this.stopwordsPath = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public FingerprintAnalyzer build() {
            this._checkSingleUse();
            return new FingerprintAnalyzer(this);
        }
    }
}

