/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.dangling_indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NodeStatistics;
import org.opensearch.client.opensearch.dangling_indices.list_dangling_indices.DanglingIndex;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ListDanglingIndicesResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ListDanglingIndicesResponse> {
    @Nullable
    private final String clusterName;
    @Nonnull
    private final List<DanglingIndex> danglingIndices;
    @Nullable
    private final NodeStatistics nodes;
    public static final JsonpDeserializer<ListDanglingIndicesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ListDanglingIndicesResponse::setupListDanglingIndicesResponseDeserializer);

    private ListDanglingIndicesResponse(Builder builder) {
        this.clusterName = builder.clusterName;
        this.danglingIndices = ApiTypeHelper.unmodifiableRequired(builder.danglingIndices, (Object)this, "danglingIndices");
        this.nodes = builder.nodes;
    }

    public static ListDanglingIndicesResponse of(Function<Builder, ObjectBuilder<ListDanglingIndicesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String clusterName() {
        return this.clusterName;
    }

    @Nonnull
    public final List<DanglingIndex> danglingIndices() {
        return this.danglingIndices;
    }

    @Nullable
    public final NodeStatistics nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.clusterName != null) {
            generator.writeKey("cluster_name");
            generator.write(this.clusterName);
        }
        generator.writeKey("dangling_indices");
        generator.writeStartArray();
        for (DanglingIndex item0 : this.danglingIndices) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.nodes != null) {
            generator.writeKey("_nodes");
            this.nodes.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupListDanglingIndicesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::danglingIndices, JsonpDeserializer.arrayDeserializer(DanglingIndex._DESERIALIZER), "dangling_indices");
        op.add(Builder::nodes, NodeStatistics._DESERIALIZER, "_nodes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterName);
        result = 31 * result + this.danglingIndices.hashCode();
        result = 31 * result + Objects.hashCode(this.nodes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListDanglingIndicesResponse other = (ListDanglingIndicesResponse)o;
        return Objects.equals(this.clusterName, other.clusterName) && this.danglingIndices.equals(other.danglingIndices) && Objects.equals(this.nodes, other.nodes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ListDanglingIndicesResponse> {
        @Nullable
        private String clusterName;
        private List<DanglingIndex> danglingIndices;
        @Nullable
        private NodeStatistics nodes;

        public Builder() {
        }

        private Builder(ListDanglingIndicesResponse o) {
            this.clusterName = o.clusterName;
            this.danglingIndices = Builder._listCopy(o.danglingIndices);
            this.nodes = o.nodes;
        }

        private Builder(Builder o) {
            this.clusterName = o.clusterName;
            this.danglingIndices = Builder._listCopy(o.danglingIndices);
            this.nodes = o.nodes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder clusterName(@Nullable String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder danglingIndices(List<DanglingIndex> list) {
            this.danglingIndices = Builder._listAddAll(this.danglingIndices, list);
            return this;
        }

        @Nonnull
        public final Builder danglingIndices(DanglingIndex value, DanglingIndex ... values) {
            this.danglingIndices = Builder._listAdd(this.danglingIndices, value, values);
            return this;
        }

        @Nonnull
        public final Builder danglingIndices(Function<DanglingIndex.Builder, ObjectBuilder<DanglingIndex>> fn) {
            return this.danglingIndices(fn.apply(new DanglingIndex.Builder()).build(), new DanglingIndex[0]);
        }

        @Nonnull
        public final Builder nodes(@Nullable NodeStatistics value) {
            this.nodes = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(Function<NodeStatistics.Builder, ObjectBuilder<NodeStatistics>> fn) {
            return this.nodes(fn.apply(new NodeStatistics.Builder()).build());
        }

        @Override
        @Nonnull
        public ListDanglingIndicesResponse build() {
            this._checkSingleUse();
            return new ListDanglingIndicesResponse(this);
        }
    }
}

