/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.core.SearchShardsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class SearchShardsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, SearchShardsRequest> {
    @Nullable
    private final Boolean allowNoIndices;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nonnull
    private final List<String> index;
    @Nullable
    private final Boolean local;
    @Nullable
    private final String preference;
    @Nonnull
    private final List<String> routing;
    public static final Endpoint<SearchShardsRequest, SearchShardsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SearchShardsRequest, SearchShardsResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_search_shards";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            buf.append("/_search_shards");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, SearchShardsResponse._DESERIALIZER);

    private SearchShardsRequest(Builder builder) {
        super(builder);
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.local = builder.local;
        this.preference = builder.preference;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
    }

    public static SearchShardsRequest of(Function<Builder, ObjectBuilder<SearchShardsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nonnull
    public final List<String> routing() {
        return this.routing;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(this.allowNoIndices));
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(this.ignoreUnavailable));
        }
        if (this.local != null) {
            params.put("local", String.valueOf(this.local));
        }
        if (this.preference != null) {
            params.put("preference", this.preference);
        }
        if (ApiTypeHelper.isDefined(this.routing)) {
            params.put("routing", String.join((CharSequence)",", this.routing));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowNoIndices);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.local);
        result = 31 * result + Objects.hashCode(this.preference);
        result = 31 * result + Objects.hashCode(this.routing);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardsRequest other = (SearchShardsRequest)o;
        return Objects.equals(this.allowNoIndices, other.allowNoIndices) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && Objects.equals(this.index, other.index) && Objects.equals(this.local, other.local) && Objects.equals(this.preference, other.preference) && Objects.equals(this.routing, other.routing);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SearchShardsRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean local;
        @Nullable
        private String preference;
        @Nullable
        private List<String> routing;

        public Builder() {
        }

        private Builder(SearchShardsRequest o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.local = o.local;
            this.preference = o.preference;
            this.routing = Builder._listCopy(o.routing);
        }

        private Builder(Builder o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.local = o.local;
            this.preference = o.preference;
            this.routing = Builder._listCopy(o.routing);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Nonnull
        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        @Nonnull
        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        @Nonnull
        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        @Nonnull
        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        @Override
        @Nonnull
        public SearchShardsRequest build() {
            this._checkSingleUse();
            return new SearchShardsRequest(this);
        }
    }
}

