/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ClusterNodeCount
implements JsonpSerializable {
    private final int coordinatingOnly;
    private final int data;
    private final int ingest;
    @Deprecated
    private final Integer master;
    private final Integer clusterManager;
    private final int total;
    private final int remoteClusterClient;
    @Nullable
    private final Integer search;
    public static final JsonpDeserializer<ClusterNodeCount> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNodeCount::setupClusterNodeCountDeserializer);

    private ClusterNodeCount(Builder builder) {
        this.coordinatingOnly = ApiTypeHelper.requireNonNull(builder.coordinatingOnly, this, "coordinatingOnly");
        this.data = ApiTypeHelper.requireNonNull(builder.data, this, "data");
        this.ingest = ApiTypeHelper.requireNonNull(builder.ingest, this, "ingest");
        this.master = builder.master;
        this.clusterManager = builder.clusterManager;
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.remoteClusterClient = ApiTypeHelper.requireNonNull(builder.remoteClusterClient, this, "remoteClusterClient");
        this.search = builder.search;
    }

    public static ClusterNodeCount of(Function<Builder, ObjectBuilder<ClusterNodeCount>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int coordinatingOnly() {
        return this.coordinatingOnly;
    }

    public final int data() {
        return this.data;
    }

    public final int ingest() {
        return this.ingest;
    }

    @Deprecated
    public final int master() {
        return this.master;
    }

    public final int clusterManager() {
        return this.clusterManager;
    }

    public final int total() {
        return this.total;
    }

    public final int remoteClusterClient() {
        return this.remoteClusterClient;
    }

    @Nullable
    public final Integer search() {
        return this.search;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("coordinating_only");
        generator.write(this.coordinatingOnly);
        generator.writeKey("data");
        generator.write(this.data);
        generator.writeKey("ingest");
        generator.write(this.ingest);
        if (this.master != null) {
            generator.writeKey("master");
            generator.write(this.master.intValue());
        }
        if (this.clusterManager != null) {
            generator.writeKey("cluster_manager");
            generator.write(this.clusterManager.intValue());
        }
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("remote_cluster_client");
        generator.write(this.remoteClusterClient);
        if (this.search != null) {
            generator.writeKey("search");
            generator.write(this.search.intValue());
        }
    }

    protected static void setupClusterNodeCountDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::coordinatingOnly, JsonpDeserializer.integerDeserializer(), "coordinating_only");
        op.add(Builder::data, JsonpDeserializer.integerDeserializer(), "data");
        op.add(Builder::ingest, JsonpDeserializer.integerDeserializer(), "ingest");
        op.add(Builder::master, JsonpDeserializer.integerDeserializer(), "master");
        op.add(Builder::clusterManager, JsonpDeserializer.integerDeserializer(), "cluster_manager");
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::remoteClusterClient, JsonpDeserializer.integerDeserializer(), "remote_cluster_client");
        op.add(Builder::search, JsonpDeserializer.integerDeserializer(), "search");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterNodeCount> {
        private Integer coordinatingOnly;
        private Integer data;
        private Integer ingest;
        private Integer master;
        private Integer clusterManager;
        private Integer total;
        private Integer remoteClusterClient;
        private Integer search;

        public final Builder coordinatingOnly(int value) {
            this.coordinatingOnly = value;
            return this;
        }

        public final Builder data(int value) {
            this.data = value;
            return this;
        }

        public final Builder ingest(int value) {
            this.ingest = value;
            return this;
        }

        @Deprecated
        public final Builder master(int value) {
            this.master = value;
            return this;
        }

        public final Builder clusterManager(int value) {
            this.clusterManager = value;
            return this;
        }

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder remoteClusterClient(int value) {
            this.remoteClusterClient = value;
            return this;
        }

        @Nullable
        public final Builder search(int value) {
            this.search = value;
            return this;
        }

        @Override
        public ClusterNodeCount build() {
            this._checkSingleUse();
            return new ClusterNodeCount(this);
        }
    }
}

