/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.indices.DataStream;
import org.opensearch.client.opensearch.indices.PutIndexTemplateResponse;
import org.opensearch.client.opensearch.indices.put_index_template.IndexTemplateMapping;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class PutIndexTemplateRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, JsonData> meta;
    private final List<String> composedOf;
    @Nullable
    private final DataStream dataStream;
    private final List<String> indexPatterns;
    private final String name;
    @Nullable
    private final Integer priority;
    @Nullable
    private final IndexTemplateMapping template;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<PutIndexTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutIndexTemplateRequest::setupPutIndexTemplateRequestDeserializer);
    public static final Endpoint<PutIndexTemplateRequest, PutIndexTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutIndexTemplateRequest, PutIndexTemplateResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutIndexTemplateResponse._DESERIALIZER);

    private PutIndexTemplateRequest(Builder builder) {
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.composedOf = ApiTypeHelper.unmodifiable(builder.composedOf);
        this.dataStream = builder.dataStream;
        this.indexPatterns = ApiTypeHelper.unmodifiable(builder.indexPatterns);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.priority = builder.priority;
        this.template = builder.template;
        this.version = builder.version;
    }

    public static PutIndexTemplateRequest of(Function<Builder, ObjectBuilder<PutIndexTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    public final List<String> composedOf() {
        return this.composedOf;
    }

    @Nullable
    public final DataStream dataStream() {
        return this.dataStream;
    }

    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Integer priority() {
        return this.priority;
    }

    @Nullable
    public final IndexTemplateMapping template() {
        return this.template;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.composedOf)) {
            generator.writeKey("composed_of");
            generator.writeStartArray();
            for (String string : this.composedOf) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            this.dataStream.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.intValue());
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    protected static void setupPutIndexTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::composedOf, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "composed_of");
        op.add(Builder::dataStream, DataStream._DESERIALIZER, "data_stream");
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::priority, JsonpDeserializer.integerDeserializer(), "priority");
        op.add(Builder::template, IndexTemplateMapping._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PutIndexTemplateRequest> {
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private List<String> composedOf;
        @Nullable
        private DataStream dataStream;
        @Nullable
        private List<String> indexPatterns;
        private String name;
        @Nullable
        private Integer priority;
        @Nullable
        private IndexTemplateMapping template;
        @Nullable
        private Long version;

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder composedOf(List<String> list) {
            this.composedOf = Builder._listAddAll(this.composedOf, list);
            return this;
        }

        public final Builder composedOf(String value, String ... values) {
            this.composedOf = Builder._listAdd(this.composedOf, value, values);
            return this;
        }

        public final Builder dataStream(@Nullable DataStream value) {
            this.dataStream = value;
            return this;
        }

        public final Builder dataStream(Function<DataStream.Builder, ObjectBuilder<DataStream>> fn) {
            return this.dataStream(fn.apply(new DataStream.Builder()).build());
        }

        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder priority(@Nullable Integer value) {
            this.priority = value;
            return this;
        }

        public final Builder template(@Nullable IndexTemplateMapping value) {
            this.template = value;
            return this;
        }

        public final Builder template(Function<IndexTemplateMapping.Builder, ObjectBuilder<IndexTemplateMapping>> fn) {
            return this.template(fn.apply(new IndexTemplateMapping.Builder()).build());
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        public PutIndexTemplateRequest build() {
            this._checkSingleUse();
            return new PutIndexTemplateRequest(this);
        }
    }
}

