/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class DataStreamStats
implements JsonpSerializable {
    private final String dataStream;
    private final int backingIndices;
    private final long storeSizeBytes;
    private final long maximumTimestamp;
    @Nullable
    private final String storeSize;
    public static final JsonpDeserializer<DataStreamStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamStats::setupDataStreamStatsDeserializer);

    private DataStreamStats(Builder builder) {
        this.dataStream = ApiTypeHelper.requireNonNull(builder.dataStream, this, "dataStream");
        this.backingIndices = ApiTypeHelper.requireNonNull(builder.backingIndices, this, "backingIndices");
        this.storeSizeBytes = ApiTypeHelper.requireNonNull(builder.storeSizeBytes, this, "storeSizeBytes");
        this.maximumTimestamp = ApiTypeHelper.requireNonNull(builder.maximumTimestamp, this, "maximumTimestamp");
        this.storeSize = builder.storeSize;
    }

    public static DataStreamStats of(Function<Builder, ObjectBuilder<DataStreamStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String dataStream() {
        return this.dataStream;
    }

    public final int backingIndices() {
        return this.backingIndices;
    }

    public final long storeSizeBytes() {
        return this.storeSizeBytes;
    }

    public final long maximumTimestamp() {
        return this.maximumTimestamp;
    }

    @Nullable
    public final String storeSize() {
        return this.storeSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data_stream");
        generator.write(this.dataStream);
        generator.writeKey("backing_indices");
        generator.write(this.backingIndices);
        generator.writeKey("store_size_bytes");
        generator.write(this.storeSizeBytes);
        generator.writeKey("maximum_timestamp");
        generator.write(this.maximumTimestamp);
        if (this.storeSize != null) {
            generator.writeKey("store_size");
            generator.write(this.storeSize);
        }
    }

    protected static void setupDataStreamStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream");
        op.add(Builder::backingIndices, JsonpDeserializer.integerDeserializer(), "backing_indices");
        op.add(Builder::storeSize, JsonpDeserializer.stringDeserializer(), "store_size");
        op.add(Builder::storeSizeBytes, JsonpDeserializer.longDeserializer(), "store_size_bytes");
        op.add(Builder::maximumTimestamp, JsonpDeserializer.longDeserializer(), "maximum_timestamp");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataStreamStats> {
        private String dataStream;
        private int backingIndices;
        private long storeSizeBytes;
        private long maximumTimestamp;
        @Nullable
        private String storeSize;

        public final Builder dataStream(String value) {
            this.dataStream = value;
            return this;
        }

        public final Builder backingIndices(int value) {
            this.backingIndices = value;
            return this;
        }

        public final Builder storeSizeBytes(long value) {
            this.storeSizeBytes = value;
            return this;
        }

        public final Builder maximumTimestamp(long value) {
            this.maximumTimestamp = value;
            return this;
        }

        public final Builder storeSize(@Nullable String value) {
            this.storeSize = value;
            return this;
        }

        @Override
        public DataStreamStats build() {
            this._checkSingleUse();
            return new DataStreamStats(this);
        }
    }
}

