/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.ScoreCombinationTechnique;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ScoreCombination
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ScoreCombination> {
    @Nonnull
    private final List<Float> parameters;
    @Nullable
    private final ScoreCombinationTechnique technique;
    public static final JsonpDeserializer<ScoreCombination> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScoreCombination::setupScoreCombinationDeserializer);

    private ScoreCombination(Builder builder) {
        this.parameters = ApiTypeHelper.unmodifiable(builder.parameters);
        this.technique = builder.technique;
    }

    public static ScoreCombination of(Function<Builder, ObjectBuilder<ScoreCombination>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<Float> parameters() {
        return this.parameters;
    }

    @Nullable
    public final ScoreCombinationTechnique technique() {
        return this.technique;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.parameters)) {
            generator.writeKey("parameters");
            generator.writeStartArray();
            for (Float item0 : this.parameters) {
                generator.write((double)item0.floatValue());
            }
            generator.writeEnd();
        }
        if (this.technique != null) {
            generator.writeKey("technique");
            this.technique.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupScoreCombinationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::parameters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.floatDeserializer()), "parameters");
        op.add(Builder::technique, ScoreCombinationTechnique._DESERIALIZER, "technique");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + Objects.hashCode(this.technique);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoreCombination other = (ScoreCombination)o;
        return Objects.equals(this.parameters, other.parameters) && Objects.equals(this.technique, other.technique);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ScoreCombination> {
        @Nullable
        private List<Float> parameters;
        @Nullable
        private ScoreCombinationTechnique technique;

        public Builder() {
        }

        private Builder(ScoreCombination o) {
            this.parameters = Builder._listCopy(o.parameters);
            this.technique = o.technique;
        }

        private Builder(Builder o) {
            this.parameters = Builder._listCopy(o.parameters);
            this.technique = o.technique;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder parameters(List<Float> list) {
            this.parameters = Builder._listAddAll(this.parameters, list);
            return this;
        }

        @Nonnull
        public final Builder parameters(Float value, Float ... values) {
            this.parameters = Builder._listAdd(this.parameters, value, values);
            return this;
        }

        @Nonnull
        public final Builder technique(@Nullable ScoreCombinationTechnique value) {
            this.technique = value;
            return this;
        }

        @Override
        @Nonnull
        public ScoreCombination build() {
            this._checkSingleUse();
            return new ScoreCombination(this);
        }
    }
}

