/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class TextEmbeddingProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String modelId;
    private final Map<String, String> fieldMap;
    @Nullable
    private final String description;
    public static final JsonpDeserializer<TextEmbeddingProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextEmbeddingProcessor::setupTextEmbeddingProcessorDeserializer);

    private TextEmbeddingProcessor(Builder builder) {
        super(builder);
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.fieldMap = ApiTypeHelper.unmodifiableRequired(builder.fieldMap, (Object)this, "fieldMap");
        this.description = builder.description;
    }

    public static TextEmbeddingProcessor of(Function<Builder, ObjectBuilder<TextEmbeddingProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.TextEmbedding;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final Map<String, String> fieldMap() {
        return this.fieldMap;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (ApiTypeHelper.isDefined(this.fieldMap)) {
            generator.writeKey("field_map");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.fieldMap.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
    }

    protected static void setupTextEmbeddingProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::fieldMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "field_map");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TextEmbeddingProcessor> {
        private String modelId;
        @Nullable
        private Map<String, String> fieldMap;
        @Nullable
        private String description;

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder fieldMap(Map<String, String> map) {
            this.fieldMap = Builder._mapPutAll(this.fieldMap, map);
            return this;
        }

        public final Builder fieldMap(String key, String value) {
            this.fieldMap = Builder._mapPut(this.fieldMap, key, value);
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextEmbeddingProcessor build() {
            this._checkSingleUse();
            return new TextEmbeddingProcessor(this);
        }
    }
}

