/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class FuzzyQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final Integer maxExpansions;
    @Nullable
    private final Integer prefixLength;
    @Nullable
    private final String rewrite;
    @Nullable
    private final Boolean transpositions;
    @Nullable
    private final String fuzziness;
    private final FieldValue value;
    public static final JsonpDeserializer<FuzzyQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FuzzyQuery::setupFuzzyQueryDeserializer);

    private FuzzyQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.maxExpansions = builder.maxExpansions;
        this.prefixLength = builder.prefixLength;
        this.rewrite = builder.rewrite;
        this.transpositions = builder.transpositions;
        this.fuzziness = builder.fuzziness;
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static FuzzyQuery of(Function<Builder, ObjectBuilder<FuzzyQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Fuzzy;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Integer maxExpansions() {
        return this.maxExpansions;
    }

    @Nullable
    public final Integer prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public final String rewrite() {
        return this.rewrite;
    }

    @Nullable
    public final Boolean transpositions() {
        return this.transpositions;
    }

    @Nullable
    public final String fuzziness() {
        return this.fuzziness;
    }

    public final FieldValue value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.maxExpansions != null) {
            generator.writeKey("max_expansions");
            generator.write(this.maxExpansions.intValue());
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        if (this.rewrite != null) {
            generator.writeKey("rewrite");
            generator.write(this.rewrite);
        }
        if (this.transpositions != null) {
            generator.writeKey("transpositions");
            generator.write(this.transpositions.booleanValue());
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return new Builder().field(this.field).value(this.value).maxExpansions(this.maxExpansions).prefixLength(this.prefixLength).rewrite(this.rewrite).transpositions(this.transpositions).fuzziness(this.fuzziness).value(this.value);
    }

    protected static void setupFuzzyQueryDeserializer(ObjectDeserializer<Builder> op) {
        FuzzyQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::maxExpansions, JsonpDeserializer.integerDeserializer(), "max_expansions");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::rewrite, JsonpDeserializer.stringDeserializer(), "rewrite");
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions");
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness");
        op.add(Builder::value, FieldValue._DESERIALIZER, "value");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FuzzyQuery> {
        private String field;
        @Nullable
        private Integer maxExpansions;
        @Nullable
        private Integer prefixLength;
        @Nullable
        private String rewrite;
        @Nullable
        private Boolean transpositions;
        @Nullable
        private String fuzziness;
        private FieldValue value;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder maxExpansions(@Nullable Integer value) {
            this.maxExpansions = value;
            return this;
        }

        public final Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder rewrite(@Nullable String value) {
            this.rewrite = value;
            return this;
        }

        public final Builder transpositions(@Nullable Boolean value) {
            this.transpositions = value;
            return this;
        }

        public final Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public final Builder value(FieldValue value) {
            this.value = value;
            return this;
        }

        public final Builder value(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.value(fn.apply(new FieldValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FuzzyQuery build() {
            this._checkSingleUse();
            return new FuzzyQuery(this);
        }
    }
}

