/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class StringStatsAggregate
extends AggregateBase
implements AggregateVariant {
    private final long count;
    private final int minLength;
    private final int maxLength;
    private final double avgLength;
    private final double entropy;
    @Nullable
    private final String distribution;
    @Nullable
    private final String minLengthAsString;
    @Nullable
    private final String maxLengthAsString;
    @Nullable
    private final String avgLengthAsString;
    public static final JsonpDeserializer<StringStatsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StringStatsAggregate::setupStringStatsAggregateDeserializer);

    private StringStatsAggregate(Builder builder) {
        super(builder);
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.minLength = ApiTypeHelper.requireNonNull(builder.minLength, this, "minLength");
        this.maxLength = ApiTypeHelper.requireNonNull(builder.maxLength, this, "maxLength");
        this.avgLength = ApiTypeHelper.requireNonNull(builder.avgLength, this, "avgLength");
        this.entropy = ApiTypeHelper.requireNonNull(builder.entropy, this, "entropy");
        this.distribution = builder.distribution;
        this.minLengthAsString = builder.minLengthAsString;
        this.maxLengthAsString = builder.maxLengthAsString;
        this.avgLengthAsString = builder.avgLengthAsString;
    }

    public static StringStatsAggregate of(Function<Builder, ObjectBuilder<StringStatsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.StringStats;
    }

    public final long count() {
        return this.count;
    }

    public final int minLength() {
        return this.minLength;
    }

    public final int maxLength() {
        return this.maxLength;
    }

    public final double avgLength() {
        return this.avgLength;
    }

    public final double entropy() {
        return this.entropy;
    }

    @Nullable
    public final String distribution() {
        return this.distribution;
    }

    @Nullable
    public final String minLengthAsString() {
        return this.minLengthAsString;
    }

    @Nullable
    public final String maxLengthAsString() {
        return this.maxLengthAsString;
    }

    @Nullable
    public final String avgLengthAsString() {
        return this.avgLengthAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("min_length");
        JsonpUtils.serializeIntOrNull(generator, this.minLength, 0);
        generator.writeKey("max_length");
        JsonpUtils.serializeIntOrNull(generator, this.maxLength, 0);
        generator.writeKey("avg_length");
        JsonpUtils.serializeDoubleOrNull(generator, this.avgLength, 0.0);
        generator.writeKey("entropy");
        JsonpUtils.serializeDoubleOrNull(generator, this.entropy, 0.0);
        if (this.distribution != null) {
            generator.writeKey("distribution");
            generator.write(this.distribution);
        }
        if (this.minLengthAsString != null) {
            generator.writeKey("min_length_as_string");
            generator.write(this.minLengthAsString);
        }
        if (this.maxLengthAsString != null) {
            generator.writeKey("max_length_as_string");
            generator.write(this.maxLengthAsString);
        }
        if (this.avgLengthAsString != null) {
            generator.writeKey("avg_length_as_string");
            generator.write(this.avgLengthAsString);
        }
    }

    protected static void setupStringStatsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        StringStatsAggregate.setupAggregateBaseDeserializer(op);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::minLength, JsonpDeserializer.intOrNullDeserializer(0), "min_length");
        op.add(Builder::maxLength, JsonpDeserializer.intOrNullDeserializer(0), "max_length");
        op.add(Builder::avgLength, JsonpDeserializer.doubleOrNullDeserializer(0.0), "avg_length");
        op.add(Builder::entropy, JsonpDeserializer.doubleOrNullDeserializer(0.0), "entropy");
        op.add(Builder::distribution, JsonpDeserializer.stringDeserializer(), "distribution");
        op.add(Builder::minLengthAsString, JsonpDeserializer.stringDeserializer(), "min_length_as_string");
        op.add(Builder::maxLengthAsString, JsonpDeserializer.stringDeserializer(), "max_length_as_string");
        op.add(Builder::avgLengthAsString, JsonpDeserializer.stringDeserializer(), "avg_length_as_string");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StringStatsAggregate> {
        private Long count;
        private Integer minLength;
        private Integer maxLength;
        private Double avgLength;
        private Double entropy;
        @Nullable
        private String distribution;
        @Nullable
        private String minLengthAsString;
        @Nullable
        private String maxLengthAsString;
        @Nullable
        private String avgLengthAsString;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder minLength(int value) {
            this.minLength = value;
            return this;
        }

        public final Builder maxLength(int value) {
            this.maxLength = value;
            return this;
        }

        public final Builder avgLength(double value) {
            this.avgLength = value;
            return this;
        }

        public final Builder entropy(double value) {
            this.entropy = value;
            return this;
        }

        public final Builder distribution(@Nullable String value) {
            this.distribution = value;
            return this;
        }

        public final Builder minLengthAsString(@Nullable String value) {
            this.minLengthAsString = value;
            return this;
        }

        public final Builder maxLengthAsString(@Nullable String value) {
            this.maxLengthAsString = value;
            return this;
        }

        public final Builder avgLengthAsString(@Nullable String value) {
            this.avgLengthAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StringStatsAggregate build() {
            this._checkSingleUse();
            return new StringStatsAggregate(this);
        }
    }
}

