/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.stereo.Octahedral;
import org.openscience.cdk.stereo.SquarePlanar;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.stereo.TrigonalBipyramidal;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;

final class BeamToCDK {
    private final IChemObjectBuilder builder;
    private final IAtom templateAtom;
    private final IBond templateBond;
    private final IAtomContainer emptyContainer;

    BeamToCDK(IChemObjectBuilder builder) {
        this.builder = builder;
        this.templateAtom = (IAtom)builder.newInstance(IAtom.class, new Object[0]);
        this.templateBond = (IBond)builder.newInstance(IBond.class, new Object[0]);
        this.emptyContainer = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[]{0, 0, 0, 0});
    }

    IAtomContainer toAtomContainer(Graph g, boolean kekule) {
        int i;
        IAtomContainer ac = this.emptyContainer();
        int numAtoms = g.order();
        IAtom[] atoms = new IAtom[numAtoms];
        IBond[] bonds = new IBond[g.size()];
        int j = 0;
        boolean checkAtomStereo = false;
        boolean checkBondStereo = false;
        for (i = 0; i < g.order(); ++i) {
            checkAtomStereo = checkAtomStereo || g.configurationOf(i).type() != Configuration.Type.None;
            atoms[i] = this.toCDKAtom(g.atom(i), g.implHCount(i));
        }
        ac.setAtoms(atoms);
        for (i = 0; i < g.order(); ++i) {
            atoms[i] = ac.getAtom(i);
        }
        block20: for (Edge edge : g.edges()) {
            int u = edge.either();
            int v = edge.other(u);
            IBond bond = this.builder.newBond();
            bond.setAtoms(new IAtom[]{atoms[u], atoms[v]});
            bonds[j++] = bond;
            switch (edge.bond()) {
                case SINGLE: {
                    bond.setOrder(IBond.Order.SINGLE);
                    continue block20;
                }
                case UP: 
                case DOWN: {
                    checkBondStereo = true;
                    bond.setOrder(IBond.Order.SINGLE);
                    continue block20;
                }
                case IMPLICIT: {
                    bond.setOrder(IBond.Order.SINGLE);
                    if (kekule || !atoms[u].isAromatic() || !atoms[v].isAromatic()) continue block20;
                    bond.setIsAromatic(true);
                    bond.setOrder(IBond.Order.UNSET);
                    atoms[u].setIsAromatic(true);
                    atoms[v].setIsAromatic(true);
                    continue block20;
                }
                case IMPLICIT_AROMATIC: 
                case AROMATIC: {
                    bond.setOrder(IBond.Order.SINGLE);
                    bond.setIsAromatic(true);
                    atoms[u].setIsAromatic(true);
                    atoms[v].setIsAromatic(true);
                    continue block20;
                }
                case DOUBLE: {
                    bond.setOrder(IBond.Order.DOUBLE);
                    continue block20;
                }
                case DOUBLE_AROMATIC: {
                    bond.setOrder(IBond.Order.DOUBLE);
                    bond.setIsAromatic(true);
                    atoms[u].setIsAromatic(true);
                    atoms[v].setIsAromatic(true);
                    continue block20;
                }
                case TRIPLE: {
                    bond.setOrder(IBond.Order.TRIPLE);
                    continue block20;
                }
                case QUADRUPLE: {
                    bond.setOrder(IBond.Order.QUADRUPLE);
                    continue block20;
                }
            }
            throw new IllegalArgumentException("Edge label " + edge.bond() + "cannot be converted to a CDK bond order");
        }
        if (checkAtomStereo) {
            block21: for (int u = 0; u < g.order(); ++u) {
                Configuration c = g.configurationOf(u);
                switch (c.type()) {
                    case Tetrahedral: {
                        IStereoElement se = this.newTetrahedral(u, g.neighbors(u), atoms, c);
                        if (se == null) continue block21;
                        ac.addStereoElement(se);
                        continue block21;
                    }
                    case ExtendedTetrahedral: {
                        IStereoElement se = this.newExtendedTetrahedral(u, g, atoms);
                        if (se == null) continue block21;
                        ac.addStereoElement(se);
                        continue block21;
                    }
                    case DoubleBond: {
                        checkBondStereo = true;
                        continue block21;
                    }
                    case SquarePlanar: {
                        IStereoElement se = this.newSquarePlanar(u, g.neighbors(u), atoms, c);
                        if (se == null) continue block21;
                        ac.addStereoElement(se);
                        continue block21;
                    }
                    case TrigonalBipyramidal: {
                        IStereoElement se = this.newTrigonalBipyramidal(u, g.neighbors(u), atoms, c);
                        if (se == null) continue block21;
                        ac.addStereoElement(se);
                        continue block21;
                    }
                    case Octahedral: {
                        IStereoElement se = this.newOctahedral(u, g.neighbors(u), atoms, c);
                        if (se == null) continue block21;
                        ac.addStereoElement(se);
                        continue block21;
                    }
                }
            }
        }
        ac.setBonds(bonds);
        if (checkBondStereo) {
            this.addDoubleBondStereochemistry(g, ac);
        }
        ac.setTitle(g.getTitle());
        return ac;
    }

    private void addDoubleBondStereochemistry(Graph g, IAtomContainer ac) {
        for (Edge e : g.edges()) {
            int tmp;
            if (e.bond() != Bond.DOUBLE) continue;
            int u = e.either();
            int v = e.other(u);
            Edge first = null;
            Edge second = null;
            first = this.findDirectionalEdge(g, u);
            if (first != null && (second = this.findDirectionalEdge(g, v)) != null) {
                IDoubleBondStereochemistry.Conformation conformation = first.bond(u) == second.bond(v) ? IDoubleBondStereochemistry.Conformation.TOGETHER : IDoubleBondStereochemistry.Conformation.OPPOSITE;
                IBond db = ac.getBond(ac.getAtom(u), ac.getAtom(v));
                IBond[] ligands = new IBond[]{ac.getBond(ac.getAtom(u), ac.getAtom(first.other(u))), ac.getBond(ac.getAtom(v), ac.getAtom(second.other(v)))};
                ac.addStereoElement((IStereoElement)new DoubleBondStereochemistry(db, ligands, conformation));
                continue;
            }
            Configuration uConf = g.configurationOf(u);
            Configuration vConf = g.configurationOf(v);
            if (uConf.type() != Configuration.Type.DoubleBond || vConf.type() != Configuration.Type.DoubleBond) continue;
            int[] nbrs = new int[6];
            int[] uNbrs = g.neighbors(u);
            int[] vNbrs = g.neighbors(v);
            if (uNbrs.length < 2 || uNbrs.length > 3 || vNbrs.length < 2 || vNbrs.length > 3) continue;
            int idx = 0;
            System.arraycopy(uNbrs, 0, nbrs, idx, uNbrs.length);
            idx += uNbrs.length;
            if (uNbrs.length == 2) {
                nbrs[idx++] = u;
            }
            System.arraycopy(vNbrs, 0, nbrs, idx, vNbrs.length);
            idx += vNbrs.length;
            if (vNbrs.length == 2) {
                nbrs[idx] = v;
            }
            Arrays.sort(nbrs, 0, 3);
            Arrays.sort(nbrs, 3, 6);
            int vPos = Arrays.binarySearch(nbrs, 0, 3, v);
            int uPos = Arrays.binarySearch(nbrs, 3, 6, u);
            int uhi = 0;
            int ulo = 0;
            int vhi = 0;
            int vlo = 0;
            uhi = nbrs[(vPos + 1) % 3];
            ulo = nbrs[(vPos + 2) % 3];
            vhi = nbrs[3 + (uPos + 1) % 3];
            vlo = nbrs[3 + (uPos + 2) % 3];
            if (uConf.shorthand() == Configuration.CLOCKWISE) {
                tmp = uhi;
                uhi = ulo;
                ulo = tmp;
            }
            if (vConf.shorthand() == Configuration.ANTI_CLOCKWISE) {
                tmp = vhi;
                vhi = vlo;
                vlo = tmp;
            }
            IDoubleBondStereochemistry.Conformation conf = null;
            IBond[] bonds = new IBond[2];
            if (uhi != u) {
                bonds[0] = ac.getBond(ac.getAtom(u), ac.getAtom(uhi));
                if (vhi != v) {
                    conf = IDoubleBondStereochemistry.Conformation.TOGETHER;
                    bonds[1] = ac.getBond(ac.getAtom(v), ac.getAtom(vhi));
                } else if (vlo != v) {
                    conf = IDoubleBondStereochemistry.Conformation.OPPOSITE;
                    bonds[1] = ac.getBond(ac.getAtom(v), ac.getAtom(vlo));
                }
            } else if (ulo != u) {
                bonds[0] = ac.getBond(ac.getAtom(u), ac.getAtom(ulo));
                if (vhi != v) {
                    conf = IDoubleBondStereochemistry.Conformation.OPPOSITE;
                    bonds[1] = ac.getBond(ac.getAtom(v), ac.getAtom(vhi));
                } else if (vlo != v) {
                    conf = IDoubleBondStereochemistry.Conformation.TOGETHER;
                    bonds[1] = ac.getBond(ac.getAtom(v), ac.getAtom(vlo));
                }
            }
            ac.addStereoElement((IStereoElement)new DoubleBondStereochemistry(ac.getBond(ac.getAtom(u), ac.getAtom(v)), bonds, conf));
        }
    }

    private Edge findDirectionalEdge(Graph g, int u) {
        List edges = g.edges(u);
        if (edges.size() == 1) {
            return null;
        }
        for (Edge e : edges) {
            Bond b = e.bond();
            if (b != Bond.UP && b != Bond.DOWN) continue;
            return e;
        }
        return null;
    }

    private IStereoElement newTetrahedral(int u, int[] vs, IAtom[] atoms, Configuration c) {
        if (vs.length != 4) {
            if (vs.length != 3) {
                return null;
            }
            vs = BeamToCDK.insert(u, vs);
        }
        ITetrahedralChirality.Stereo stereo = c == Configuration.TH1 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
        return new TetrahedralChirality(atoms[u], new IAtom[]{atoms[vs[0]], atoms[vs[1]], atoms[vs[2]], atoms[vs[3]]}, stereo);
    }

    private IStereoElement newSquarePlanar(int u, int[] vs, IAtom[] atoms, Configuration c) {
        int order;
        if (vs.length != 4) {
            return null;
        }
        switch (c) {
            case SP1: {
                order = 17665;
                break;
            }
            case SP2: {
                order = 17666;
                break;
            }
            case SP3: {
                order = 17667;
                break;
            }
            default: {
                return null;
            }
        }
        return new SquarePlanar(atoms[u], new IAtom[]{atoms[vs[0]], atoms[vs[1]], atoms[vs[2]], atoms[vs[3]]}, order);
    }

    private IStereoElement newTrigonalBipyramidal(int u, int[] vs, IAtom[] atoms, Configuration c) {
        if (vs.length != 5) {
            return null;
        }
        int order = 1 + c.ordinal() - Configuration.TB1.ordinal();
        if (order < 1 || order > 20) {
            return null;
        }
        return new TrigonalBipyramidal(atoms[u], new IAtom[]{atoms[vs[0]], atoms[vs[1]], atoms[vs[2]], atoms[vs[3]], atoms[vs[4]]}, order);
    }

    private IStereoElement newOctahedral(int u, int[] vs, IAtom[] atoms, Configuration c) {
        if (vs.length != 6) {
            return null;
        }
        int order = 1 + c.ordinal() - Configuration.OH1.ordinal();
        if (order < 1 || order > 30) {
            return null;
        }
        return new Octahedral(atoms[u], new IAtom[]{atoms[vs[0]], atoms[vs[1]], atoms[vs[2]], atoms[vs[3]], atoms[vs[4]], atoms[vs[5]]}, order);
    }

    private IStereoElement newExtendedTetrahedral(int u, Graph g, IAtom[] atoms) {
        int[] terminals = g.neighbors(u);
        int[] xs = new int[]{-1, terminals[0], -1, terminals[1]};
        int n = 0;
        for (Edge e : g.edges(terminals[0])) {
            if (e.bond().order() != 1) continue;
            xs[n++] = e.other(terminals[0]);
        }
        n = 2;
        for (Edge e : g.edges(terminals[1])) {
            if (e.bond().order() != 1) continue;
            xs[n++] = e.other(terminals[1]);
        }
        Arrays.sort(xs);
        ITetrahedralChirality.Stereo stereo = g.configurationOf(u).shorthand() == Configuration.CLOCKWISE ? ITetrahedralChirality.Stereo.CLOCKWISE : ITetrahedralChirality.Stereo.ANTI_CLOCKWISE;
        return new ExtendedTetrahedral(atoms[u], new IAtom[]{atoms[xs[0]], atoms[xs[1]], atoms[xs[2]], atoms[xs[3]]}, stereo);
    }

    private static int[] insert(int v, int[] vs) {
        int n = vs.length;
        int[] ws = Arrays.copyOf(vs, n + 1);
        ws[n] = v;
        for (int i = n; i > 0 && ws[i] < ws[i - 1]; --i) {
            int tmp = ws[i];
            ws[i] = ws[i - 1];
            ws[i - 1] = tmp;
        }
        return ws;
    }

    IAtom toCDKAtom(Atom beamAtom, int hCount) {
        IAtom cdkAtom = this.newCDKAtom(beamAtom);
        cdkAtom.setImplicitHydrogenCount(Integer.valueOf(hCount));
        cdkAtom.setFormalCharge(Integer.valueOf(beamAtom.charge()));
        if (beamAtom.isotope() >= 0) {
            cdkAtom.setMassNumber(Integer.valueOf(beamAtom.isotope()));
        }
        if (beamAtom.aromatic()) {
            cdkAtom.setIsAromatic(true);
        }
        if (beamAtom.atomClass() > 0) {
            cdkAtom.setProperty((Object)"cdk:AtomAtomMapping", (Object)beamAtom.atomClass());
        }
        return cdkAtom;
    }

    IAtom newCDKAtom(Atom atom) {
        boolean unknown;
        Element element = atom.element();
        boolean bl = unknown = element == Element.Unknown;
        if (unknown) {
            IPseudoAtom pseudoAtom = (IPseudoAtom)this.builder.newInstance(IPseudoAtom.class, new Object[]{element.symbol()});
            pseudoAtom.setSymbol(element.symbol());
            pseudoAtom.setLabel(atom.label());
            return pseudoAtom;
        }
        return this.createAtom(element);
    }

    private IAtomContainer emptyContainer() {
        return this.builder.newAtomContainer();
    }

    private IAtom createAtom(Element element) {
        IAtom atom = this.builder.newAtom();
        atom.setSymbol(element.symbol());
        atom.setAtomicNumber(Integer.valueOf(element.atomicNumber()));
        return atom;
    }
}

