/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import com.google.common.base.Predicate;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;

public final class ComponentGrouping
implements Predicate<int[]> {
    public static final String KEY = "COMPONENT.GROUPING";
    private final int[] queryComponents;
    private final int[] targetComponents;
    private final int maxComponentIdx;

    public ComponentGrouping(IAtomContainer query, IAtomContainer target) {
        this((int[])query.getProperty((Object)KEY, int[].class), query.getProperty((Object)KEY) != null ? ComponentGrouping.determineComponents(target) : null);
    }

    private static int[] determineComponents(IAtomContainer target) {
        int[] components = null;
        if (target.isEmpty()) {
            components = new int[]{};
        }
        if (components == null && target.getAtom(0).getProperty((Object)"cdk:ReactionGroup") != null) {
            components = new int[target.getAtomCount()];
            for (int i = 0; i < target.getAtomCount(); ++i) {
                Integer grp = (Integer)target.getAtom(i).getProperty((Object)"cdk:ReactionGroup");
                if (grp == null) {
                    components = null;
                    break;
                }
                components[i] = grp;
            }
        }
        if (components == null) {
            components = new ConnectedComponents(GraphUtil.toAdjList((IAtomContainer)target)).components();
        }
        return components;
    }

    public ComponentGrouping(int[] grouping, int[] targetComponents) {
        this.queryComponents = grouping;
        this.targetComponents = targetComponents;
        int max = 0;
        if (targetComponents != null) {
            for (int i = 0; i < targetComponents.length; ++i) {
                if (targetComponents[i] <= max) continue;
                max = targetComponents[i];
            }
        }
        this.maxComponentIdx = max;
    }

    public boolean apply(int[] mapping) {
        if (this.queryComponents == null) {
            return true;
        }
        int[] usedBy = new int[this.maxComponentIdx + 1];
        int[] usedIn = new int[this.queryComponents[mapping.length] + 1];
        for (int v = 0; v < mapping.length; ++v) {
            if (this.queryComponents[v] == 0) continue;
            int w = mapping[v];
            int queryComponent = this.queryComponents[v];
            int targetComponent = this.targetComponents[w];
            if (usedBy[targetComponent] == 0) {
                usedBy[targetComponent] = queryComponent;
            } else if (usedBy[targetComponent] != queryComponent) {
                return false;
            }
            if (usedIn[queryComponent] == 0) {
                usedIn[queryComponent] = targetComponent;
                continue;
            }
            if (usedIn[queryComponent] == targetComponent) continue;
            return false;
        }
        return true;
    }
}

