/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class INChIFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new INChIFormat();
        }
        return myself;
    }

    public String getFormatName() {
        return "IUPAC-NIST Chemical Identifier (XML)";
    }

    public String getMIMEType() {
        return "chemical/x-inchi-xml";
    }

    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    public String[] getNameExtensions() {
        return new String[]{"inchi"};
    }

    public String getReaderClassName() {
        return "org.openscience.cdk.io.INChIReader";
    }

    public String getWriterClassName() {
        return null;
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return line.indexOf("<INChI") != -1;
    }

    public boolean isXMLBased() {
        return true;
    }

    public int getSupportedDataFeatures() {
        return 0;
    }

    public int getRequiredDataFeatures() {
        return 0;
    }
}

