/**
 * Copyright (c) 2014 IBH SYSTEMS GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBH SYSTEMS GmbH - initial API and implementation and/or initial documentation
 *
 */
package org.openscada.configuration.iec60870.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.scada.configuration.component.ComponentPackage;
import org.eclipse.scada.configuration.component.Container;
import org.eclipse.scada.configuration.component.util.ComponentSwitch;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.Node;
import org.eclipse.scada.configuration.infrastructure.SystemNode;
import org.eclipse.scada.configuration.infrastructure.util.InfrastructureSwitch;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.WorldPackage;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.OsgiPackage;
import org.eclipse.scada.configuration.world.osgi.util.OsgiSwitch;
import org.eclipse.scada.configuration.world.util.WorldSwitch;
import org.eclipse.ui.views.properties.IPropertySource;
import org.openscada.configuration.iec60870.IEC60870Factory;
import org.openscada.configuration.iec60870.IEC60870Package;
import org.openscada.configuration.iec60870.util.IEC60870AdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class IEC60870ItemProviderAdapterFactory extends IEC60870AdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender
{
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier ();

    /**
     * This helps manage the child creation extenders.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager ( IEC60870EditPlugin.INSTANCE, IEC60870Package.eNS_URI );

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object> ();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated NOT
     */
    public IEC60870ItemProviderAdapterFactory ()
    {
        this.supportedTypes.add ( IEditingDomainItemProvider.class );
        this.supportedTypes.add ( IStructuredItemContentProvider.class );
        this.supportedTypes.add ( ITreeItemContentProvider.class );
        this.supportedTypes.add ( IItemLabelProvider.class );
        this.supportedTypes.add ( IItemPropertySource.class );
        this.supportedTypes.add ( IPropertySource.class );
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.Exporter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExporterItemProvider exporterItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.Exporter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExporterAdapter ()
    {
        if ( exporterItemProvider == null )
        {
            exporterItemProvider = new ExporterItemProvider ( this );
        }

        return exporterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.Device} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DeviceItemProvider deviceItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.Device}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDeviceAdapter ()
    {
        if ( deviceItemProvider == null )
        {
            deviceItemProvider = new DeviceItemProvider ( this );
        }

        return deviceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.Item} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ItemItemProvider itemItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.Item}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createItemAdapter ()
    {
        if ( itemItemProvider == null )
        {
            itemItemProvider = new ItemItemProvider ( this );
        }

        return itemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.ExporterItemInterceptor} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExporterItemInterceptorItemProvider exporterItemInterceptorItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.ExporterItemInterceptor}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExporterItemInterceptorAdapter ()
    {
        if ( exporterItemInterceptorItemProvider == null )
        {
            exporterItemInterceptorItemProvider = new ExporterItemInterceptorItemProvider ( this );
        }

        return exporterItemInterceptorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.ProtocolOptions} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ProtocolOptionsItemProvider protocolOptionsItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.ProtocolOptions}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createProtocolOptionsAdapter ()
    {
        if ( protocolOptionsItemProvider == null )
        {
            protocolOptionsItemProvider = new ProtocolOptionsItemProvider ( this );
        }

        return protocolOptionsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.DataModuleOptions} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataModuleOptionsItemProvider dataModuleOptionsItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.DataModuleOptions}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataModuleOptionsAdapter ()
    {
        if ( dataModuleOptionsItemProvider == null )
        {
            dataModuleOptionsItemProvider = new DataModuleOptionsItemProvider ( this );
        }

        return dataModuleOptionsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.ClientDevice} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ClientDeviceItemProvider clientDeviceItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.ClientDevice}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createClientDeviceAdapter ()
    {
        if ( clientDeviceItemProvider == null )
        {
            clientDeviceItemProvider = new ClientDeviceItemProvider ( this );
        }

        return clientDeviceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.DriverApplication} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DriverApplicationItemProvider driverApplicationItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.DriverApplication}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDriverApplicationAdapter ()
    {
        if ( driverApplicationItemProvider == null )
        {
            driverApplicationItemProvider = new DriverApplicationItemProvider ( this );
        }

        return driverApplicationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.ClientDataModuleOptions} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ClientDataModuleOptionsItemProvider clientDataModuleOptionsItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.ClientDataModuleOptions}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createClientDataModuleOptionsAdapter ()
    {
        if ( clientDataModuleOptionsItemProvider == null )
        {
            clientDataModuleOptionsItemProvider = new ClientDataModuleOptionsItemProvider ( this );
        }

        return clientDataModuleOptionsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.IEC60870Driver} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IEC60870DriverItemProvider iec60870DriverItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.IEC60870Driver}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createIEC60870DriverAdapter ()
    {
        if ( iec60870DriverItemProvider == null )
        {
            iec60870DriverItemProvider = new IEC60870DriverItemProvider ( this );
        }

        return iec60870DriverItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.IEC60870Device} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IEC60870DeviceItemProvider iec60870DeviceItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.IEC60870Device}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createIEC60870DeviceAdapter ()
    {
        if ( iec60870DeviceItemProvider == null )
        {
            iec60870DeviceItemProvider = new IEC60870DeviceItemProvider ( this );
        }

        return iec60870DeviceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.openscada.configuration.iec60870.ItemType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ItemTypeItemProvider itemTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.openscada.configuration.iec60870.ItemType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createItemTypeAdapter ()
    {
        if ( itemTypeItemProvider == null )
        {
            itemTypeItemProvider = new ItemTypeItemProvider ( this );
        }

        return itemTypeItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory ()
    {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory ();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setParentAdapterFactory ( ComposedAdapterFactory parentAdapterFactory )
    {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType ( Object type )
    {
        return supportedTypes.contains ( type ) || super.isFactoryForType ( type );
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt ( Notifier notifier, Object type )
    {
        return super.adapt ( notifier, this );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt ( Object object, Object type )
    {
        if ( isFactoryForType ( type ) )
        {
            Object adapter = super.adapt ( object, type );
            if ( ! ( type instanceof Class<?> ) || ( ( (Class<?>)type ).isInstance ( adapter ) ) )
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public List<IChildCreationExtender> getChildCreationExtenders ()
    {
        return childCreationExtenderManager.getChildCreationExtenders ();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Collection<?> getNewChildDescriptors ( Object object, EditingDomain editingDomain )
    {
        return childCreationExtenderManager.getNewChildDescriptors ( object, editingDomain );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ResourceLocator getResourceLocator ()
    {
        return childCreationExtenderManager;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void addListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.addListener ( notifyChangedListener );
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void removeListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.removeListener ( notifyChangedListener );
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void fireNotifyChanged ( Notification notification )
    {
        changeNotifier.fireNotifyChanged ( notification );

        if ( parentAdapterFactory != null )
        {
            parentAdapterFactory.fireNotifyChanged ( notification );
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void dispose ()
    {
        if ( exporterItemProvider != null )
            exporterItemProvider.dispose ();
        if ( deviceItemProvider != null )
            deviceItemProvider.dispose ();
        if ( itemItemProvider != null )
            itemItemProvider.dispose ();
        if ( exporterItemInterceptorItemProvider != null )
            exporterItemInterceptorItemProvider.dispose ();
        if ( protocolOptionsItemProvider != null )
            protocolOptionsItemProvider.dispose ();
        if ( dataModuleOptionsItemProvider != null )
            dataModuleOptionsItemProvider.dispose ();
        if ( clientDeviceItemProvider != null )
            clientDeviceItemProvider.dispose ();
        if ( driverApplicationItemProvider != null )
            driverApplicationItemProvider.dispose ();
        if ( clientDataModuleOptionsItemProvider != null )
            clientDataModuleOptionsItemProvider.dispose ();
        if ( iec60870DriverItemProvider != null )
            iec60870DriverItemProvider.dispose ();
        if ( iec60870DeviceItemProvider != null )
            iec60870DeviceItemProvider.dispose ();
        if ( itemTypeItemProvider != null )
            itemTypeItemProvider.dispose ();
    }

    /**
     * A child creation extender for the {@link ComponentPackage}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static class ComponentChildCreationExtender implements IChildCreationExtender
    {
        /**
         * The switch for creating child descriptors specific to each extended class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        protected static class CreationSwitch extends ComponentSwitch<Object>
        {
            /**
             * The child descriptors being populated.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected List<Object> newChildDescriptors;

            /**
             * The domain in which to create the children.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected EditingDomain editingDomain;

            /**
             * Creates the a switch for populating child descriptors in the given domain.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            CreationSwitch ( List<Object> newChildDescriptors, EditingDomain editingDomain )
            {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            /**
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            @Override
            public Object caseContainer ( Container object )
            {
                newChildDescriptors.add ( createChildParameter ( ComponentPackage.Literals.CONTAINER__ITEM_INTERCEPTORS, IEC60870Factory.eINSTANCE.createExporterItemInterceptor () ) );

                return null;
            }

            /**
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected CommandParameter createChildParameter ( Object feature, Object child )
            {
                return new CommandParameter ( null, feature, child );
            }

        }

        /**
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        @Override
        public Collection<Object> getNewChildDescriptors ( Object object, EditingDomain editingDomain )
        {
            ArrayList<Object> result = new ArrayList<Object> ();
            new CreationSwitch ( result, editingDomain ).doSwitch ( (EObject)object );
            return result;
        }

        /**
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        @Override
        public ResourceLocator getResourceLocator ()
        {
            return IEC60870EditPlugin.INSTANCE;
        }
    }

    /**
     * A child creation extender for the {@link InfrastructurePackage}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static class InfrastructureChildCreationExtender implements IChildCreationExtender
    {
        /**
         * The switch for creating child descriptors specific to each extended class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        protected static class CreationSwitch extends InfrastructureSwitch<Object>
        {
            /**
             * The child descriptors being populated.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected List<Object> newChildDescriptors;

            /**
             * The domain in which to create the children.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected EditingDomain editingDomain;

            /**
             * Creates the a switch for populating child descriptors in the given domain.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            CreationSwitch ( List<Object> newChildDescriptors, EditingDomain editingDomain )
            {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            /**
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            @Override
            public Object caseNode ( Node object )
            {
                newChildDescriptors.add ( createChildParameter ( InfrastructurePackage.Literals.NODE__DEVICES, IEC60870Factory.eINSTANCE.createIEC60870Device () ) );

                return null;
            }

            /**
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            @Override
            public Object caseSystemNode ( SystemNode object )
            {
                newChildDescriptors.add ( createChildParameter ( InfrastructurePackage.Literals.SYSTEM_NODE__DRIVERS, IEC60870Factory.eINSTANCE.createIEC60870Driver () ) );

                return null;
            }

            /**
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected CommandParameter createChildParameter ( Object feature, Object child )
            {
                return new CommandParameter ( null, feature, child );
            }

        }

        /**
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        public Collection<Object> getNewChildDescriptors ( Object object, EditingDomain editingDomain )
        {
            ArrayList<Object> result = new ArrayList<Object> ();
            new CreationSwitch ( result, editingDomain ).doSwitch ( (EObject)object );
            return result;
        }

        /**
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        public ResourceLocator getResourceLocator ()
        {
            return IEC60870EditPlugin.INSTANCE;
        }
    }

    /**
     * A child creation extender for the {@link WorldPackage}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static class WorldChildCreationExtender implements IChildCreationExtender
    {
        /**
         * The switch for creating child descriptors specific to each extended class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        protected static class CreationSwitch extends WorldSwitch<Object>
        {
            /**
             * The child descriptors being populated.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected List<Object> newChildDescriptors;

            /**
             * The domain in which to create the children.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected EditingDomain editingDomain;

            /**
             * Creates the a switch for populating child descriptors in the given domain.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            CreationSwitch ( List<Object> newChildDescriptors, EditingDomain editingDomain )
            {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            /**
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            @Override
            public Object caseApplicationNode ( ApplicationNode object )
            {
                newChildDescriptors.add ( createChildParameter ( WorldPackage.Literals.APPLICATION_NODE__APPLICATIONS, IEC60870Factory.eINSTANCE.createDriverApplication () ) );

                return null;
            }

            /**
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected CommandParameter createChildParameter ( Object feature, Object child )
            {
                return new CommandParameter ( null, feature, child );
            }

        }

        /**
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        public Collection<Object> getNewChildDescriptors ( Object object, EditingDomain editingDomain )
        {
            ArrayList<Object> result = new ArrayList<Object> ();
            new CreationSwitch ( result, editingDomain ).doSwitch ( (EObject)object );
            return result;
        }

        /**
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        public ResourceLocator getResourceLocator ()
        {
            return IEC60870EditPlugin.INSTANCE;
        }
    }

    /**
     * A child creation extender for the {@link OsgiPackage}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static class OsgiChildCreationExtender implements IChildCreationExtender
    {
        /**
         * The switch for creating child descriptors specific to each extended class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        protected static class CreationSwitch extends OsgiSwitch<Object>
        {
            /**
             * The child descriptors being populated.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected List<Object> newChildDescriptors;

            /**
             * The domain in which to create the children.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected EditingDomain editingDomain;

            /**
             * Creates the a switch for populating child descriptors in the given domain.
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            CreationSwitch ( List<Object> newChildDescriptors, EditingDomain editingDomain )
            {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            /**
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            @Override
            public Object caseEquinoxApplication ( EquinoxApplication object )
            {
                newChildDescriptors.add ( createChildParameter ( OsgiPackage.Literals.EQUINOX_APPLICATION__MODULES, IEC60870Factory.eINSTANCE.createExporter () ) );

                return null;
            }

            /**
             * <!-- begin-user-doc -->
             * <!-- end-user-doc -->
             * @generated
             */
            protected CommandParameter createChildParameter ( Object feature, Object child )
            {
                return new CommandParameter ( null, feature, child );
            }

        }

        /**
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        @Override
        public Collection<Object> getNewChildDescriptors ( Object object, EditingDomain editingDomain )
        {
            ArrayList<Object> result = new ArrayList<Object> ();
            new CreationSwitch ( result, editingDomain ).doSwitch ( (EObject)object );
            return result;
        }

        /**
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        @Override
        public ResourceLocator getResourceLocator ()
        {
            return IEC60870EditPlugin.INSTANCE;
        }
    }

}
