/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.UnicodeString;
import jcifs.dcerpc.msrpc.LsaPolicyHandle;
import jcifs.dcerpc.msrpc.MsrpcEnumerateAliasesInDomain;
import jcifs.dcerpc.msrpc.MsrpcGetMembersInAlias;
import jcifs.dcerpc.msrpc.MsrpcLookupSids;
import jcifs.dcerpc.msrpc.MsrpcQueryInformationPolicy;
import jcifs.dcerpc.msrpc.SamrAliasHandle;
import jcifs.dcerpc.msrpc.SamrDomainHandle;
import jcifs.dcerpc.msrpc.SamrPolicyHandle;
import jcifs.dcerpc.msrpc.lsarpc;
import jcifs.dcerpc.msrpc.samr;
import jcifs.dcerpc.ndr.NdrObject;
import jcifs.dcerpc.rpc;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbException;
import jcifs.util.Hexdump;

public class SID
extends rpc.sid_t {
    public static final int SID_TYPE_USE_NONE = 0;
    public static final int SID_TYPE_USER = 1;
    public static final int SID_TYPE_DOM_GRP = 2;
    public static final int SID_TYPE_DOMAIN = 3;
    public static final int SID_TYPE_ALIAS = 4;
    public static final int SID_TYPE_WKN_GRP = 5;
    public static final int SID_TYPE_DELETED = 6;
    public static final int SID_TYPE_INVALID = 7;
    public static final int SID_TYPE_UNKNOWN = 8;
    static final String[] SID_TYPE_NAMES = new String[]{"0", "User", "Domain group", "Domain", "Local group", "Builtin group", "Deleted", "Invalid", "Unknown"};
    public static final int SID_FLAG_RESOLVE_SIDS = 1;
    public static SID EVERYONE = null;
    public static SID CREATOR_OWNER = null;
    public static SID SYSTEM = null;
    static Map sid_cache;
    int type;
    String domainName = null;
    String acctName = null;
    String origin_server = null;
    NtlmPasswordAuthentication origin_auth = null;

    static {
        try {
            EVERYONE = new SID("S-1-1-0");
            CREATOR_OWNER = new SID("S-1-3-0");
            SYSTEM = new SID("S-1-5-18");
        }
        catch (SmbException smbException) {
            // empty catch block
        }
        sid_cache = Collections.synchronizedMap(new HashMap());
    }

    static void resolveSids(DcerpcHandle handle, LsaPolicyHandle policyHandle, SID[] sids) throws IOException {
        MsrpcLookupSids rpc2 = new MsrpcLookupSids(policyHandle, sids);
        handle.sendrecv(rpc2);
        switch (rpc2.retval) {
            case -1073741709: 
            case 0: 
            case 263: {
                break;
            }
            default: {
                throw new SmbException(rpc2.retval, false);
            }
        }
        int si = 0;
        while (si < sids.length) {
            sids[si].type = rpc2.names.names[si].sid_type;
            sids[si].domainName = null;
            switch (sids[si].type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int sid_index = rpc2.names.names[si].sid_index;
                    rpc.unicode_string ustr = rpc2.domains.domains[sid_index].name;
                    sids[si].domainName = new UnicodeString(ustr, false).toString();
                }
            }
            sids[si].acctName = new UnicodeString(rpc2.names.names[si].name, false).toString();
            sids[si].origin_server = null;
            sids[si].origin_auth = null;
            ++si;
        }
    }

    static void resolveSids0(String authorityServerName, NtlmPasswordAuthentication auth, SID[] sids) throws IOException {
        DcerpcHandle handle = null;
        LsaPolicyHandle policyHandle = null;
        try {
            handle = DcerpcHandle.getHandle("ncacn_np:" + authorityServerName + "[\\PIPE\\lsarpc]", auth);
            String server = authorityServerName;
            int dot = server.indexOf(46);
            if (dot > 0 && !Character.isDigit(server.charAt(0))) {
                server = server.substring(0, dot);
            }
            policyHandle = new LsaPolicyHandle(handle, "\\\\" + server, 2048);
            SID.resolveSids(handle, policyHandle, sids);
        }
        finally {
            if (handle != null) {
                if (policyHandle != null) {
                    policyHandle.close();
                }
                handle.close();
            }
        }
    }

    public static void resolveSids(String authorityServerName, NtlmPasswordAuthentication auth, SID[] sids, int offset, int length) throws IOException {
        ArrayList<SID> list = new ArrayList<SID>(sids.length);
        int si = 0;
        while (si < length) {
            SID sid = (SID)sid_cache.get(sids[offset + si]);
            if (sid != null) {
                sids[offset + si].type = sid.type;
                sids[offset + si].domainName = sid.domainName;
                sids[offset + si].acctName = sid.acctName;
            } else {
                list.add(sids[offset + si]);
            }
            ++si;
        }
        if (list.size() > 0) {
            sids = list.toArray(new SID[0]);
            SID.resolveSids0(authorityServerName, auth, sids);
            si = 0;
            while (si < sids.length) {
                sid_cache.put(sids[si], sids[si]);
                ++si;
            }
        }
    }

    public static void resolveSids(String authorityServerName, NtlmPasswordAuthentication auth, SID[] sids) throws IOException {
        ArrayList<SID> list = new ArrayList<SID>(sids.length);
        int si = 0;
        while (si < sids.length) {
            SID sid = (SID)sid_cache.get(sids[si]);
            if (sid != null) {
                sids[si].type = sid.type;
                sids[si].domainName = sid.domainName;
                sids[si].acctName = sid.acctName;
            } else {
                list.add(sids[si]);
            }
            ++si;
        }
        if (list.size() > 0) {
            sids = list.toArray(new SID[0]);
            SID.resolveSids0(authorityServerName, auth, sids);
            si = 0;
            while (si < sids.length) {
                sid_cache.put(sids[si], sids[si]);
                ++si;
            }
        }
    }

    public static SID getServerSid(String server, NtlmPasswordAuthentication auth) throws IOException {
        DcerpcHandle handle = null;
        LsaPolicyHandle policyHandle = null;
        lsarpc.LsarDomainInfo info = new lsarpc.LsarDomainInfo();
        try {
            handle = DcerpcHandle.getHandle("ncacn_np:" + server + "[\\PIPE\\lsarpc]", auth);
            policyHandle = new LsaPolicyHandle(handle, null, 1);
            MsrpcQueryInformationPolicy rpc2 = new MsrpcQueryInformationPolicy(policyHandle, 5, (NdrObject)info);
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, false);
            }
            SID sID = new SID(info.sid, 3, new UnicodeString(info.name, false).toString(), null, false);
            return sID;
        }
        finally {
            if (handle != null) {
                if (policyHandle != null) {
                    policyHandle.close();
                }
                handle.close();
            }
        }
    }

    public SID(byte[] src, int si) {
        this.revision = src[si++];
        this.sub_authority_count = src[si++];
        this.identifier_authority = new byte[6];
        System.arraycopy(src, si, this.identifier_authority, 0, 6);
        si += 6;
        if (this.sub_authority_count > 100) {
            throw new RuntimeException("Invalid SID sub_authority_count");
        }
        this.sub_authority = new int[this.sub_authority_count];
        int i = 0;
        while (i < this.sub_authority_count) {
            this.sub_authority[i] = ServerMessageBlock.readInt4(src, si);
            si += 4;
            ++i;
        }
    }

    public SID(String textual) throws SmbException {
        StringTokenizer st = new StringTokenizer(textual, "-");
        if (st.countTokens() < 3 || !st.nextToken().equals("S")) {
            throw new SmbException("Bad textual SID format: " + textual);
        }
        this.revision = Byte.parseByte(st.nextToken());
        String tmp = st.nextToken();
        long id = 0L;
        id = tmp.startsWith("0x") ? Long.parseLong(tmp.substring(2), 16) : Long.parseLong(tmp);
        this.identifier_authority = new byte[6];
        int i = 5;
        while (id > 0L) {
            this.identifier_authority[i] = (byte)(id % 256L);
            id >>= 8;
            --i;
        }
        this.sub_authority_count = (byte)st.countTokens();
        if (this.sub_authority_count > 0) {
            this.sub_authority = new int[this.sub_authority_count];
            i = 0;
            while (i < this.sub_authority_count) {
                this.sub_authority[i] = (int)(Long.parseLong(st.nextToken()) & 0xFFFFFFFFL);
                ++i;
            }
        }
    }

    public SID(SID domsid, int rid) {
        this.revision = domsid.revision;
        this.identifier_authority = domsid.identifier_authority;
        this.sub_authority_count = (byte)(domsid.sub_authority_count + 1);
        this.sub_authority = new int[this.sub_authority_count];
        int i = 0;
        while (i < domsid.sub_authority_count) {
            this.sub_authority[i] = domsid.sub_authority[i];
            ++i;
        }
        this.sub_authority[i] = rid;
    }

    SID(rpc.sid_t sid, int type, String domainName, String acctName, boolean decrementAuthority) {
        this.revision = sid.revision;
        this.sub_authority_count = sid.sub_authority_count;
        this.identifier_authority = sid.identifier_authority;
        this.sub_authority = sid.sub_authority;
        this.type = type;
        this.domainName = domainName;
        this.acctName = acctName;
        if (decrementAuthority) {
            this.sub_authority_count = (byte)(this.sub_authority_count - 1);
            this.sub_authority = new int[this.sub_authority_count];
            int i = 0;
            while (i < this.sub_authority_count) {
                this.sub_authority[i] = sid.sub_authority[i];
                ++i;
            }
        }
    }

    public SID getDomainSid() {
        return new SID(this, 3, this.domainName, null, this.getType() != 3);
    }

    public int getRid() {
        if (this.getType() == 3) {
            throw new IllegalArgumentException("This SID is a domain sid");
        }
        return this.sub_authority[this.sub_authority_count - 1];
    }

    public int getType() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        return this.type;
    }

    public String getTypeText() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        return SID_TYPE_NAMES[this.type];
    }

    public String getDomainName() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.type == 8) {
            String full = this.toString();
            return full.substring(0, full.length() - this.getAccountName().length() - 1);
        }
        return this.domainName;
    }

    public String getAccountName() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.type == 8) {
            return "" + this.sub_authority[this.sub_authority_count - 1];
        }
        if (this.type == 3) {
            return "";
        }
        return this.acctName;
    }

    public int hashCode() {
        int hcode = this.identifier_authority[5];
        int i = 0;
        while (i < this.sub_authority_count) {
            hcode += 65599 * this.sub_authority[i];
            ++i;
        }
        return hcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SID) {
            SID sid = (SID)obj;
            if (sid == this) {
                return true;
            }
            if (sid.sub_authority_count == this.sub_authority_count) {
                int i = this.sub_authority_count;
                while (i-- > 0) {
                    if (sid.sub_authority[i] == this.sub_authority[i]) continue;
                    return false;
                }
                i = 0;
                while (i < 6) {
                    if (sid.identifier_authority[i] != this.identifier_authority[i]) {
                        return false;
                    }
                    ++i;
                }
                return sid.revision == this.revision;
            }
        }
        return false;
    }

    public String toString() {
        String ret = "S-" + (this.revision & 0xFF) + "-";
        if (this.identifier_authority[0] != 0 || this.identifier_authority[1] != 0) {
            ret = String.valueOf(ret) + "0x";
            ret = String.valueOf(ret) + Hexdump.toHexString(this.identifier_authority, 0, 6);
        } else {
            long shift = 0L;
            long id = 0L;
            int i = 5;
            while (i > 1) {
                id += ((long)this.identifier_authority[i] & 0xFFL) << (int)shift;
                shift += 8L;
                --i;
            }
            ret = String.valueOf(ret) + id;
        }
        int i = 0;
        while (i < this.sub_authority_count) {
            ret = String.valueOf(ret) + "-" + ((long)this.sub_authority[i] & 0xFFFFFFFFL);
            ++i;
        }
        return ret;
    }

    public String toDisplayString() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.domainName != null) {
            String str = this.type == 3 ? this.domainName : (this.type == 5 || this.domainName.equals("BUILTIN") ? (this.type == 8 ? this.toString() : this.acctName) : String.valueOf(this.domainName) + "\\" + this.acctName);
            return str;
        }
        return this.toString();
    }

    public void resolve(String authorityServerName, NtlmPasswordAuthentication auth) throws IOException {
        SID[] sids = new SID[]{this};
        SID.resolveSids(authorityServerName, auth, sids);
    }

    void resolveWeak() {
        if (this.origin_server != null) {
            try {
                try {
                    this.resolve(this.origin_server, this.origin_auth);
                }
                catch (IOException iOException) {
                    this.origin_server = null;
                    this.origin_auth = null;
                }
            }
            finally {
                this.origin_server = null;
                this.origin_auth = null;
            }
        }
    }

    static SID[] getGroupMemberSids0(DcerpcHandle handle, SamrDomainHandle domainHandle, SID domsid, int rid, int flags) throws IOException {
        SamrAliasHandle aliasHandle = null;
        lsarpc.LsarSidArray sidarray = new lsarpc.LsarSidArray();
        MsrpcGetMembersInAlias rpc2 = null;
        try {
            aliasHandle = new SamrAliasHandle(handle, domainHandle, 131084, rid);
            rpc2 = new MsrpcGetMembersInAlias(aliasHandle, sidarray);
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, false);
            }
            SID[] sids = new SID[rpc2.sids.num_sids];
            String origin_server = handle.getServer();
            NtlmPasswordAuthentication origin_auth = (NtlmPasswordAuthentication)handle.getPrincipal();
            int i = 0;
            while (i < sids.length) {
                sids[i] = new SID(rpc2.sids.sids[i].sid, 0, null, null, false);
                sids[i].origin_server = origin_server;
                sids[i].origin_auth = origin_auth;
                ++i;
            }
            if (sids.length > 0 && (flags & 1) != 0) {
                SID.resolveSids(origin_server, origin_auth, sids);
            }
            SID[] sIDArray = sids;
            return sIDArray;
        }
        finally {
            if (aliasHandle != null) {
                aliasHandle.close();
            }
        }
    }

    public SID[] getGroupMemberSids(String authorityServerName, NtlmPasswordAuthentication auth, int flags) throws IOException {
        if (this.type != 2 && this.type != 4) {
            return new SID[0];
        }
        DcerpcHandle handle = null;
        SamrPolicyHandle policyHandle = null;
        SamrDomainHandle domainHandle = null;
        SID domsid = this.getDomainSid();
        try {
            handle = DcerpcHandle.getHandle("ncacn_np:" + authorityServerName + "[\\PIPE\\samr]", auth);
            policyHandle = new SamrPolicyHandle(handle, authorityServerName, 48);
            domainHandle = new SamrDomainHandle(handle, policyHandle, 512, domsid);
            SID[] sIDArray = SID.getGroupMemberSids0(handle, domainHandle, domsid, this.getRid(), flags);
            return sIDArray;
        }
        finally {
            if (handle != null) {
                if (policyHandle != null) {
                    if (domainHandle != null) {
                        domainHandle.close();
                    }
                    policyHandle.close();
                }
                handle.close();
            }
        }
    }

    static Map getLocalGroupsMap(String authorityServerName, NtlmPasswordAuthentication auth, int flags) throws IOException {
        SID domsid = SID.getServerSid(authorityServerName, auth);
        DcerpcHandle handle = null;
        SamrPolicyHandle policyHandle = null;
        SamrDomainHandle domainHandle = null;
        samr.SamrSamArray sam = new samr.SamrSamArray();
        try {
            handle = DcerpcHandle.getHandle("ncacn_np:" + authorityServerName + "[\\PIPE\\samr]", auth);
            policyHandle = new SamrPolicyHandle(handle, authorityServerName, 0x2000000);
            domainHandle = new SamrDomainHandle(handle, policyHandle, 0x2000000, domsid);
            MsrpcEnumerateAliasesInDomain rpc2 = new MsrpcEnumerateAliasesInDomain(domainHandle, 65535, sam);
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, false);
            }
            HashMap map = new HashMap();
            int ei = 0;
            while (ei < rpc2.sam.count) {
                samr.SamrSamEntry entry = rpc2.sam.entries[ei];
                SID[] mems = SID.getGroupMemberSids0(handle, domainHandle, domsid, entry.idx, flags);
                SID groupSid = new SID(domsid, entry.idx);
                groupSid.type = 4;
                groupSid.domainName = domsid.getDomainName();
                groupSid.acctName = new UnicodeString(entry.name, false).toString();
                int mi = 0;
                while (mi < mems.length) {
                    ArrayList<SID> groups = (ArrayList<SID>)map.get(mems[mi]);
                    if (groups == null) {
                        groups = new ArrayList<SID>();
                        map.put(mems[mi], groups);
                    }
                    if (!groups.contains(groupSid)) {
                        groups.add(groupSid);
                    }
                    ++mi;
                }
                ++ei;
            }
            HashMap hashMap = map;
            return hashMap;
        }
        finally {
            if (handle != null) {
                if (policyHandle != null) {
                    if (domainHandle != null) {
                        domainHandle.close();
                    }
                    policyHandle.close();
                }
                handle.close();
            }
        }
    }
}

