/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.http.NtlmHttpServletRequest;
import jcifs.http.NtlmSsp;
import jcifs.smb.NtlmChallenge;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbSession;
import jcifs.util.Base64;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

public class NtlmHttpFilter
implements Filter {
    private static LogStream log = LogStream.getInstance();
    private String defaultDomain;
    private String domainController;
    private boolean loadBalance;
    private boolean enableBasic;
    private boolean insecureBasic;
    private String realm;

    public void init(FilterConfig filterConfig) throws ServletException {
        int level;
        Config.setProperty("jcifs.smb.client.soTimeout", "300000");
        Config.setProperty("jcifs.netbios.cachePolicy", "1200");
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("jcifs.")) continue;
            Config.setProperty(name, filterConfig.getInitParameter(name));
        }
        this.defaultDomain = Config.getProperty("jcifs.smb.client.domain");
        this.domainController = Config.getProperty("jcifs.http.domainController");
        if (this.domainController == null) {
            this.domainController = this.defaultDomain;
            this.loadBalance = Config.getBoolean("jcifs.http.loadBalance", true);
        }
        this.enableBasic = Boolean.valueOf(Config.getProperty("jcifs.http.enableBasic"));
        this.insecureBasic = Boolean.valueOf(Config.getProperty("jcifs.http.insecureBasic"));
        this.realm = Config.getProperty("jcifs.http.basicRealm");
        if (this.realm == null) {
            this.realm = "jCIFS";
        }
        if ((level = Config.getInt("jcifs.util.loglevel", -1)) != -1) {
            LogStream.setLevel(level);
        }
        if (LogStream.level > 2) {
            try {
                Config.store(log, "JCIFS PROPERTIES");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        NtlmPasswordAuthentication ntlm = this.negotiate(req, resp, false);
        if (ntlm == null) {
            return;
        }
        chain.doFilter((ServletRequest)new NtlmHttpServletRequest(req, ntlm), response);
    }

    protected NtlmPasswordAuthentication negotiate(HttpServletRequest req, HttpServletResponse resp, boolean skipAuthentication) throws IOException, ServletException {
        HttpSession ssn;
        boolean offerBasic;
        NtlmPasswordAuthentication ntlm = null;
        String msg = req.getHeader("Authorization");
        boolean bl = offerBasic = this.enableBasic && (this.insecureBasic || req.isSecure());
        if (msg != null && (msg.startsWith("NTLM ") || offerBasic && msg.startsWith("Basic "))) {
            UniAddress dc;
            if (msg.startsWith("NTLM ")) {
                byte[] challenge;
                HttpSession ssn2 = req.getSession();
                if (this.loadBalance) {
                    NtlmChallenge chal = (NtlmChallenge)ssn2.getAttribute("NtlmHttpChal");
                    if (chal == null) {
                        chal = SmbSession.getChallengeForDomain();
                        ssn2.setAttribute("NtlmHttpChal", (Object)chal);
                    }
                    dc = chal.dc;
                    challenge = chal.challenge;
                } else {
                    dc = UniAddress.getByName(this.domainController, true);
                    challenge = SmbSession.getChallenge(dc);
                }
                ntlm = NtlmSsp.authenticate(req, resp, challenge);
                if (ntlm == null) {
                    return null;
                }
                ssn2.removeAttribute("NtlmHttpChal");
            } else {
                String auth = new String(Base64.decode(msg.substring(6)), "US-ASCII");
                int index = auth.indexOf(58);
                String user = index != -1 ? auth.substring(0, index) : auth;
                String password = index != -1 ? auth.substring(index + 1) : "";
                index = user.indexOf(92);
                if (index == -1) {
                    index = user.indexOf(47);
                }
                String domain = index != -1 ? user.substring(0, index) : this.defaultDomain;
                user = index != -1 ? user.substring(index + 1) : user;
                ntlm = new NtlmPasswordAuthentication(domain, user, password);
                dc = UniAddress.getByName(this.domainController, true);
            }
            try {
                SmbSession.logon(dc, ntlm);
                if (LogStream.level > 2) {
                    log.println("NtlmHttpFilter: " + ntlm + " successfully authenticated against " + dc);
                }
            }
            catch (SmbAuthException sae) {
                HttpSession ssn3;
                if (LogStream.level > 1) {
                    log.println("NtlmHttpFilter: " + ntlm.getName() + ": 0x" + Hexdump.toHexString(sae.getNtStatus(), 8) + ": " + sae);
                }
                if (sae.getNtStatus() == -1073741819 && (ssn3 = req.getSession(false)) != null) {
                    ssn3.removeAttribute("NtlmHttpAuth");
                }
                resp.setHeader("WWW-Authenticate", "NTLM");
                if (offerBasic) {
                    resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
                }
                resp.setStatus(401);
                resp.setContentLength(0);
                resp.flushBuffer();
                return null;
            }
            req.getSession().setAttribute("NtlmHttpAuth", (Object)ntlm);
        } else if (!(skipAuthentication || (ssn = req.getSession(false)) != null && (ntlm = (NtlmPasswordAuthentication)ssn.getAttribute("NtlmHttpAuth")) != null)) {
            resp.setHeader("WWW-Authenticate", "NTLM");
            if (offerBasic) {
                resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            }
            resp.setStatus(401);
            resp.setContentLength(0);
            resp.flushBuffer();
            return null;
        }
        return ntlm;
    }

    public void setFilterConfig(FilterConfig f) {
        try {
            this.init(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FilterConfig getFilterConfig() {
        return null;
    }
}

