/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLRuntimeException;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.AttributeMap;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyMap;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLHelper {
    public static final String LIST_DELIMITERS = " \n\r\t";
    private static Map<String, Object> prettyPrintParams;
    private static DatatypeFactory dataTypeFactory;

    private XMLHelper() {
    }

    public static DatatypeFactory getDataTypeFactory() {
        if (dataTypeFactory == null) {
            try {
                dataTypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                // empty catch block
            }
        }
        return dataTypeFactory;
    }

    public static boolean hasXSIType(Element e) {
        return e != null && e.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type") != null;
    }

    public static QName getXSIType(Element e) {
        if (XMLHelper.hasXSIType(e)) {
            String localPart;
            Attr attribute = e.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String attributeValue = attribute.getTextContent().trim();
            StringTokenizer tokenizer = new StringTokenizer(attributeValue, ":");
            String prefix = null;
            if (tokenizer.countTokens() > 1) {
                prefix = tokenizer.nextToken();
                localPart = tokenizer.nextToken();
            } else {
                localPart = tokenizer.nextToken();
            }
            return XMLHelper.constructQName(e.lookupNamespaceURI(prefix), localPart, prefix);
        }
        return null;
    }

    public static Attr getIdAttribute(Element domElement) {
        if (!domElement.hasAttributes()) {
            return null;
        }
        NamedNodeMap attributes = domElement.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(i);
            if (attribute.isId()) {
                return attribute;
            }
            ++i;
        }
        return null;
    }

    public static QName getNodeQName(Node domNode) {
        if (domNode != null) {
            return XMLHelper.constructQName(domNode.getNamespaceURI(), domNode.getLocalName(), domNode.getPrefix());
        }
        return null;
    }

    public static Locale getLanguage(Element element) {
        String lang = DatatypeHelper.safeTrimOrNullString(element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang"));
        if (lang != null) {
            if (lang.contains("-")) {
                lang = lang.substring(0, lang.indexOf("-"));
            }
            return new Locale(lang.toUpperCase());
        }
        return Locale.getDefault();
    }

    public static Attr constructAttribute(Document owningDocument, QName attributeName) {
        return XMLHelper.constructAttribute(owningDocument, attributeName.getNamespaceURI(), attributeName.getLocalPart(), attributeName.getPrefix());
    }

    public static Attr constructAttribute(Document document, String namespaceURI, String localName, String prefix) {
        String trimmedLocalName = DatatypeHelper.safeTrimOrNullString(localName);
        if (trimmedLocalName == null) {
            throw new IllegalArgumentException("Local name may not be null or empty");
        }
        String trimmedPrefix = DatatypeHelper.safeTrimOrNullString(prefix);
        String qualifiedName = trimmedPrefix != null ? String.valueOf(trimmedPrefix) + ":" + DatatypeHelper.safeTrimOrNullString(trimmedLocalName) : DatatypeHelper.safeTrimOrNullString(trimmedLocalName);
        if (DatatypeHelper.isEmpty(namespaceURI)) {
            return document.createAttributeNS(null, qualifiedName);
        }
        return document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public static QName getAttributeValueAsQName(Attr attribute) {
        if (attribute == null || DatatypeHelper.isEmpty(attribute.getValue())) {
            return null;
        }
        String attributeValue = attribute.getTextContent();
        String[] valueComponents = attributeValue.split(":");
        if (valueComponents.length == 1) {
            return XMLHelper.constructQName(attribute.lookupNamespaceURI(null), valueComponents[0], null);
        }
        return XMLHelper.constructQName(attribute.lookupNamespaceURI(valueComponents[0]), valueComponents[1], valueComponents[0]);
    }

    public static Boolean getAttributeValueAsBoolean(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        String valueStr = attribute.getValue();
        if (valueStr.equals("0") || valueStr.equals("false")) {
            return Boolean.FALSE;
        }
        if (valueStr.equals("1") || valueStr.equals("true")) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static List<String> getAttributeValueAsList(Attr attribute) {
        if (attribute == null) {
            return Collections.emptyList();
        }
        return DatatypeHelper.stringToList(attribute.getValue(), LIST_DELIMITERS);
    }

    public static void marshallAttribute(QName attributeName, String attributeValue, Element domElement, boolean isIDAttribute) {
        Document document = domElement.getOwnerDocument();
        Attr attribute = XMLHelper.constructAttribute(document, attributeName);
        attribute.setValue(attributeValue);
        domElement.setAttributeNodeNS(attribute);
        if (isIDAttribute) {
            domElement.setIdAttributeNode(attribute, true);
        }
    }

    public static void marshallAttribute(QName attributeName, List<String> attributeValues, Element domElement, boolean isIDAttribute) {
        XMLHelper.marshallAttribute(attributeName, DatatypeHelper.listToStringValue(attributeValues, " "), domElement, isIDAttribute);
    }

    public static void marshallAttributeMap(AttributeMap attributeMap, Element domElement) {
        Document document = domElement.getOwnerDocument();
        Attr attribute = null;
        for (Map.Entry<QName, String> entry : attributeMap.entrySet()) {
            attribute = XMLHelper.constructAttribute(document, entry.getKey());
            attribute.setValue(entry.getValue());
            domElement.setAttributeNodeNS(attribute);
            if (!Configuration.isIDAttribute(entry.getKey()) && !attributeMap.isIDAttribute(entry.getKey())) continue;
            domElement.setIdAttributeNode(attribute, true);
        }
    }

    public static void unmarshallToAttributeMap(AttributeMap attributeMap, Attr attribute) {
        QName attribQName = XMLHelper.constructQName(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getPrefix());
        attributeMap.put(attribQName, attribute.getValue());
        if (attribute.isId() || Configuration.isIDAttribute(attribQName)) {
            attributeMap.registerID(attribQName);
        }
    }

    public static QName getElementContentAsQName(Element element) {
        if (element == null) {
            return null;
        }
        String elementContent = null;
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                elementContent = DatatypeHelper.safeTrimOrNullString(((Text)node).getWholeText());
                break;
            }
            ++i;
        }
        if (elementContent == null) {
            return null;
        }
        String[] valueComponents = elementContent.split(":");
        if (valueComponents.length == 1) {
            return XMLHelper.constructQName(element.lookupNamespaceURI(null), valueComponents[0], null);
        }
        return XMLHelper.constructQName(element.lookupNamespaceURI(valueComponents[0]), valueComponents[1], valueComponents[0]);
    }

    public static List<String> getElementContentAsList(Element element) {
        if (element == null) {
            return Collections.emptyList();
        }
        return DatatypeHelper.stringToList(element.getTextContent(), LIST_DELIMITERS);
    }

    public static QName constructQName(String namespaceURI, String localName, String prefix) {
        if (DatatypeHelper.isEmpty(prefix)) {
            return new QName(namespaceURI, localName);
        }
        if (DatatypeHelper.isEmpty(namespaceURI)) {
            return new QName(localName);
        }
        return new QName(namespaceURI, localName, prefix);
    }

    public static QName constructQName(String qname, XMLObject owningObject) {
        return XMLHelper.constructQName(qname, owningObject.getDOM());
    }

    public static QName constructQName(String qname, Element owningElement) {
        String name;
        String nsPrefix;
        if (qname.indexOf(":") > -1) {
            StringTokenizer qnameTokens = new StringTokenizer(qname, ":");
            nsPrefix = qnameTokens.nextToken();
            name = qnameTokens.nextToken();
        } else {
            nsPrefix = "";
            name = qname;
        }
        String nsURI = XMLHelper.lookupNamespaceURI(owningElement, nsPrefix);
        return XMLHelper.constructQName(nsURI, name, nsPrefix);
    }

    public static Element constructElement(Document document, QName elementName) {
        return XMLHelper.constructElement(document, elementName.getNamespaceURI(), elementName.getLocalPart(), elementName.getPrefix());
    }

    public static Element constructElement(Document document, String namespaceURI, String localName, String prefix) {
        String trimmedLocalName = DatatypeHelper.safeTrimOrNullString(localName);
        if (trimmedLocalName == null) {
            throw new IllegalArgumentException("Local name may not be null or empty");
        }
        String trimmedPrefix = DatatypeHelper.safeTrimOrNullString(prefix);
        String qualifiedName = trimmedPrefix != null ? String.valueOf(trimmedPrefix) + ":" + DatatypeHelper.safeTrimOrNullString(trimmedLocalName) : DatatypeHelper.safeTrimOrNullString(trimmedLocalName);
        if (!DatatypeHelper.isEmpty(namespaceURI)) {
            return document.createElementNS(namespaceURI, qualifiedName);
        }
        return document.createElementNS(null, qualifiedName);
    }

    public static void appendChildElement(Element parentElement, Element childElement) {
        Document parentDocument = parentElement.getOwnerDocument();
        XMLHelper.adoptElement(childElement, parentDocument);
        parentElement.appendChild(childElement);
    }

    public static void adoptElement(Element adoptee, Document adopter) {
        if (!adoptee.getOwnerDocument().equals(adopter) && adopter.adoptNode(adoptee) == null) {
            throw new XMLRuntimeException("DOM Element node adoption failed");
        }
    }

    public static void appendTextContent(Element domElement, String textContent) {
        if (textContent == null) {
            return;
        }
        Document parentDocument = domElement.getOwnerDocument();
        Text textNode = parentDocument.createTextNode(textContent);
        domElement.appendChild(textNode);
    }

    public static void appendNamespaceDeclaration(Element domElement, String namespaceURI, String prefix) {
        String nsURI = DatatypeHelper.safeTrimOrNullString(namespaceURI);
        String nsPrefix = DatatypeHelper.safeTrimOrNullString(prefix);
        String attributeName = nsPrefix == null ? "xmlns" : "xmlns:" + nsPrefix;
        String attributeValue = nsURI == null ? "" : nsURI;
        domElement.setAttributeNS("http://www.w3.org/2000/xmlns/", attributeName, attributeValue);
    }

    public static String lookupNamespaceURI(Element startingElement, String prefix) {
        return XMLHelper.lookupNamespaceURI(startingElement, null, prefix);
    }

    public static String lookupNamespaceURI(Element startingElement, Element stopingElement, String prefix) {
        Element ancestor;
        if (startingElement.hasAttributes()) {
            NamedNodeMap map = startingElement.getAttributes();
            int length = map.getLength();
            int i = 0;
            while (i < length) {
                Node attr = map.item(i);
                String attrPrefix = attr.getPrefix();
                String value = attr.getNodeValue();
                String namespaceURI = attr.getNamespaceURI();
                if (namespaceURI != null && namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                    if (prefix == null && attr.getNodeName().equals("xmlns")) {
                        return value;
                    }
                    if (attrPrefix != null && attrPrefix.equals("xmlns") && attr.getLocalName().equals(prefix)) {
                        return value;
                    }
                }
                ++i;
            }
        }
        if (startingElement != stopingElement && (ancestor = XMLHelper.getElementAncestor(startingElement)) != null) {
            return XMLHelper.lookupNamespaceURI(ancestor, stopingElement, prefix);
        }
        return null;
    }

    public static String lookupPrefix(Element startingElement, String namespaceURI) {
        return XMLHelper.lookupPrefix(startingElement, null, namespaceURI);
    }

    public static String lookupPrefix(Element startingElement, Element stopingElement, String namespaceURI) {
        Element ancestor;
        if (startingElement.hasAttributes()) {
            NamedNodeMap map = startingElement.getAttributes();
            int length = map.getLength();
            int i = 0;
            while (i < length) {
                String localname;
                String foundNamespace;
                Node attr = map.item(i);
                String attrPrefix = attr.getPrefix();
                String value = attr.getNodeValue();
                String namespace = attr.getNamespaceURI();
                if (namespace != null && namespace.equals("http://www.w3.org/2000/xmlns/") && (attr.getNodeName().equals("xmlns") || attrPrefix != null && attrPrefix.equals("xmlns") && value.equals(namespaceURI)) && (foundNamespace = startingElement.lookupNamespaceURI(localname = attr.getLocalName())) != null && foundNamespace.equals(namespaceURI)) {
                    return localname;
                }
                ++i;
            }
        }
        if (startingElement != stopingElement && (ancestor = XMLHelper.getElementAncestor(startingElement)) != null) {
            return XMLHelper.lookupPrefix(ancestor, stopingElement, namespaceURI);
        }
        return null;
    }

    public static List<Element> getChildElementsByTagNameNS(Element root, String namespaceURI, String localName) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList childNodes = root.getChildNodes();
        int numOfNodes = childNodes.getLength();
        int i = 0;
        while (i < numOfNodes) {
            Element e;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1 && DatatypeHelper.safeEquals((e = (Element)childNode).getNamespaceURI(), namespaceURI) && DatatypeHelper.safeEquals(e.getLocalName(), localName)) {
                children.add(e);
            }
            ++i;
        }
        return children;
    }

    public static List<Element> getChildElementsByTagName(Element root, String localName) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList childNodes = root.getChildNodes();
        int numOfNodes = childNodes.getLength();
        int i = 0;
        while (i < numOfNodes) {
            Element e;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1 && DatatypeHelper.safeEquals((e = (Element)childNode).getLocalName(), localName)) {
                children.add(e);
            }
            ++i;
        }
        return children;
    }

    public static Map<QName, List<Element>> getChildElements(Element root) {
        HashMap<QName, List<Element>> children = new HashMap<QName, List<Element>>();
        NodeList childNodes = root.getChildNodes();
        int numOfNodes = childNodes.getLength();
        int i = 0;
        while (i < numOfNodes) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                Element e = (Element)childNode;
                QName qname = XMLHelper.getNodeQName(e);
                ArrayList<Element> elements = (ArrayList<Element>)children.get(qname);
                if (elements == null) {
                    elements = new ArrayList<Element>();
                    children.put(qname, elements);
                }
                elements.add(e);
            }
            ++i;
        }
        return children;
    }

    public static Element getElementAncestor(Node currentNode) {
        Node parent = currentNode.getParentNode();
        if (parent != null) {
            short type = parent.getNodeType();
            if (type == 1) {
                return (Element)parent;
            }
            return XMLHelper.getElementAncestor(parent);
        }
        return null;
    }

    public static String nodeToString(Node node) {
        StringWriter writer = new StringWriter();
        XMLHelper.writeNode(node, writer);
        return writer.toString();
    }

    public static String prettyPrintXML(Node node) {
        StringWriter writer = new StringWriter();
        XMLHelper.writeNode(node, writer, XMLHelper.getPrettyPrintParams());
        return writer.toString();
    }

    private static Map<String, Object> getPrettyPrintParams() {
        if (prettyPrintParams == null) {
            prettyPrintParams = new LazyMap<String, Object>();
            prettyPrintParams.put("format-pretty-print", Boolean.TRUE);
        }
        return prettyPrintParams;
    }

    public static void writeNode(Node node, Writer output) {
        XMLHelper.writeNode(node, output, null);
    }

    public static void writeNode(Node node, Writer output, Map<String, Object> serializerParams) {
        DOMImplementationLS domImplLS = XMLHelper.getLSDOMImpl(node);
        LSSerializer serializer = XMLHelper.getLSSerializer(domImplLS, serializerParams);
        LSOutput serializerOut = domImplLS.createLSOutput();
        serializerOut.setCharacterStream(output);
        serializer.write(node, serializerOut);
    }

    public static void writeNode(Node node, OutputStream output) {
        XMLHelper.writeNode(node, output, null);
    }

    public static void writeNode(Node node, OutputStream output, Map<String, Object> serializerParams) {
        DOMImplementationLS domImplLS = XMLHelper.getLSDOMImpl(node);
        LSSerializer serializer = XMLHelper.getLSSerializer(domImplLS, serializerParams);
        LSOutput serializerOut = domImplLS.createLSOutput();
        serializerOut.setByteStream(output);
        serializer.write(node, serializerOut);
    }

    public static LSSerializer getLSSerializer(DOMImplementationLS domImplLS, Map<String, Object> serializerParams) {
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.setFilter(new LSSerializerFilter(){

            public short acceptNode(Node arg0) {
                return 1;
            }

            public int getWhatToShow() {
                return -1;
            }
        });
        if (serializerParams != null) {
            DOMConfiguration serializerDOMConfig = serializer.getDomConfig();
            for (String key : serializerParams.keySet()) {
                serializerDOMConfig.setParameter(key, serializerParams.get(key));
            }
        }
        return serializer;
    }

    public static DOMImplementationLS getLSDOMImpl(Node node) {
        DOMImplementation domImpl = node instanceof Document ? ((Document)node).getImplementation() : node.getOwnerDocument().getImplementation();
        DOMImplementationLS domImplLS = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
        return domImplLS;
    }

    public static String qnameToContentString(QName qname) {
        StringBuffer buf = new StringBuffer();
        String prefix = DatatypeHelper.safeTrimOrNullString(qname.getPrefix());
        if (prefix != null) {
            buf.append(prefix);
            buf.append(":");
        }
        buf.append(qname.getLocalPart());
        return buf.toString();
    }

    public static void rootNamespaces(Element domElement) throws XMLParserException {
        XMLHelper.rootNamespaces(domElement, domElement);
    }

    private static void rootNamespaces(Element domElement, Element upperNamespaceSearchBound) throws XMLParserException {
        String namespaceURI = null;
        String namespacePrefix = domElement.getPrefix();
        boolean nsDeclaredOnElement = false;
        nsDeclaredOnElement = namespacePrefix == null ? domElement.hasAttributeNS(null, "xmlns") : domElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", namespacePrefix);
        if (!nsDeclaredOnElement && (namespaceURI = XMLHelper.lookupNamespaceURI(domElement, upperNamespaceSearchBound, namespacePrefix)) == null) {
            namespaceURI = XMLHelper.lookupNamespaceURI(upperNamespaceSearchBound, null, namespacePrefix);
            if (namespaceURI != null) {
                XMLHelper.appendNamespaceDeclaration(domElement, namespaceURI, namespacePrefix);
            } else if (namespacePrefix != null) {
                throw new XMLParserException("Unable to resolve namespace prefix " + namespacePrefix + " found on element " + XMLHelper.getNodeQName(domElement));
            }
        }
        NamedNodeMap attributes = domElement.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            namespacePrefix = null;
            namespaceURI = null;
            Node attributeNode = attributes.item(i);
            if (!(attributeNode.getNodeType() != 2 || DatatypeHelper.isEmpty(namespacePrefix = attributeNode.getPrefix()) || namespacePrefix.equals("xmlns") || namespacePrefix.equals("xml") || (namespaceURI = XMLHelper.lookupNamespaceURI(domElement, upperNamespaceSearchBound, namespacePrefix)) != null)) {
                namespaceURI = XMLHelper.lookupNamespaceURI(upperNamespaceSearchBound, null, namespacePrefix);
                if (namespaceURI == null) {
                    throw new XMLParserException("Unable to resolve namespace prefix " + namespacePrefix + " found on attribute " + XMLHelper.getNodeQName(attributeNode) + " found on element " + XMLHelper.getNodeQName(domElement));
                }
                XMLHelper.appendNamespaceDeclaration(domElement, namespaceURI, namespacePrefix);
            }
            ++i;
        }
        NodeList childNodes = domElement.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Node childNode = childNodes.item(i2);
            if (childNode.getNodeType() == 1) {
                XMLHelper.rootNamespaces((Element)childNode, upperNamespaceSearchBound);
            }
            ++i2;
        }
    }

    public static boolean isElementNamed(Element e, String ns, String localName) {
        return e != null && DatatypeHelper.safeEquals(ns, e.getNamespaceURI()) && DatatypeHelper.safeEquals(localName, e.getLocalName());
    }

    public static Element getFirstChildElement(Node n) {
        Node child = n.getFirstChild();
        while (child != null && child.getNodeType() != 1) {
            child = child.getNextSibling();
        }
        if (child != null) {
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node n) {
        Node sib = n.getNextSibling();
        while (sib != null && sib.getNodeType() != 1) {
            sib = sib.getNextSibling();
        }
        if (sib != null) {
            return (Element)sib;
        }
        return null;
    }

    public static long durationToLong(String duration) {
        Duration xmlDuration = XMLHelper.getDataTypeFactory().newDuration(duration);
        return xmlDuration.getTimeInMillis(new GregorianCalendar());
    }

    public static String longToDuration(long duration) {
        Duration xmlDuration = XMLHelper.getDataTypeFactory().newDuration(duration);
        return xmlDuration.toString();
    }
}

