/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.soap.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.soap.client.ClientTransport;
import org.opensaml.ws.transport.TransportException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransport;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSOAPTransport
implements ClientTransport {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAPTransport.class);
    private HttpClient httpClient;
    private MessageEncoder messageEncoder;
    private MessageDecoder messageDecoder;

    public HTTPSOAPTransport(HttpClient client, MessageEncoder encoder, MessageDecoder decoder) {
        this.httpClient = client;
        this.messageEncoder = encoder;
        this.messageDecoder = decoder;
    }

    public void send(URI endpointURI, MessageContext messageContext) throws TransportException {
        try {
            PostMethod postMethod = new PostMethod(endpointURI.toASCIIString());
            PostMethodHttpOutTransport outTransport = new PostMethodHttpOutTransport(postMethod);
            messageContext.setOutboundMessageTransport(outTransport);
            this.messageEncoder.encode(messageContext);
            this.httpClient.executeMethod((HttpMethod)postMethod);
            PostMethodHttpInTransport inTransport = new PostMethodHttpInTransport(postMethod);
            messageContext.setInboundMessageTransport(inTransport);
            this.messageDecoder.decode(messageContext);
        }
        catch (IOException e) {
            throw new TransportException("Unable to establish connection to peer", e);
        }
        catch (MessageEncodingException e) {
            throw new TransportException("Unable to encode message onto outbound transport", e);
        }
        catch (MessageDecodingException e) {
            throw new TransportException("Unable to decode message from inbound transport", e);
        }
        catch (SecurityException e) {
            throw new TransportException("Inbound transport and response did not meet security policy requirements", (Exception)((Object)e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PostMethodHttpInTransport
    implements HTTPInTransport {
        private PostMethod postMethod;
        private boolean transportAuthenticated;
        private boolean transportConfidential;
        private boolean transportIntegrityProtected;

        public PostMethodHttpInTransport(PostMethod method) {
            this.postMethod = method;
        }

        @Override
        public String getPeerAddress() {
            return null;
        }

        @Override
        public String getPeerDomainName() {
            try {
                return this.postMethod.getURI().getHost();
            }
            catch (URIException e) {
                HTTPSOAPTransport.this.log.error("Unable to recover host from request URI", (Throwable)e);
                return null;
            }
        }

        @Override
        public InputStream getIncomingStream() {
            try {
                return this.postMethod.getResponseBodyAsStream();
            }
            catch (IOException e) {
                HTTPSOAPTransport.this.log.error("Unable to retrieve response stream", (Throwable)e);
                return null;
            }
        }

        @Override
        public Object getAttribute(String name) {
            return null;
        }

        @Override
        public String getCharacterEncoding() {
            return this.postMethod.getResponseCharSet();
        }

        @Override
        public Credential getLocalCredential() {
            return null;
        }

        @Override
        public Credential getPeerCredential() {
            return null;
        }

        @Override
        public boolean isAuthenticated() {
            return this.transportAuthenticated;
        }

        @Override
        public boolean isConfidential() {
            return this.transportConfidential;
        }

        @Override
        public void setAuthenticated(boolean isAuthenticated) {
            this.transportAuthenticated = isAuthenticated;
        }

        @Override
        public void setConfidential(boolean isConfidential) {
            this.transportConfidential = isConfidential;
        }

        @Override
        public String getHTTPMethod() {
            return this.postMethod.getName();
        }

        @Override
        public String getHeaderValue(String name) {
            return this.postMethod.getResponseHeader(name).getValue();
        }

        @Override
        public String getParameterValue(String name) {
            return null;
        }

        @Override
        public List<String> getParameterValues(String name) {
            return null;
        }

        @Override
        public int getStatusCode() {
            return this.postMethod.getStatusCode();
        }

        @Override
        public HTTPTransport.HTTP_VERSION getVersion() {
            HttpVersion httpVersion = this.postMethod.getEffectiveVersion();
            if (httpVersion == HttpVersion.HTTP_1_0) {
                return HTTPTransport.HTTP_VERSION.HTTP1_0;
            }
            if (httpVersion == HttpVersion.HTTP_1_1) {
                return HTTPTransport.HTTP_VERSION.HTTP1_1;
            }
            return null;
        }

        @Override
        public boolean isIntegrityProtected() {
            return this.transportIntegrityProtected;
        }

        @Override
        public void setIntegrityProtected(boolean isIntegrityProtected) {
            this.transportIntegrityProtected = isIntegrityProtected;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PostMethodHttpOutTransport
    implements HTTPOutTransport {
        private PostMethod postMethod;
        private boolean transportAuthenticated;
        private boolean transportConfidential;
        private boolean transportIntegrityProtected;

        public PostMethodHttpOutTransport(PostMethod method) {
            this.postMethod = method;
        }

        @Override
        public void sendRedirect(String location) {
        }

        @Override
        public void setHeader(String name, String value) {
            this.postMethod.addRequestHeader(name, value);
        }

        @Override
        public void addParameter(String name, String value) {
        }

        @Override
        public void setStatusCode(int code) {
        }

        @Override
        public void setVersion(HTTPTransport.HTTP_VERSION version) {
        }

        @Override
        public OutputStream getOutgoingStream() {
            try {
                PipedInputStream requestInputStream = new PipedInputStream();
                PipedOutputStream pipedOutput = new PipedOutputStream(requestInputStream);
                requestInputStream.connect(pipedOutput);
                InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)requestInputStream);
                this.postMethod.setRequestEntity((RequestEntity)requestEntity);
                return pipedOutput;
            }
            catch (IOException e) {
                HTTPSOAPTransport.this.log.error("Error constructing output stream to POST method body", (Throwable)e);
                return null;
            }
        }

        @Override
        public void setAttribute(String name, Object value) {
        }

        @Override
        public void setCharacterEncoding(String encoding) {
        }

        @Override
        public Object getAttribute(String name) {
            return null;
        }

        @Override
        public String getCharacterEncoding() {
            return this.postMethod.getRequestCharSet();
        }

        @Override
        public Credential getLocalCredential() {
            return null;
        }

        @Override
        public Credential getPeerCredential() {
            return null;
        }

        @Override
        public boolean isAuthenticated() {
            return this.transportAuthenticated;
        }

        @Override
        public boolean isConfidential() {
            return this.transportConfidential;
        }

        @Override
        public void setAuthenticated(boolean isAuthenticated) {
            this.transportAuthenticated = isAuthenticated;
        }

        @Override
        public void setConfidential(boolean isConfidential) {
            this.transportConfidential = isConfidential;
        }

        @Override
        public String getHTTPMethod() {
            return this.postMethod.getName();
        }

        @Override
        public String getHeaderValue(String name) {
            return this.postMethod.getRequestHeader(name).getValue();
        }

        @Override
        public String getParameterValue(String name) {
            return this.postMethod.getParameter(name).getValue();
        }

        @Override
        public List<String> getParameterValues(String name) {
            ArrayList<String> valueList = new ArrayList<String>();
            NameValuePair[] parameters = this.postMethod.getParameters();
            if (parameters != null) {
                for (NameValuePair parameter : parameters) {
                    if (!parameter.getName().equals(name)) continue;
                    valueList.add(parameter.getValue());
                }
            }
            return valueList;
        }

        @Override
        public int getStatusCode() {
            return -1;
        }

        @Override
        public HTTPTransport.HTTP_VERSION getVersion() {
            HttpVersion httpVersion = this.postMethod.getEffectiveVersion();
            if (httpVersion == HttpVersion.HTTP_1_0) {
                return HTTPTransport.HTTP_VERSION.HTTP1_0;
            }
            if (httpVersion == HttpVersion.HTTP_1_1) {
                return HTTPTransport.HTTP_VERSION.HTTP1_1;
            }
            return null;
        }

        @Override
        public boolean isIntegrityProtected() {
            return this.transportIntegrityProtected;
        }

        @Override
        public void setIntegrityProtected(boolean isIntegrityProtected) {
            this.transportIntegrityProtected = isIntegrityProtected;
        }
    }
}

