/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementParameter;
import org.opensaml.xmlsec.agreement.XMLExpressableKeyAgreementParameter;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.KANonce;
import org.opensaml.xmlsec.encryption.OriginatorKeyInfo;
import org.opensaml.xmlsec.encryption.RecipientKeyInfo;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyAgreementKeyInfoGeneratorFactory
extends BasicKeyInfoGeneratorFactory {
    private final KeyAgreementOptions options = (KeyAgreementOptions)super.getOptions();

    @Override
    @Nonnull
    public Class<? extends Credential> getCredentialType() {
        return KeyAgreementCredential.class;
    }

    @Override
    public boolean handles(@Nonnull Credential credential) {
        return credential instanceof KeyAgreementCredential;
    }

    @Override
    @Nonnull
    public KeyInfoGenerator newInstance() {
        return this.newInstance(null);
    }

    @Override
    @Nonnull
    public KeyInfoGenerator newInstance(@Nullable Class<? extends KeyInfo> type) {
        return new KeyAgreementKeyInfoGenerator(this.options.clone(), type);
    }

    public boolean emitOriginatorKeyInfo() {
        return this.options.emitOriginatorKeyInfo;
    }

    public void setEmitOriginatorKeyInfo(boolean newValue) {
        this.options.emitOriginatorKeyInfo = newValue;
    }

    public boolean emitRecipientKeyInfo() {
        return this.options.emitRecipientKeyInfo;
    }

    public void setEmitRecipientKeyInfo(boolean newValue) {
        this.options.emitRecipientKeyInfo = newValue;
    }

    public KeyInfoGeneratorManager getOriginatorKeyInfoGeneratorManager() {
        return this.options.originatorKeyInfoGeneratorManager;
    }

    public void setOriginatorKeyInfoGeneratorManager(@Nullable KeyInfoGeneratorManager manager) {
        this.options.originatorKeyInfoGeneratorManager = manager;
    }

    public KeyInfoGeneratorManager getRecipientKeyInfoGeneratorManager() {
        return this.options.recipientKeyInfoGeneratorManager;
    }

    public void setRecipientKeyInfoGeneratorManager(@Nullable KeyInfoGeneratorManager manager) {
        this.options.recipientKeyInfoGeneratorManager = manager;
    }

    @Override
    @Nonnull
    protected KeyAgreementOptions getOptions() {
        return this.options;
    }

    @Override
    @Nonnull
    protected KeyAgreementOptions newOptions() {
        return new KeyAgreementOptions();
    }

    protected class KeyAgreementOptions
    extends BasicKeyInfoGeneratorFactory.BasicOptions {
        private boolean emitOriginatorKeyInfo = true;
        private boolean emitRecipientKeyInfo = true;
        private KeyInfoGeneratorManager originatorKeyInfoGeneratorManager = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager().getDefaultManager();
        private KeyInfoGeneratorManager recipientKeyInfoGeneratorManager = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager().getDefaultManager();

        protected KeyAgreementOptions() {
        }

        @Override
        protected KeyAgreementOptions clone() {
            KeyAgreementOptions clonedOptions = (KeyAgreementOptions)super.clone();
            return clonedOptions;
        }
    }

    public class KeyAgreementKeyInfoGenerator
    extends BasicKeyInfoGeneratorFactory.BasicKeyInfoGenerator {
        private final Logger log;
        private KeyAgreementOptions options;
        private final XMLObjectBuilder<AgreementMethod> agreementMethodBuilder;

        protected KeyAgreementKeyInfoGenerator(KeyAgreementOptions newOptions, Class<? extends KeyInfo> type) {
            super(newOptions, type);
            this.log = LoggerFactory.getLogger(KeyAgreementKeyInfoGenerator.class);
            this.options = newOptions;
            this.agreementMethodBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AgreementMethod.DEFAULT_ELEMENT_NAME);
        }

        @Override
        @Nullable
        public KeyInfo generate(@Nullable Credential credential) throws SecurityException {
            if (credential == null) {
                this.log.warn("KeyAgreementKeyInfoGenerator was passed a null credential");
                return null;
            }
            if (!(credential instanceof KeyAgreementCredential)) {
                this.log.warn("KeyAgreementKeyInfoGenerator was passed a credential that was not an instance of KeyAgreementCredential: {}", (Object)credential.getClass().getName());
                return null;
            }
            KeyAgreementCredential keyAgreementCredential = (KeyAgreementCredential)credential;
            KeyInfo keyInfo = super.generate(credential);
            if (keyInfo == null) {
                keyInfo = this.buildKeyInfo();
            }
            AgreementMethod agreementMethod = (AgreementMethod)this.agreementMethodBuilder.buildObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
            agreementMethod.setAlgorithm(keyAgreementCredential.getAlgorithm());
            this.processAgreementParameters(keyInfo, agreementMethod, keyAgreementCredential);
            this.processOriginatorKeyInfo(keyInfo, agreementMethod, keyAgreementCredential);
            this.processRecipientKeyInfo(keyInfo, agreementMethod, keyAgreementCredential);
            keyInfo.getAgreementMethods().add(agreementMethod);
            return keyInfo;
        }

        private void processAgreementParameters(@Nonnull KeyInfo keyInfo, @Nonnull AgreementMethod agreementMethod, @Nonnull KeyAgreementCredential credential) throws SecurityException {
            for (KeyAgreementParameter param : credential.getParameters()) {
                if (!XMLExpressableKeyAgreementParameter.class.isInstance(param)) continue;
                XMLObject xmlParam = ((XMLExpressableKeyAgreementParameter)XMLExpressableKeyAgreementParameter.class.cast(param)).buildXMLObject();
                if (KANonce.class.isInstance(xmlParam)) {
                    agreementMethod.setKANonce((KANonce)KANonce.class.cast(xmlParam));
                    continue;
                }
                if (xmlParam == null) continue;
                agreementMethod.getUnknownXMLObjects().add(xmlParam);
            }
        }

        private void processOriginatorKeyInfo(@Nonnull KeyInfo keyInfo, @Nonnull AgreementMethod agreementMethod, @Nonnull KeyAgreementCredential credential) throws SecurityException {
            if (this.options.emitOriginatorKeyInfo) {
                if (this.options.originatorKeyInfoGeneratorManager == null) {
                    this.log.warn("KeyInfoGeneratorManager for OriginatorKeyInfo is null, can not process");
                    return;
                }
                if (credential.getOriginatorCredential() == null) {
                    this.log.warn("KeyAgreementCredential originator credential is null, can not process");
                    return;
                }
                KeyInfo originatorKeyInfo = this.options.originatorKeyInfoGeneratorManager.getFactory(credential.getOriginatorCredential()).newInstance(OriginatorKeyInfo.class).generate(credential.getOriginatorCredential());
                if (originatorKeyInfo == null) {
                    this.log.warn("Failed to generate KeyInfo from KeyAgreementCredential originator Credential");
                    return;
                }
                if (!OriginatorKeyInfo.class.isInstance(originatorKeyInfo)) {
                    this.log.warn("KeyInfo generated from KeyAgreementCredential was not OriginatorKeyInfo");
                    return;
                }
                agreementMethod.setOriginatorKeyInfo((OriginatorKeyInfo)OriginatorKeyInfo.class.cast(originatorKeyInfo));
            }
        }

        private void processRecipientKeyInfo(@Nonnull KeyInfo keyInfo, @Nonnull AgreementMethod agreementMethod, @Nonnull KeyAgreementCredential credential) throws SecurityException {
            if (this.options.emitRecipientKeyInfo) {
                if (this.options.recipientKeyInfoGeneratorManager == null) {
                    this.log.warn("KeyInfoGeneratorManager for RecipientKeyInfo is null, can not process");
                    return;
                }
                if (credential.getRecipientCredential() == null) {
                    this.log.warn("KeyAgreementCredential recipient credential is null, can not process");
                    return;
                }
                KeyInfo recipientKeyInfo = this.options.recipientKeyInfoGeneratorManager.getFactory(credential.getRecipientCredential()).newInstance(RecipientKeyInfo.class).generate(credential.getRecipientCredential());
                if (recipientKeyInfo == null) {
                    this.log.warn("Failed to generate KeyInfo from KeyAgreementCredential recipient Credential");
                    return;
                }
                if (!RecipientKeyInfo.class.isInstance(recipientKeyInfo)) {
                    this.log.warn("KeyInfo generated from KeyAgreementCredential was not RecipientKeyInfo");
                    return;
                }
                agreementMethod.setRecipientKeyInfo((RecipientKeyInfo)RecipientKeyInfo.class.cast(recipientKeyInfo));
            }
        }
    }
}

