/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.WhitelistBlacklistParameters;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;

public class BasicSignatureValidationParametersResolver
extends AbstractSecurityParametersResolver<SignatureValidationParameters>
implements SignatureValidationParametersResolver {
    @Nonnull
    public Iterable<SignatureValidationParameters> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        SignatureValidationParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return Collections.singletonList(params);
        }
        return Collections.emptyList();
    }

    @Nullable
    public SignatureValidationParameters resolveSingle(@Nonnull CriteriaSet criteria) throws ResolverException {
        Constraint.isNotNull((Object)criteria, (String)"CriteriaSet was null");
        Constraint.isNotNull((Object)criteria.get(SignatureValidationConfigurationCriterion.class), (String)"Resolver requires an instance of SignatureValidationConfigurationCriterion");
        SignatureValidationParameters params = new SignatureValidationParameters();
        this.resolveAndPopulateWhiteAndBlacklists((WhitelistBlacklistParameters)params, criteria, ((SignatureValidationConfigurationCriterion)criteria.get(SignatureValidationConfigurationCriterion.class)).getConfigurations());
        params.setSignatureTrustEngine(this.resolveSignatureTrustEngine(criteria));
        return params;
    }

    @Nullable
    protected SignatureTrustEngine resolveSignatureTrustEngine(@Nonnull CriteriaSet criteria) {
        for (SignatureValidationConfiguration config : ((SignatureValidationConfigurationCriterion)criteria.get(SignatureValidationConfigurationCriterion.class)).getConfigurations()) {
            if (config.getSignatureTrustEngine() == null) continue;
            return config.getSignatureTrustEngine();
        }
        return null;
    }
}

