/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.testing;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;

public class RequestContextBuilder {
    private final String NO_VAL = "novalue";
    private String inboundMessageId = "novalue";
    private Instant inboundMessageIssueInstant;
    private String inboundMessageIssuer = "novalue";
    private Object inboundMessage;
    private String outboundMessageId = "novalue";
    private Instant outboundMessageIssueInstant;
    private String outboundMessageIssuer = "novalue";
    private Object outboundMessage;

    public RequestContextBuilder() {
    }

    public RequestContextBuilder(RequestContextBuilder prototype) {
        this.inboundMessageId = prototype.inboundMessageId;
        this.inboundMessageIssueInstant = prototype.inboundMessageIssueInstant;
        this.inboundMessageIssuer = prototype.inboundMessageIssuer;
        this.inboundMessage = prototype.inboundMessage;
        this.outboundMessageId = prototype.outboundMessageId;
        this.outboundMessageIssueInstant = prototype.outboundMessageIssueInstant;
        this.outboundMessageIssuer = prototype.outboundMessageIssuer;
        this.outboundMessage = prototype.outboundMessage;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessageId(@Nullable String id) {
        this.inboundMessageId = id;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessageIssueInstant(@Nullable Instant instant) {
        this.inboundMessageIssueInstant = instant;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessageIssuer(@Nullable String issuer) {
        this.inboundMessageIssuer = issuer;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessage(@Nullable Object message) {
        this.inboundMessage = message;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setOutboundMessageId(@Nullable String id) {
        this.outboundMessageId = id;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setOutboundMessageIssueInstant(@Nullable Instant instant) {
        this.outboundMessageIssueInstant = instant;
        return this;
    }

    public RequestContextBuilder setOutboundMessageIssuer(@Nullable String issuer) {
        this.outboundMessageIssuer = issuer;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setOutboundMessage(@Nullable Object message) {
        this.outboundMessage = message;
        return this;
    }

    @Nonnull
    public ProfileRequestContext buildProfileRequestContext() {
        ProfileRequestContext profileContext = new ProfileRequestContext();
        profileContext.setInboundMessageContext(this.buildInboundMessageContext());
        profileContext.setOutboundMessageContext(this.buildOutboundMessageContext());
        return profileContext;
    }

    @Nonnull
    protected MessageContext buildInboundMessageContext() {
        MessageContext context = new MessageContext();
        context.setMessage(this.inboundMessage);
        return context;
    }

    @Nonnull
    protected MessageContext buildOutboundMessageContext() {
        MessageContext context = new MessageContext();
        context.setMessage(this.outboundMessage);
        return context;
    }
}

