/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.memcached;

import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.storage.StorageCapabilities;

public class MemcachedStorageCapabilities
implements StorageCapabilities {
    private static long defaultMaxValue = 0x100000L;
    @Positive
    private final long valueSize;

    public MemcachedStorageCapabilities() {
        this(defaultMaxValue);
    }

    public MemcachedStorageCapabilities(@Positive long maxValueSize) {
        Constraint.isGreaterThan((long)0L, (long)maxValueSize, (String)"Maximum value size must be a positive integer");
        this.valueSize = maxValueSize;
    }

    public int getContextSize() {
        return Integer.MAX_VALUE;
    }

    public int getKeySize() {
        return Integer.MAX_VALUE;
    }

    public long getValueSize() {
        return this.valueSize;
    }

    public boolean isServerSide() {
        return true;
    }

    public boolean isClustered() {
        return true;
    }
}

