/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class StorageServiceRevocationCache
extends AbstractIdentifiableInitializableComponent
implements RevocationCache {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServiceRevocationCache.class);
    @NonnullAfterInit
    private StorageService storage;
    private boolean strict;
    @Nonnull
    @Positive
    private Duration expires = Duration.ofHours(6L);

    public void setEntryExpiration(@Nonnull @Positive Duration entryExpiration) {
        this.checkSetterPreconditions();
        Constraint.isTrue((entryExpiration != null && !entryExpiration.isNegative() && !entryExpiration.isZero() ? 1 : 0) != 0, (String)"Revocation cache default entry expiration must be greater than 0");
        this.expires = entryExpiration;
    }

    @NonnullAfterInit
    public StorageService getStorage() {
        return this.storage;
    }

    public void setStorage(@Nonnull StorageService storageService) {
        this.checkSetterPreconditions();
        this.storage = (StorageService)Constraint.isNotNull((Object)storageService, (String)"StorageService cannot be null");
        Constraint.isTrue((boolean)this.storage.getCapabilities().isServerSide(), (String)"StorageService cannot be client-side");
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean flag) {
        this.checkSetterPreconditions();
        this.strict = flag;
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storage == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
    }

    public synchronized boolean revoke(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value) {
        return this.revoke(context, key, value, this.expires);
    }

    public synchronized boolean revoke(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s, @Nonnull @NotEmpty String value, @Nonnull Duration exp) {
        this.checkComponentActive();
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("context {} too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return false;
        }
        String key = s.length() > caps.getKeySize() ? DigestUtils.sha1Hex((String)s) : s;
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("Entry '{}' of context '{}'\u00a0is not yet on list of revoked entries, adding to cache with expiration time {}", new Object[]{key, context, this.expires});
                this.storage.create(context, key, value, Long.valueOf(Instant.now().plus(exp).toEpochMilli()));
                return true;
            }
            this.storage.updateExpiration(context, key, Long.valueOf(Instant.now().plus(exp).toEpochMilli()));
            this.log.debug("Entry '{}' of context '{}' was already revoked, updating expiration", (Object)key, (Object)context);
            return true;
        }
        catch (IOException e) {
            this.log.error("Exception reading/writing to storage service, returning {}", (Object)(this.strict ? "failure" : "success"), (Object)e);
            return !this.strict;
        }
    }

    public synchronized boolean unrevoke(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s) {
        this.checkComponentActive();
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("context {} too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return false;
        }
        String key = s.length() > caps.getKeySize() ? DigestUtils.sha1Hex((String)s) : s;
        try {
            return this.storage.delete(context, key);
        }
        catch (IOException e) {
            this.log.error("Exception writing to storage service", (Throwable)e);
            return false;
        }
    }

    public synchronized boolean isRevoked(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s) {
        this.checkComponentActive();
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("context {} too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return true;
        }
        String key = s.length() > caps.getKeySize() ? DigestUtils.sha1Hex((String)s) : s;
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("Entry '{}' is not revoked", (Object)key);
                return false;
            }
            this.log.debug("Entry '{}' is revoked", (Object)s);
            return true;
        }
        catch (IOException e) {
            this.log.error("Exception reading  storage service, indicating {}", (Object)(this.strict ? "revoked" : "not revoked"), (Object)e);
            return this.strict;
        }
    }

    @Nullable
    @NotEmpty
    public synchronized String getRevocationRecord(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s) throws IOException {
        this.checkComponentActive();
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("context {} too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            throw new IOException("Context exceeded storage service limit.");
        }
        String key = s.length() > caps.getKeySize() ? DigestUtils.sha1Hex((String)s) : s;
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("Entry '{}' is not revoked", (Object)key);
                return null;
            }
            this.log.debug("Entry '{}' is revoked", (Object)s);
            return entry.getValue();
        }
        catch (IOException e) {
            if (this.strict) {
                throw e;
            }
            this.log.error("Exception reading from storage service, non-strict so treating as non-revoked", (Throwable)e);
            return null;
        }
    }
}

