/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.URISupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageLoadContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadClientStorageServices<InboundMessageType, OutboundMessageType>
extends AbstractProfileAction<InboundMessageType, OutboundMessageType> {
    @Nonnull
    @NotEmpty
    public static final String SUPPORT_FORM_FIELD = "shib_idp_ls_supported";
    @Nonnull
    @NotEmpty
    public static final String SUCCESS_FORM_FIELD = "shib_idp_ls_success";
    @Nonnull
    @NotEmpty
    public static final String VALUE_FORM_FIELD = "shib_idp_ls_value";
    @Nonnull
    @NotEmpty
    public static final String EXCEPTION_FORM_FIELD = "shib_idp_ls_exception";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LoadClientStorageServices.class);
    private boolean useLocalStorage = false;
    @Nonnull
    @NonnullElements
    private Map<String, ClientStorageService> storageServices = Collections.emptyMap();
    @Nullable
    private ClientStorageLoadContext clientStorageLoadCtx;

    public void setUseLocalStorage(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.useLocalStorage = flag;
    }

    public void setStorageServices(@Nonnull @NonnullElements Collection<ClientStorageService> services) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(services, (String)"StorageService collection cannot be null");
        this.storageServices = new HashMap<String, ClientStorageService>(services.size());
        for (ClientStorageService ss : Collections2.filter(services, (Predicate)Predicates.notNull())) {
            this.storageServices.put(ss.getStorageName(), ss);
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.clientStorageLoadCtx = (ClientStorageLoadContext)profileRequestContext.getSubcontext(ClientStorageLoadContext.class);
        if (this.clientStorageLoadCtx == null) {
            this.log.debug("{} No ClientStorageLoadContext found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.error("{} HttpServletRequest not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        String param;
        boolean useLS = this.useLocalStorage;
        if (useLS && ((param = this.getHttpServletRequest().getParameter(SUPPORT_FORM_FIELD)) == null || !Boolean.valueOf(param).booleanValue())) {
            this.log.debug("{} Local storage not available, backing off to cookies", (Object)this.getLogPrefix());
            useLS = false;
        }
        for (String storageKey : this.clientStorageLoadCtx.getStorageKeys()) {
            ClientStorageService storageService = this.storageServices.get(storageKey);
            if (storageService == null) {
                this.log.error("{} ClientStorageService with storage name '{}' missing from configuration", (Object)this.getLogPrefix(), (Object)storageKey);
                continue;
            }
            if (useLS) {
                this.loadFromLocalStorage(storageService);
                continue;
            }
            this.loadFromCookie(storageService, ClientStorageService.ClientStorageSource.COOKIE);
        }
        profileRequestContext.removeSubcontext((BaseContext)this.clientStorageLoadCtx);
    }

    private void loadFromCookie(final @Nonnull ClientStorageService storageService, @Nonnull ClientStorageService.ClientStorageSource source) {
        Optional cookie = Optional.absent();
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies != null) {
            cookie = Iterables.tryFind(Arrays.asList(cookies), (Predicate)new Predicate<Cookie>(){

                public boolean apply(@Nullable Cookie c) {
                    return c != null && c.getName().equals(storageService.getStorageName());
                }
            });
        }
        if (!cookie.isPresent() || Strings.isNullOrEmpty((String)((Cookie)cookie.get()).getValue())) {
            this.log.debug("{} No cookie data present, initializing StorageService '{}' to empty state", (Object)this.getLogPrefix(), (Object)storageService.getId());
            storageService.load(null, source);
        } else {
            this.log.debug("{} Initializing StorageService '{}' from cookie", (Object)this.getLogPrefix(), (Object)storageService.getId());
            storageService.load(URISupport.doURLDecode((String)((Cookie)cookie.get()).getValue()), source);
        }
    }

    private void loadFromLocalStorage(@Nonnull ClientStorageService storageService) {
        HttpServletRequest request = this.getHttpServletRequest();
        String param = request.getParameter("shib_idp_ls_success." + storageService.getStorageName());
        if (param == null || !Boolean.valueOf(param).booleanValue()) {
            param = request.getParameter("shib_idp_ls_exception." + storageService.getStorageName());
            this.log.debug("{} Load from local storage failed ({}), initializing StorageService '{}' to empty state", new Object[]{this.getLogPrefix(), param, storageService.getId()});
            storageService.load(null, ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
            return;
        }
        param = request.getParameter("shib_idp_ls_value." + storageService.getStorageName());
        if (param == null || param.isEmpty()) {
            this.log.debug("{} No local storage data present, checking for a cookie set by older storage implementation", (Object)this.getLogPrefix(), (Object)storageService.getId());
            this.loadFromCookie(storageService, ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
        } else {
            this.log.debug("{} Initializing StorageService '{}' from local storage data", (Object)this.getLogPrefix(), (Object)storageService.getId());
            storageService.load(param, ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
        }
    }
}

