/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.URISupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageSaveContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveCookieBackedClientStorageServices<InboundMessageType, OutboundMessageType>
extends AbstractProfileAction<InboundMessageType, OutboundMessageType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SaveCookieBackedClientStorageServices.class);
    @Nonnull
    @NonnullElements
    private Map<String, ClientStorageService> storageServices = Collections.emptyMap();
    @Nullable
    private ClientStorageSaveContext clientStorageSaveCtx;

    public void setStorageServices(@Nonnull @NonnullElements Collection<ClientStorageService> services) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(services, (String)"StorageService collection cannot be null");
        this.storageServices = new HashMap<String, ClientStorageService>(services.size());
        for (ClientStorageService ss : Collections2.filter(services, (Predicate)Predicates.notNull())) {
            this.storageServices.put(ss.getId(), ss);
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.clientStorageSaveCtx = (ClientStorageSaveContext)profileRequestContext.getSubcontext(ClientStorageSaveContext.class);
        if (this.clientStorageSaveCtx == null) {
            this.log.debug("{} No ClientStorageSaveContext found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (!this.clientStorageSaveCtx.isSourceRequired(ClientStorageService.ClientStorageSource.COOKIE)) {
            this.log.debug("{} No cookie operations required", (Object)this.getLogPrefix());
            profileRequestContext.removeSubcontext((BaseContext)this.clientStorageSaveCtx);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        for (ClientStorageServiceOperation operation : this.clientStorageSaveCtx.getStorageOperations()) {
            ClientStorageService storageService = this.storageServices.get(operation.getStorageServiceID());
            if (storageService == null) {
                this.log.error("{} ClientStorageService with ID '{}' missing from configuration", (Object)this.getLogPrefix(), (Object)operation.getStorageServiceID());
                continue;
            }
            if (operation.getValue() != null) {
                this.log.debug("{} Saving data for ClientStorageService '{}' to cookie named '{}'", new Object[]{this.getLogPrefix(), operation.getStorageServiceID(), operation.getKey()});
                storageService.getCookieManager().addCookie(operation.getKey(), URISupport.doURLEncode((String)operation.getValue()));
                continue;
            }
            this.log.debug("{} Clearing data for ClientStorageService '{}' from cookie named '{}'", new Object[]{this.getLogPrefix(), operation.getStorageServiceID(), operation.getKey()});
            storageService.getCookieManager().unsetCookie(operation.getKey());
        }
        profileRequestContext.removeSubcontext((BaseContext)this.clientStorageSaveCtx);
    }
}

