/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.messaging.impl;

import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.SOAPMessagingBaseTestCase;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.Timestamp;
import org.opensaml.soap.wssecurity.messaging.WSSecurityContext;
import org.opensaml.soap.wssecurity.messaging.impl.AddTimestampHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddTimestampHandlerTest
extends SOAPMessagingBaseTestCase {
    private AddTimestampHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new AddTimestampHandler();
    }

    @Test
    public void testNoInput() throws ComponentInitializationException, MessageHandlerException {
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
    }

    @Test
    public void testNoInputUsingCurrentTimeAndOffset() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setUseCurrentTimeAsDefaultCreated(true);
        this.handler.setExpiresOffsetFromCreated(Long.valueOf(300000L));
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertNotNull((Object)timestamp.getCreated().getDateTime());
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)timestamp.getCreated().getDateTime().plus(300000L));
    }

    @Test
    public void testContextBothValues() throws ComponentInitializationException, MessageHandlerException {
        DateTime created = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        DateTime expires = created.plusMinutes(5);
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampCreated(created);
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampExpires(expires);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }

    @Test
    public void testContextCreated() throws ComponentInitializationException, MessageHandlerException {
        DateTime created = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampCreated(created);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNull((Object)timestamp.getExpires());
    }

    @Test
    public void testContextExpires() throws ComponentInitializationException, MessageHandlerException {
        DateTime created = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        DateTime expires = created.plusMinutes(5);
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampExpires(expires);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNull((Object)timestamp.getCreated());
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }

    @Test
    public void testContextCreatedWithOffset() throws ComponentInitializationException, MessageHandlerException {
        DateTime created = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        DateTime expires = created.plusMinutes(5);
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampCreated(created);
        this.handler.setExpiresOffsetFromCreated(Long.valueOf(300000L));
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }

    @Test
    public void testLookupBothValues() throws ComponentInitializationException, MessageHandlerException {
        final DateTime created = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        final DateTime expires = created.plusMinutes(5);
        this.handler.setCreatedLookup((ContextDataLookupFunction)new ContextDataLookupFunction<MessageContext, DateTime>(){

            @Nullable
            public DateTime apply(@Nullable MessageContext input) {
                return created;
            }
        });
        this.handler.setExpiresLookup((ContextDataLookupFunction)new ContextDataLookupFunction<MessageContext, DateTime>(){

            @Nullable
            public DateTime apply(@Nullable MessageContext input) {
                return expires;
            }
        });
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }

    @Test
    public void testLookupCreatedWithOffset() throws ComponentInitializationException, MessageHandlerException {
        final DateTime created = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        DateTime expires = created.plusMinutes(5);
        this.handler.setCreatedLookup((ContextDataLookupFunction)new ContextDataLookupFunction<MessageContext, DateTime>(){

            @Nullable
            public DateTime apply(@Nullable MessageContext input) {
                return created;
            }
        });
        this.handler.setExpiresOffsetFromCreated(Long.valueOf(300000L));
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }
}

