/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.impl;

import org.opensaml.soap.WSBaseTestCase;
import org.opensaml.soap.wsaddressing.Action;
import org.opensaml.soap.wsaddressing.Address;
import org.opensaml.soap.wsaddressing.EndpointReference;
import org.opensaml.soap.wsaddressing.Metadata;
import org.opensaml.soap.wsaddressing.ReferenceParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class WSAddressingObjectsTestCase
extends WSBaseTestCase {
    public Logger log = LoggerFactory.getLogger(WSAddressingObjectsTestCase.class);

    @Test
    public void testAction() throws Exception {
        Action action = (Action)this.buildXMLObject(Action.ELEMENT_NAME);
        action.setValue("urn:test:foo:bar");
        this.marshallAndUnmarshall(action);
    }

    @Test
    public void testAddress() throws Exception {
        Address address = (Address)this.buildXMLObject(Address.ELEMENT_NAME);
        address.setValue("http://www.w3.org/2005/08/addressing/anonymous");
        this.marshallAndUnmarshall(address);
    }

    @Test
    public void testEndpointReference() throws Exception {
        EndpointReference epr = (EndpointReference)this.buildXMLObject(EndpointReference.ELEMENT_NAME);
        Address address = (Address)this.buildXMLObject(Address.ELEMENT_NAME);
        address.setValue("http://www.w3.org/2005/08/addressing/anonymous");
        ReferenceParameters referenceParameters = (ReferenceParameters)this.buildXMLObject(ReferenceParameters.ELEMENT_NAME);
        Metadata metadata = (Metadata)this.buildXMLObject(Metadata.ELEMENT_NAME);
        epr.setAddress(address);
        epr.setMetadata(metadata);
        epr.setReferenceParameters(referenceParameters);
        this.marshallAndUnmarshall(epr);
    }

    @Test
    public void testFaultTo() {
    }

    @Test
    public void testFrom() {
    }

    @Test
    public void testMessageID() {
    }

    @Test
    public void testMetadata() throws Exception {
        Metadata metadata = (Metadata)this.buildXMLObject(Metadata.ELEMENT_NAME);
        this.marshallAndUnmarshall(metadata);
    }

    @Test
    public void testProblemAction() {
    }

    @Test
    public void testProblemHeaderQName() {
    }

    @Test
    public void testProblemIRI() {
    }

    @Test
    public void testReferenceParameters() throws Exception {
        ReferenceParameters referenceParameters = (ReferenceParameters)this.buildXMLObject(ReferenceParameters.ELEMENT_NAME);
        this.marshallAndUnmarshall(referenceParameters);
    }

    @Test
    public void testRelatesTo() {
    }

    @Test
    public void testReplyTo() {
    }

    @Test
    public void testRetryAfter() {
    }

    @Test
    public void testSoapAction() {
    }

    @Test
    public void testTo() {
    }
}

