/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.soap11.decoder.http.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHttpResponse;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.client.soap11.decoder.http.impl.HttpClientResponseSOAP11Decoder;
import org.opensaml.soap.common.SOAP11FaultDecodingException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.util.SOAPSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HttpClientResponseSOAP11DecoderTest
extends XMLObjectBaseTestCase {
    private HttpClientResponseSOAP11Decoder<XMLObject> decoder;

    @BeforeMethod
    public void setUp() {
        this.decoder = new HttpClientResponseSOAP11Decoder();
        this.decoder.setParserPool(parserPool);
    }

    @Test
    public void testDecodeToPayload() throws ComponentInitializationException, MessageDecodingException, MarshallingException, IOException {
        Envelope envelope = this.buildMessageSkeleton();
        envelope.getBody().getUnknownXMLObjects().add(this.buildXMLObject(simpleXMLObjectQName));
        HttpResponse httpResponse = this.buildResponse(200, envelope);
        this.decoder.setBodyHandler((MessageHandler)new TestPayloadBodyHandler());
        this.decoder.setHttpResponse(httpResponse);
        this.decoder.initialize();
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertNotNull((Object)messageContext);
        Assert.assertNotNull((Object)messageContext.getMessage());
        Assert.assertTrue((boolean)(messageContext.getMessage() instanceof SimpleXMLObject));
        SOAP11Context soapContext = (SOAP11Context)messageContext.getSubcontext(SOAP11Context.class, false);
        Assert.assertNotNull((Object)soapContext);
        Assert.assertNotNull((Object)soapContext.getEnvelope());
        Assert.assertEquals((Object)soapContext.getHTTPResponseStatus(), (Object)new Integer(200));
    }

    @Test
    public void testDecodeToEnvelope() throws ComponentInitializationException, MessageDecodingException, MarshallingException, IOException {
        Envelope envelope = this.buildMessageSkeleton();
        envelope.getBody().getUnknownXMLObjects().add(this.buildXMLObject(simpleXMLObjectQName));
        HttpResponse httpResponse = this.buildResponse(200, envelope);
        this.decoder.setBodyHandler((MessageHandler)new TestEnvelopeBodyHandler());
        this.decoder.setHttpResponse(httpResponse);
        this.decoder.initialize();
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertNotNull((Object)messageContext);
        Assert.assertNotNull((Object)messageContext.getMessage());
        Assert.assertTrue((boolean)(messageContext.getMessage() instanceof Envelope));
        SOAP11Context soapContext = (SOAP11Context)messageContext.getSubcontext(SOAP11Context.class, false);
        Assert.assertNotNull((Object)soapContext);
        Assert.assertNotNull((Object)soapContext.getEnvelope());
        Assert.assertEquals((Object)soapContext.getHTTPResponseStatus(), (Object)new Integer(200));
    }

    @Test(expectedExceptions={SOAP11FaultDecodingException.class})
    public void testFault() throws ComponentInitializationException, MessageDecodingException, MarshallingException, IOException {
        Fault fault = SOAPSupport.buildSOAP11Fault((QName)new QName("urn:test:soap:fault:foo", "TestFault", "foo"), (String)"Test fault", null, null, null);
        Envelope envelope = this.buildMessageSkeleton();
        envelope.getBody().getUnknownXMLObjects().add(fault);
        HttpResponse httpResponse = this.buildResponse(500, envelope);
        this.decoder.setBodyHandler((MessageHandler)new TestPayloadBodyHandler());
        this.decoder.setHttpResponse(httpResponse);
        this.decoder.initialize();
        this.decoder.decode();
    }

    private HttpResponse buildResponse(int statusResponseCode, Envelope envelope) throws MarshallingException, IOException {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, statusResponseCode, null);
        Element envelopeElement = XMLObjectSupport.marshall((XMLObject)envelope);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)envelopeElement, (OutputStream)baos);
        baos.flush();
        ByteArrayEntity entity = new ByteArrayEntity(baos.toByteArray());
        response.setEntity((HttpEntity)entity);
        return response;
    }

    private Envelope buildMessageSkeleton() {
        Envelope envelope = (Envelope)this.buildXMLObject(Envelope.DEFAULT_ELEMENT_NAME);
        Body body = (Body)this.buildXMLObject(Body.DEFAULT_ELEMENT_NAME);
        envelope.setBody(body);
        return envelope;
    }

    public class TestPayloadBodyHandler
    extends AbstractMessageHandler<XMLObject> {
        protected void doInvoke(MessageContext msgContext) throws MessageHandlerException {
            Envelope env = ((SOAP11Context)msgContext.getSubcontext(SOAP11Context.class)).getEnvelope();
            msgContext.setMessage(env.getBody().getUnknownXMLObjects().get(0));
        }
    }

    public class TestEnvelopeBodyHandler
    extends AbstractMessageHandler<XMLObject> {
        protected void doInvoke(MessageContext msgContext) throws MessageHandlerException {
            Envelope env = ((SOAP11Context)msgContext.getSubcontext(SOAP11Context.class)).getEnvelope();
            msgContext.setMessage((Object)env);
        }
    }
}

