/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.protocol.HttpContext;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.httpclient.impl.ThreadLocalClientTLSCredentialHandler;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.TrustedNamesCriterion;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509CredentialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityEnhancedTLSSocketFactory
implements LayeredConnectionSocketFactory {
    private static final ThreadLocalClientTLSCredentialHandler CLIENT_TLS_HANDLER = new ThreadLocalClientTLSCredentialHandler();
    private final Logger log = LoggerFactory.getLogger(SecurityEnhancedTLSSocketFactory.class);
    @Nonnull
    private LayeredConnectionSocketFactory wrappedFactory;
    @Nullable
    private X509HostnameVerifier hostnameVerifier;
    private boolean engineRequired = true;

    public SecurityEnhancedTLSSocketFactory(@Nonnull LayeredConnectionSocketFactory factory, boolean trustEngineRequired) {
        this(factory, null, trustEngineRequired);
    }

    public SecurityEnhancedTLSSocketFactory(@Nonnull LayeredConnectionSocketFactory factory) {
        this(factory, null, true);
    }

    public SecurityEnhancedTLSSocketFactory(@Nonnull LayeredConnectionSocketFactory factory, @Nullable X509HostnameVerifier verifier) {
        this(factory, verifier, true);
    }

    public SecurityEnhancedTLSSocketFactory(@Nonnull LayeredConnectionSocketFactory factory, @Nullable X509HostnameVerifier verifier, boolean trustEngineRequired) {
        this.wrappedFactory = (LayeredConnectionSocketFactory)Constraint.isNotNull((Object)factory, (String)"Socket factory was null");
        this.hostnameVerifier = verifier;
        this.engineRequired = trustEngineRequired;
    }

    public boolean isTrustEngineRequired() {
        return this.engineRequired;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        this.log.trace("In createSocket");
        return this.wrappedFactory.createSocket(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        this.log.trace("In connectSocket");
        try {
            this.setup(context);
            Socket socket = this.wrappedFactory.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
            this.performTrustEval(socket, host.getHostName(), context);
            this.performHostnameVerification(socket, host.getHostName(), context);
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            this.teardown(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        this.log.trace("In createLayeredSocket");
        try {
            this.setup(context);
            Socket layeredSocket = this.wrappedFactory.createLayeredSocket(socket, target, port, context);
            this.performTrustEval(layeredSocket, target, context);
            this.performHostnameVerification(layeredSocket, target, context);
            Socket socket2 = layeredSocket;
            return socket2;
        }
        finally {
            this.teardown(context);
        }
    }

    protected void performTrustEval(@Nonnull Socket socket, @Nonnull @NotEmpty String hostname, @Nonnull HttpContext context) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            this.log.debug("Socket was not an instance of SSLSocket, skipping trust eval");
            return;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        this.log.debug("Attempting to evaluate server TLS credential against supplied TrustEngine and CriteriaSet");
        TrustEngine trustEngine = (TrustEngine)context.getAttribute("opensaml.TrustEngine");
        if (trustEngine == null) {
            if (this.isTrustEngineRequired()) {
                this.log.warn("The required trust engine was not supplied by the caller, failing socket TLS creation");
                throw new SSLPeerUnverifiedException("The required trust engine was not supplied by the caller");
            }
            this.log.debug("No trust engine supplied by caller, skipping trust eval");
            return;
        }
        this.log.trace("Saw trust engine of type: {}", (Object)trustEngine.getClass().getName());
        CriteriaSet criteriaSet = (CriteriaSet)context.getAttribute("opensaml.CriteriaSet");
        if (criteriaSet == null) {
            this.log.debug("No criteria set supplied by caller, building new criteria set with signing and trusted names criteria");
            criteriaSet = new CriteriaSet(new Criterion[]{new UsageCriterion(UsageType.SIGNING)});
            criteriaSet.add((Object)new TrustedNamesCriterion(Collections.singleton(hostname)));
        } else {
            this.log.trace("Saw CriteriaSet: {}", (Object)criteriaSet);
        }
        X509Credential credential = this.extractCredential(sslSocket);
        try {
            if (trustEngine.validate((Object)credential, criteriaSet)) {
                this.log.debug("Credential evaluated as trusted");
                context.setAttribute("opensaml.ServerTLSCredentialTrusted", (Object)Boolean.TRUE);
            } else {
                context.setAttribute("opensaml.ServerTLSCredentialTrusted", (Object)Boolean.FALSE);
                Boolean fatal = (Boolean)context.getAttribute("opensaml.ServerTLSFailureIsFatal");
                if (fatal == null || fatal.booleanValue()) {
                    this.log.debug("Credential evaluated as untrusted, failure indicated as fatal");
                    throw new SSLPeerUnverifiedException("Trust engine could not establish trust of server TLS credential");
                }
                this.log.debug("Credential evaluated as untrusted, failure indicated as non-fatal");
            }
        }
        catch (SecurityException e) {
            this.log.error("Trust engine error evaluating credential: {}", (Object)e.getMessage());
            throw new IOException("Trust engine error evaluating credential", e);
        }
    }

    @Nonnull
    protected X509Credential extractCredential(@Nonnull SSLSocket sslSocket) throws IOException {
        SSLSession session = sslSocket.getSession();
        Certificate[] peerCertificates = session.getPeerCertificates();
        if (peerCertificates == null || peerCertificates.length < 1) {
            throw new SSLPeerUnverifiedException("SSLSession peer certificates array was null or empty");
        }
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        for (Certificate cert : peerCertificates) {
            certChain.add((X509Certificate)cert);
        }
        X509Certificate entityCert = (X509Certificate)certChain.get(0);
        BasicX509Credential credential = new BasicX509Credential(entityCert);
        credential.setEntityCertificateChain(certChain);
        return credential;
    }

    protected void performHostnameVerification(Socket socket, String hostname, HttpContext context) throws IOException {
        if (this.hostnameVerifier != null && socket instanceof SSLSocket) {
            this.hostnameVerifier.verify(hostname, (SSLSocket)socket);
        }
    }

    protected void setup(@Nullable HttpContext context) {
        this.log.trace("Attempting to setup thread-local client TLS X509Credential");
        if (context == null) {
            this.log.trace("HttpContext was null, skipping thread-local setup");
            return;
        }
        X509Credential credential = (X509Credential)context.getAttribute("opensaml.ClientTLSCredential");
        if (credential != null) {
            this.log.trace("Loading ThreadLocalX509CredentialContext with client TLS credential: {}", (Object)credential);
            if (ThreadLocalX509CredentialContext.haveCurrent()) {
                this.log.trace("ThreadLocalX509CredentialContext was already loaded with client TLS credential, will be overwritten with credential from HttpContext");
            }
            ThreadLocalX509CredentialContext.loadCurrent(credential);
        } else {
            this.log.trace("HttpContext did not contain a client TLS credential, nothing to do");
        }
    }

    protected void teardown(@Nullable HttpContext context) {
        if (ThreadLocalX509CredentialContext.haveCurrent()) {
            this.log.trace("Scheduling deferred clearing of thread-local client TLS X509Credential");
            HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)HttpClientContext.adapt((HttpContext)context), (HttpClientContextHandler)CLIENT_TLS_HANDLER);
        }
    }
}

