/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.messaging.impl;

import com.google.common.base.Strings;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.messaging.ClientTLSSecurityParametersContext;
import org.opensaml.security.messaging.ServletRequestX509CredentialAdapter;
import org.opensaml.security.messaging.impl.BaseTrustEngineSecurityHandler;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.tls.CertificateNameOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClientCertAuthSecurityHandler<MessageType>
extends BaseTrustEngineSecurityHandler<X509Credential, MessageType> {
    private final Logger log = LoggerFactory.getLogger(BaseClientCertAuthSecurityHandler.class);
    private CertificateNameOptions certNameOptions;
    private HttpServletRequest httpServletRequest;

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletRequest = (HttpServletRequest)Constraint.isNotNull((Object)request, (String)"HttpServletRequest may not be null");
    }

    @Nullable
    protected CertificateNameOptions getCertificateNameOptions() {
        return this.certNameOptions;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull((Object)this.httpServletRequest, (String)"HttpServletRequest must be supplied");
    }

    @Override
    @Nullable
    protected TrustEngine<X509Credential> resolveTrustEngine(MessageContext<MessageType> messageContext) {
        ClientTLSSecurityParametersContext secContext = (ClientTLSSecurityParametersContext)messageContext.getSubcontext(ClientTLSSecurityParametersContext.class);
        if (secContext == null || secContext.getValidationParameters() == null) {
            return null;
        }
        return secContext.getValidationParameters().getX509TrustEngine();
    }

    @Override
    protected boolean doPreInvoke(MessageContext<MessageType> messageContext) throws MessageHandlerException {
        ClientTLSSecurityParametersContext secContext = (ClientTLSSecurityParametersContext)messageContext.getSubcontext(ClientTLSSecurityParametersContext.class);
        if (secContext != null && !secContext.isEvaluateClientCertificate()) {
            this.log.debug("ClientTLSSecurityParametersContext signals to not perform client TLS cert evaluation");
            return false;
        }
        if (secContext == null || secContext.getValidationParameters() == null || secContext.getValidationParameters().getCertificateNameOptions() == null) {
            throw new MessageHandlerException("CertificateNameOptions was not available from the MessageContext");
        }
        this.certNameOptions = secContext.getValidationParameters().getCertificateNameOptions();
        return super.doPreInvoke(messageContext);
    }

    protected void doInvoke(MessageContext<MessageType> messageContext) throws MessageHandlerException {
        ServletRequestX509CredentialAdapter requestCredential = null;
        try {
            requestCredential = new ServletRequestX509CredentialAdapter((ServletRequest)this.getHttpServletRequest());
        }
        catch (SecurityException e) {
            this.log.info("HttpServletRequest did not contain a peer credential, skipping client certificate authentication");
            return;
        }
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug("Attempting to authenticate inbound connection that presented the certificate:");
                this.log.debug(Base64Support.encode((byte[])requestCredential.getEntityCertificate().getEncoded(), (boolean)false));
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        this.doEvaluate((X509Credential)requestCredential, messageContext);
    }

    protected void doEvaluate(X509Credential requestCredential, MessageContext<MessageType> messageContext) throws MessageHandlerException {
        String presenterEntityID = this.getCertificatePresenterEntityID(messageContext);
        if (presenterEntityID != null) {
            this.log.debug("Attempting client certificate authentication using context presenter entity ID: {}", (Object)presenterEntityID);
            if (!this.evaluate(requestCredential, presenterEntityID, messageContext)) {
                this.log.error("Authentication via client certificate failed for context presenter entity ID: {}", (Object)presenterEntityID);
                throw new MessageHandlerException("Client certificate authentication failed for context presenter entity ID");
            }
            this.log.info("Authentication via client certificate succeeded for context presenter entity ID: {}", (Object)presenterEntityID);
            this.setAuthenticatedState(messageContext, true);
            return;
        }
        String derivedPresenter = this.evaluateCertificateNameDerivedPresenters(requestCredential, messageContext);
        if (derivedPresenter != null) {
            this.log.info("Authentication via client certificate succeeded for certificate-derived presenter entity ID: {}", (Object)derivedPresenter);
            this.setAuthenticatedCertificatePresenterEntityID(messageContext, derivedPresenter);
            this.setAuthenticatedState(messageContext, true);
            return;
        }
        derivedPresenter = this.evaluateDerivedPresenters(requestCredential, messageContext);
        if (derivedPresenter != null) {
            this.log.info("Authentication via client certificate succeeded for derived presenter entity ID: {}", (Object)derivedPresenter);
            this.setAuthenticatedCertificatePresenterEntityID(messageContext, derivedPresenter);
            this.setAuthenticatedState(messageContext, true);
            return;
        }
    }

    protected abstract String getCertificatePresenterEntityID(MessageContext<MessageType> var1);

    protected abstract void setAuthenticatedCertificatePresenterEntityID(MessageContext<MessageType> var1, String var2);

    protected abstract void setAuthenticatedState(MessageContext<MessageType> var1, boolean var2);

    @Override
    protected CriteriaSet buildCriteriaSet(String entityID, MessageContext<MessageType> messageContext) throws MessageHandlerException {
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!Strings.isNullOrEmpty((String)entityID)) {
            criteriaSet.add((Object)new EntityIdCriterion(entityID));
        }
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        return criteriaSet;
    }

    protected String evaluateDerivedPresenters(X509Credential requestCredential, MessageContext<MessageType> messageContext) throws MessageHandlerException {
        return null;
    }

    protected String evaluateCertificateNameDerivedPresenters(X509Credential requestCredential, MessageContext<MessageType> messageContext) throws MessageHandlerException {
        String candidatePresenter = null;
        if (this.getCertificateNameOptions().evaluateSubjectDN() && (candidatePresenter = this.evaluateSubjectDN(requestCredential, messageContext)) != null) {
            return candidatePresenter;
        }
        if (!this.getCertificateNameOptions().getSubjectAltNames().isEmpty() && (candidatePresenter = this.evaluateSubjectAltNames(requestCredential, messageContext)) != null) {
            return candidatePresenter;
        }
        if (this.getCertificateNameOptions().evaluateSubjectCommonName() && (candidatePresenter = this.evaluateSubjectCommonName(requestCredential, messageContext)) != null) {
            return candidatePresenter;
        }
        return null;
    }

    protected String evaluateSubjectCommonName(X509Credential requestCredential, MessageContext<MessageType> messageContext) throws MessageHandlerException {
        this.log.debug("Evaluating client cert by deriving presenter as cert CN");
        X509Certificate certificate = requestCredential.getEntityCertificate();
        String candidatePresenter = this.getCommonName(certificate);
        if (candidatePresenter != null) {
            if (this.evaluate(requestCredential, candidatePresenter, messageContext)) {
                this.log.info("Authentication succeeded for presenter entity ID derived from CN: {}", (Object)candidatePresenter);
                return candidatePresenter;
            }
            this.log.info("Authentication failed for presenter entity ID derived from CN: {}", (Object)candidatePresenter);
        }
        return null;
    }

    protected String evaluateSubjectDN(X509Credential requestCredential, MessageContext<MessageType> messageContext) throws MessageHandlerException {
        this.log.debug("Evaluating client cert by deriving presenter as cert subject DN");
        X509Certificate certificate = requestCredential.getEntityCertificate();
        String candidatePresenter = this.getSubjectName(certificate);
        if (candidatePresenter != null) {
            if (this.evaluate(requestCredential, candidatePresenter, messageContext)) {
                this.log.info("Authentication succeeded for presenter entity ID derived from subject DN: {}", (Object)candidatePresenter);
                return candidatePresenter;
            }
            this.log.info("Authentication failed for presenter entity ID derived from subject DN: {}", (Object)candidatePresenter);
        }
        return null;
    }

    protected String evaluateSubjectAltNames(X509Credential requestCredential, MessageContext<MessageType> messageContext) throws MessageHandlerException {
        this.log.debug("Evaluating client cert by deriving presenter from subject alt names");
        X509Certificate certificate = requestCredential.getEntityCertificate();
        for (Integer altNameType : this.getCertificateNameOptions().getSubjectAltNames()) {
            this.log.debug("Evaluating alt names of type: {}", (Object)altNameType.toString());
            List<String> altNames = this.getAltNames(certificate, altNameType);
            for (String altName : altNames) {
                if (this.evaluate(requestCredential, altName, messageContext)) {
                    this.log.info("Authentication succeeded for presenter entity ID derived from subject alt name: {}", (Object)altName);
                    return altName;
                }
                this.log.info("Authentication failed for presenter entity ID derived from subject alt name: {}", (Object)altName);
            }
        }
        return null;
    }

    protected String getCommonName(X509Certificate cert) {
        List names = X509Support.getCommonNames((X500Principal)cert.getSubjectX500Principal());
        if (names != null && !names.isEmpty()) {
            String name = (String)names.get(0);
            this.log.debug("Extracted common name from certificate: {}", (Object)name);
            return name;
        }
        return null;
    }

    protected String getSubjectName(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        String name = null;
        name = !Strings.isNullOrEmpty((String)this.getCertificateNameOptions().getX500SubjectDNFormat()) ? this.getCertificateNameOptions().getX500DNHandler().getName(cert.getSubjectX500Principal(), this.getCertificateNameOptions().getX500SubjectDNFormat()) : this.getCertificateNameOptions().getX500DNHandler().getName(cert.getSubjectX500Principal());
        this.log.debug("Extracted subject name from certificate: {}", (Object)name);
        return name;
    }

    protected List<String> getAltNames(X509Certificate cert, Integer altNameType) {
        this.log.debug("Extracting alt names from certificate of type: {}", (Object)altNameType.toString());
        Integer[] nameTypes = new Integer[]{altNameType};
        List altNames = X509Support.getAltNames((X509Certificate)cert, (Integer[])nameTypes);
        ArrayList<String> names = new ArrayList<String>();
        for (Object altNameValue : altNames) {
            if (!(altNameValue instanceof String)) {
                this.log.debug("Skipping non-String certificate alt name value");
                continue;
            }
            names.add((String)altNameValue);
        }
        this.log.debug("Extracted alt names from certificate: {}", (Object)((Object)names).toString());
        return names;
    }
}

