/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.messaging.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTrustEngineSecurityHandler<TokenType, MessageType>
extends AbstractMessageHandler<MessageType> {
    private final Logger log = LoggerFactory.getLogger(BaseTrustEngineSecurityHandler.class);
    private TrustEngine<TokenType> trustEngine;

    public TrustEngine<TokenType> getTrustEngine() {
        return this.trustEngine;
    }

    public void setTrustEngine(TrustEngine<TokenType> engine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.trustEngine = (TrustEngine)Constraint.isNotNull(engine, (String)"TrustEngine may not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull(this.trustEngine, (String)"TrustEngine was not supplied");
    }

    protected abstract CriteriaSet buildCriteriaSet(String var1, MessageContext<MessageType> var2) throws MessageHandlerException;

    protected boolean evaluate(TokenType token, String entityID, MessageContext<MessageType> messageContext) throws MessageHandlerException {
        CriteriaSet criteriaSet = this.buildCriteriaSet(entityID, messageContext);
        if (criteriaSet == null) {
            this.log.error("Returned criteria set was null, can not perform trust engine evaluation of token");
            throw new MessageHandlerException("Returned criteria set was null");
        }
        return this.evaluate(token, criteriaSet);
    }

    protected boolean evaluate(TokenType token, CriteriaSet criteriaSet) throws MessageHandlerException {
        try {
            return this.getTrustEngine().validate(token, criteriaSet);
        }
        catch (SecurityException e) {
            this.log.error("There was an error evaluating the request's token using the trust engine", (Throwable)e);
            throw new MessageHandlerException("Error during trust engine evaluation of the token", (Exception)((Object)e));
        }
    }
}

