/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.slf4j.Logger;

public class AlgorithmFilter
extends AbstractMetadataFilter {
    @Nonnull
    @NotEmpty
    private static final String GUARD_VALUE = "_EMPTY";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AlgorithmFilter.class);
    @Nullable
    private AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
    private boolean removeExistingDigestMethods;
    private boolean removeExistingSigningMethods;
    private boolean removeExistingEncryptionMethods;
    @Nonnull
    private Multimap<Predicate<EntityDescriptor>, XMLObject> applyMap;
    @Nonnull
    private final SAMLObjectBuilder<Extensions> extBuilder;
    @Nonnull
    private final XSString guardObject = (XSString)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(XSString.TYPE_NAME).buildObject(null, "_EMPTY", null);

    public AlgorithmFilter() {
        this.guardObject.setValue(GUARD_VALUE);
        this.extBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Extensions.DEFAULT_ELEMENT_NAME);
        this.applyMap = ArrayListMultimap.create();
    }

    public void setRemoveExistingDigestMethods(boolean flag) {
        this.checkSetterPreconditions();
        this.removeExistingDigestMethods = flag;
    }

    public void setRemoveExistingSigningMethods(boolean flag) {
        this.checkSetterPreconditions();
        this.removeExistingSigningMethods = flag;
    }

    public void setRemoveExistingEncryptionMethods(boolean flag) {
        this.checkSetterPreconditions();
        this.removeExistingEncryptionMethods = flag;
    }

    public void setRules(@Nonnull Map<Predicate<EntityDescriptor>, Collection<XMLObject>> rules) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(rules, (String)"Rules map cannot be null");
        rules.values().stream().flatMap(Collection::stream).filter(DigestMethod.class::isInstance).map(DigestMethod.class::cast).map(DigestMethod::getAlgorithm).distinct().forEach(this::checkDigestMethod);
        rules.values().stream().flatMap(Collection::stream).filter(SigningMethod.class::isInstance).map(SigningMethod.class::cast).map(SigningMethod::getAlgorithm).distinct().forEach(this::checkSigningMethod);
        rules.values().stream().flatMap(Collection::stream).filter(EncryptionMethod.class::isInstance).map(EncryptionMethod.class::cast).map(org.opensaml.xmlsec.encryption.EncryptionMethod::getAlgorithm).distinct().forEach(this::checkEncryptionMethod);
        this.applyMap = ArrayListMultimap.create((int)rules.size(), (int)1);
        for (Map.Entry<Predicate<EntityDescriptor>, Collection<XMLObject>> entry : rules.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.applyMap.putAll(entry.getKey(), (Iterable)(entry.getValue().isEmpty() ? CollectionSupport.singletonList((Object)this.guardObject) : CollectionSupport.copyToList(entry.getValue())));
        }
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        this.checkComponentActive();
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
        return metadata;
    }

    protected void filterEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        Set existingDigests = CollectionSupport.emptySet();
        Set existingSignings = CollectionSupport.emptySet();
        Extensions exts = descriptor.getExtensions();
        if (exts != null) {
            if (!this.removeExistingDigestMethods) {
                existingDigests = exts.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME).stream().filter(DigestMethod.class::isInstance).map(DigestMethod.class::cast).map(DigestMethod::getAlgorithm).distinct().collect(Collectors.toUnmodifiableSet());
            }
            if (!this.removeExistingSigningMethods) {
                existingSignings = exts.getUnknownXMLObjects(SigningMethod.DEFAULT_ELEMENT_NAME).stream().filter(SigningMethod.class::isInstance).map(SigningMethod.class::cast).map(SigningMethod::getAlgorithm).distinct().collect(Collectors.toUnmodifiableSet());
            }
        }
        for (Map.Entry entry : this.applyMap.asMap().entrySet()) {
            XMLObject xmlObject;
            if (!((Predicate)entry.getKey()).test(descriptor)) continue;
            this.removeExistingMethods(descriptor);
            Iterator iterator = ((Collection)entry.getValue()).iterator();
            while (iterator.hasNext() && !((xmlObject = (XMLObject)iterator.next()) instanceof XSString)) {
                try {
                    if (xmlObject instanceof DigestMethod) {
                        if (existingDigests.contains(((DigestMethod)xmlObject).getAlgorithm())) {
                            this.log.debug("Skipping pre-existing DigestMethod ({}) on EntityDescriptor ({})", (Object)((DigestMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                            continue;
                        }
                        this.log.info("Adding DigestMethod ({}) to EntityDescriptor ({})", (Object)((DigestMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                        this.getExtensions(descriptor).getUnknownXMLObjects().add(XMLObjectSupport.cloneXMLObject((XMLObject)xmlObject));
                        continue;
                    }
                    if (xmlObject instanceof SigningMethod) {
                        if (existingSignings.contains(((SigningMethod)xmlObject).getAlgorithm())) {
                            this.log.debug("Skipping pre-existing SigningMethod ({}) on EntityDescriptor ({})", (Object)((SigningMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                            continue;
                        }
                        this.log.info("Adding SigningMethod ({}) to EntityDescriptor ({})", (Object)((SigningMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                        this.getExtensions(descriptor).getUnknownXMLObjects().add(XMLObjectSupport.cloneXMLObject((XMLObject)xmlObject));
                        continue;
                    }
                    if (!(xmlObject instanceof EncryptionMethod)) continue;
                    this.addEncryptionMethod(descriptor, (EncryptionMethod)xmlObject);
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error cloning XMLObject", e);
                }
            }
        }
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) {
        for (EntitiesDescriptor group : descriptor.getEntitiesDescriptors()) {
            assert (group != null);
            this.filterEntitiesDescriptor(group);
        }
        for (EntityDescriptor entity : descriptor.getEntityDescriptors()) {
            assert (entity != null);
            this.filterEntityDescriptor(entity);
        }
    }

    @Nonnull
    protected Extensions getExtensions(@Nonnull EntityDescriptor descriptor) {
        Extensions extensions = descriptor.getExtensions();
        if (extensions == null) {
            extensions = (Extensions)this.extBuilder.buildObject();
            descriptor.setExtensions(extensions);
        }
        return extensions;
    }

    protected void removeExistingMethods(@Nonnull EntityDescriptor descriptor) {
        Extensions exts = descriptor.getExtensions();
        if (exts != null) {
            if (this.removeExistingDigestMethods) {
                this.log.debug("Clearing existing entity-level DigestMethod extensions on EntityDescriptor '{}'", (Object)descriptor.getEntityID());
                exts.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME).clear();
            }
            if (this.removeExistingSigningMethods) {
                this.log.debug("Clearing existing entity-level SigningMethod extensions on EntityDescriptor '{}'", (Object)descriptor.getEntityID());
                exts.getUnknownXMLObjects(SigningMethod.DEFAULT_ELEMENT_NAME).clear();
            }
        }
        if (this.removeExistingDigestMethods || this.removeExistingSigningMethods || this.removeExistingEncryptionMethods) {
            for (RoleDescriptor role : descriptor.getRoleDescriptors()) {
                exts = role.getExtensions();
                if (exts != null) {
                    if (this.removeExistingDigestMethods) {
                        this.log.debug("Clearing existing role-level DigestMethod extensions on EntityDescriptor '{}'", (Object)descriptor.getEntityID());
                        exts.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME).clear();
                    }
                    if (this.removeExistingSigningMethods) {
                        this.log.debug("Clearing existing role-level SigningMethod extensions on EntityDescriptor '{}'", (Object)descriptor.getEntityID());
                        exts.getUnknownXMLObjects(SigningMethod.DEFAULT_ELEMENT_NAME).clear();
                    }
                }
                if (!this.removeExistingEncryptionMethods) continue;
                for (KeyDescriptor key : role.getKeyDescriptors()) {
                    if (key.getUse() != null && key.getUse() == UsageType.SIGNING) continue;
                    this.log.debug("Clearing existing key-level EncryptionMethod extensions on EntityDescriptor '{}'", (Object)descriptor.getEntityID());
                    key.getEncryptionMethods().clear();
                }
            }
        }
    }

    protected void addEncryptionMethod(@Nonnull EntityDescriptor descriptor, @Nonnull EncryptionMethod encryptionMethod) {
        for (RoleDescriptor role : descriptor.getRoleDescriptors()) {
            for (KeyDescriptor key : role.getKeyDescriptors()) {
                if (key.getUse() != null && key.getUse() == UsageType.SIGNING) continue;
                List existingMethods = key.getEncryptionMethods();
                for (EncryptionMethod method : existingMethods) {
                    if (!Objects.equals(method.getAlgorithm(), encryptionMethod.getAlgorithm())) continue;
                    this.log.debug("Skipping pre-existing EncryptionMethod ({}) on EntityDescriptor ({})", (Object)encryptionMethod.getAlgorithm(), (Object)descriptor.getEntityID());
                    return;
                }
                try {
                    this.log.info("Adding EncryptionMethod ({}) to EntityDescriptor ({})", (Object)encryptionMethod.getAlgorithm(), (Object)descriptor.getEntityID());
                    existingMethods.add((EncryptionMethod)XMLObjectSupport.cloneXMLObject((XMLObject)encryptionMethod));
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error cloning EncryptionMethod", e);
                }
            }
        }
    }

    private void checkDigestMethod(@Nullable @NotEmpty String uri) {
        if (uri == null) {
            return;
        }
        AlgorithmRegistry local = this.registry;
        if (local != null) {
            if (!local.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).contains(uri)) {
                this.log.warn("DigestMethod {} unrecognized by algorithm registry", (Object)uri);
            } else if (!local.isRuntimeSupported(uri)) {
                this.log.warn("DigestMethod {} unsupported by runtime", (Object)uri);
            }
        }
    }

    private void checkSigningMethod(@Nullable @NotEmpty String uri) {
        if (uri == null) {
            return;
        }
        AlgorithmRegistry local = this.registry;
        if (local != null) {
            if (!local.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.Signature).contains(uri) && !local.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.Mac).contains(uri)) {
                this.log.warn("SigningMethod {} unrecognized by algorithm registry", (Object)uri);
            } else if (!local.isRuntimeSupported(uri)) {
                this.log.warn("SigningMethod {} unsupported by runtime", (Object)uri);
            }
        }
    }

    private void checkEncryptionMethod(@Nullable @NotEmpty String uri) {
        if (uri == null) {
            return;
        }
        AlgorithmRegistry local = this.registry;
        if (local != null) {
            if (!(local.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.BlockEncryption).contains(uri) || local.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.KeyTransport).contains(uri) || local.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.KeyAgreement).contains(uri) || local.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.SymmetricKeyWrap).contains(uri))) {
                this.log.warn("EncryptionMethod {} unrecognized by algorithm registry", (Object)uri);
            } else if (!local.isRuntimeSupported(uri)) {
                this.log.warn("EncryptionMethod {} unsupported by runtime", (Object)uri);
            }
        }
    }
}

