/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.messaging.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.MessageContextLookup;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.common.messaging.context.navigate.SAMLEntityIDFunction;
import org.opensaml.saml.common.messaging.context.navigate.SAMLMessageInfoContextIDFunction;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.assertion.messaging.AssertionValidationInput;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;
import org.slf4j.Logger;

public class DefaultAssertionValidationContextBuilder
implements Function<AssertionValidationInput, ValidationContext> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultAssertionValidationContextBuilder.class);
    @Nullable
    private Function<InOutOperationContext, Duration> clockSkew;
    @Nullable
    private Function<InOutOperationContext, Duration> lifetime;
    @Nullable
    private Function<Pair<InOutOperationContext, Assertion>, CriteriaSet> signatureCriteriaSetFunction;
    @Nonnull
    private Predicate<InOutOperationContext> signatureRequired = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<InOutOperationContext> checkAddress;
    @Nullable
    private Function<InOutOperationContext, Duration> maximumTimeSinceAuthn;
    @Nonnull
    private Predicate<InOutOperationContext> includeSelfEntityIDAsRecipient = PredicateSupport.alwaysFalse();
    @Nullable
    private Function<InOutOperationContext, Set<String>> additionalAudiences;
    @Nonnull
    private Function<InOutOperationContext, Set<String>> validIssuers;
    @Nonnull
    private Function<InOutOperationContext, String> selfEntityID;
    @Nonnull
    private Predicate<InOutOperationContext> requireEntityIssuer;
    @Nullable
    private Function<InOutOperationContext, String> inResponseTo;
    @Nonnull
    private Predicate<InOutOperationContext> inResponseToIgnored;
    @Nonnull
    private Predicate<InOutOperationContext> inResponseToRequired;
    @Nonnull
    private Predicate<InOutOperationContext> recipientRequired;
    @Nonnull
    private Predicate<InOutOperationContext> notBeforeRequired;
    @Nonnull
    private Predicate<InOutOperationContext> notOnOrAfterRequired;
    @Nonnull
    private Predicate<InOutOperationContext> addressRequired;
    @Nonnull
    private Set<QName> requiredConditions;
    private Function<InOutOperationContext, SecurityParametersContext> securityParametersLookupStrategy;

    public DefaultAssertionValidationContextBuilder() {
        this.checkAddress = PredicateSupport.alwaysTrue();
        this.inResponseTo = new DefaultValidInResponseToLookupFunction();
        this.inResponseToIgnored = PredicateSupport.alwaysFalse();
        this.inResponseToRequired = PredicateSupport.alwaysFalse();
        this.recipientRequired = PredicateSupport.alwaysFalse();
        this.notOnOrAfterRequired = PredicateSupport.alwaysFalse();
        this.notBeforeRequired = PredicateSupport.alwaysFalse();
        this.addressRequired = PredicateSupport.alwaysFalse();
        this.requiredConditions = CollectionSupport.emptySet();
        this.validIssuers = new DefaultValidIssuersLookupFunction();
        this.selfEntityID = new DefaultSelfEntityIDLookupFunction();
        this.requireEntityIssuer = PredicateSupport.alwaysFalse();
        this.securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class).compose((Function)new ContextDataLookupFunction<InOutOperationContext, MessageContext>(){

            public MessageContext apply(@Nullable InOutOperationContext t) {
                return t != null ? t.getInboundMessageContext() : null;
            }
        });
    }

    @Nullable
    public Function<InOutOperationContext, Duration> getClockSkew() {
        return this.clockSkew;
    }

    public void setClockSkew(@Nullable Duration skew) {
        this.clockSkew = FunctionSupport.constant((Object)skew);
    }

    public void setClockSkewLookupStrategy(@Nullable Function<InOutOperationContext, Duration> strategy) {
        this.clockSkew = strategy;
    }

    @Nullable
    public Function<InOutOperationContext, Duration> getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(@Nullable Duration duration) {
        this.lifetime = FunctionSupport.constant((Object)duration);
    }

    public void setLifetimeLookupStrategy(@Nullable Function<InOutOperationContext, Duration> strategy) {
        this.lifetime = strategy;
    }

    @Nonnull
    public Function<InOutOperationContext, SecurityParametersContext> getSecurityParametersLookupStrategy() {
        return this.securityParametersLookupStrategy;
    }

    public void setSecurityParametersLookupStrategy(@Nonnull Function<InOutOperationContext, SecurityParametersContext> strategy) {
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy was null");
    }

    @Nonnull
    public Set<QName> getRequiredConditions() {
        return this.requiredConditions;
    }

    public void setRequiredConditions(@Nullable Set<QName> conditions) {
        this.requiredConditions = conditions != null ? (Set)((NonnullSupplier)conditions.stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get() : CollectionSupport.emptySet();
    }

    @Nonnull
    public Predicate<InOutOperationContext> getIncludeSelfEntityIDAsRecipient() {
        return this.includeSelfEntityIDAsRecipient;
    }

    public void setIncludeSelfEntityIDAsRecipient(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.includeSelfEntityIDAsRecipient = (Predicate)Constraint.isNotNull(predicate, (String)"Signature required predicate was null");
    }

    @Nonnull
    public Predicate<InOutOperationContext> getSignatureRequired() {
        return this.signatureRequired;
    }

    public void setSignatureRequired(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.signatureRequired = (Predicate)Constraint.isNotNull(predicate, (String)"Signature required predicate was null");
    }

    public void setInResponseTo(@Nullable Function<InOutOperationContext, String> function) {
        this.inResponseTo = function;
    }

    @Nullable
    public Function<InOutOperationContext, String> getInResponseTo() {
        return this.inResponseTo;
    }

    @Nonnull
    public Predicate<InOutOperationContext> getInResponseToRequired() {
        return this.inResponseToRequired;
    }

    public void setInResponseToRequired(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.inResponseToRequired = (Predicate)Constraint.isNotNull(predicate, (String)"InResponseTo required predicate was null");
    }

    @Nonnull
    public Predicate<InOutOperationContext> getInResponseToIgnored() {
        return this.inResponseToIgnored;
    }

    public void setInResponseToIgnored(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.inResponseToIgnored = (Predicate)Constraint.isNotNull(predicate, (String)"InResponseTo ignored predicate was null");
    }

    @Nonnull
    public Predicate<InOutOperationContext> getRecipientRequired() {
        return this.recipientRequired;
    }

    public void setRecipientRequired(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.recipientRequired = (Predicate)Constraint.isNotNull(predicate, (String)"Recipient required predicate was null");
    }

    @Nonnull
    public Predicate<InOutOperationContext> getNotBeforeRequired() {
        return this.notBeforeRequired;
    }

    public void setNotBeforeRequired(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.notBeforeRequired = (Predicate)Constraint.isNotNull(predicate, (String)"NotBefore required predicate was null");
    }

    @Nonnull
    public Predicate<InOutOperationContext> getNotOnOrAfterRequired() {
        return this.notOnOrAfterRequired;
    }

    public void setNotOnOrAfterRequired(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.notOnOrAfterRequired = (Predicate)Constraint.isNotNull(predicate, (String)"NotOnOrAfter required predicate was null");
    }

    @Nonnull
    public Predicate<InOutOperationContext> getAddressRequired() {
        return this.addressRequired;
    }

    public void setAddressRequired(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.addressRequired = (Predicate)Constraint.isNotNull(predicate, (String)"Address required predicate was null");
    }

    @Nonnull
    public Predicate<InOutOperationContext> getCheckAddress() {
        return this.checkAddress;
    }

    public void setCheckAddress(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.checkAddress = (Predicate)Constraint.isNotNull(predicate, (String)"Check address predicate was null");
    }

    @Nullable
    public Function<InOutOperationContext, Set<String>> getAdditionalAudiences() {
        return this.additionalAudiences;
    }

    public void setAdditionalAudiences(@Nullable Function<InOutOperationContext, Set<String>> function) {
        this.additionalAudiences = function;
    }

    @Nonnull
    public Function<InOutOperationContext, String> getSelfEntityID() {
        return this.selfEntityID;
    }

    public void setSelfEntityID(@Nonnull Function<InOutOperationContext, String> function) {
        this.selfEntityID = (Function)Constraint.isNotNull(function, (String)"Self entity ID function was null");
    }

    @Nonnull
    public Function<InOutOperationContext, Set<String>> getValidIssuers() {
        return this.validIssuers;
    }

    public void setValidIssuers(@Nonnull Function<InOutOperationContext, Set<String>> function) {
        this.validIssuers = (Function)Constraint.isNotNull(function, (String)"Valied Issuers function was null");
    }

    @Nonnull
    public Predicate<InOutOperationContext> getRequireEntityIssuer() {
        return this.requireEntityIssuer;
    }

    public void setRequireEntityIssuer(@Nonnull Predicate<InOutOperationContext> predicate) {
        this.requireEntityIssuer = (Predicate)Constraint.isNotNull(predicate, (String)"Entity issuer predicate was null");
    }

    @Nullable
    public Function<InOutOperationContext, Duration> getMaximumTimeSinceAuthn() {
        return this.maximumTimeSinceAuthn;
    }

    public void setMaximumTimeSinceAuthn(@Nullable Function<InOutOperationContext, Duration> function) {
        this.maximumTimeSinceAuthn = function;
    }

    @Nullable
    public Function<Pair<InOutOperationContext, Assertion>, CriteriaSet> getSignatureCriteriaSetFunction() {
        return this.signatureCriteriaSetFunction;
    }

    public void setSignatureCriteriaSetFunction(@Nullable Function<Pair<InOutOperationContext, Assertion>, CriteriaSet> function) {
        this.signatureCriteriaSetFunction = function;
    }

    @Override
    @Nullable
    public ValidationContext apply(@Nullable AssertionValidationInput input) {
        if (input == null) {
            return null;
        }
        return new ValidationContext(this.buildStaticParameters(input));
    }

    @Nonnull
    protected Map<String, Object> buildStaticParameters(@Nonnull AssertionValidationInput input) {
        Function<InOutOperationContext, Duration> lifetimeFunc;
        TreeMap<String, Object> staticParams = new TreeMap<String, Object>();
        Function<InOutOperationContext, Duration> skewFunc = this.getClockSkew();
        if (skewFunc != null) {
            staticParams.put("saml2.ClockSkew", skewFunc.apply(input.getOperationContext()));
        }
        if ((lifetimeFunc = this.getLifetime()) != null) {
            staticParams.put("saml2.Lifetime", lifetimeFunc.apply(input.getOperationContext()));
        }
        staticParams.put("saml2.ValidIssuers", this.getValidIssuers().apply(input.getOperationContext()));
        staticParams.put("saml2.RequireEntityIssuer", this.getRequireEntityIssuer().test(input.getOperationContext()));
        this.populateSignatureParameters(staticParams, input);
        this.populateConditionsParameters(staticParams, input);
        Set<InetAddress> validAddresses = this.getValidAddresses(input);
        Boolean checkAddressEnabled = this.getCheckAddress().test(input.getOperationContext());
        assert (checkAddressEnabled != null);
        this.populateSubjectConfirmationParameters(staticParams, input, validAddresses, checkAddressEnabled);
        this.populateStatementParams(staticParams, input, validAddresses, checkAddressEnabled);
        this.log.trace("Built static parameters map: {}", staticParams);
        return staticParams;
    }

    private void populateSignatureParameters(@Nonnull Map<String, Object> staticParams, @Nonnull AssertionValidationInput input) {
        SignatureValidationParameters valParams;
        staticParams.put("saml2.SignatureRequired", this.getSignatureRequired().test(input.getOperationContext()));
        staticParams.put("saml2.SignatureValidationCriteriaSet", this.getSignatureCriteriaSet(input));
        SecurityParametersContext securityParameters = this.getSecurityParametersLookupStrategy().apply(input.getOperationContext());
        SignatureValidationParameters signatureValidationParameters = valParams = securityParameters != null ? securityParameters.getSignatureValidationParameters() : null;
        if (valParams != null) {
            staticParams.put("saml2.SignatureValidationTrustEngine", valParams.getSignatureTrustEngine());
        }
    }

    private void populateConditionsParameters(@Nonnull Map<String, Object> staticParams, @Nonnull AssertionValidationInput input) {
        staticParams.put("saml2.Conditions.RequiredConditions", this.getRequiredConditions(input));
        staticParams.put("saml2.Conditions.ValidAudiences", this.getValidAudiences(input));
    }

    private void populateSubjectConfirmationParameters(@Nonnull Map<String, Object> staticParams, @Nonnull AssertionValidationInput input, @Nonnull Set<InetAddress> validAddresses, @Nonnull Boolean checkAddressEnabled) {
        PublicKey attesterPublicKey;
        X509Certificate attesterCertificate = this.getAttesterCertificate(input);
        if (attesterCertificate != null) {
            staticParams.put("saml2.SubjectConfirmation.HoK.PresenterCertificate", attesterCertificate);
        }
        if ((attesterPublicKey = this.getAttesterPublicKey(input)) != null) {
            staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", attesterPublicKey);
        }
        staticParams.put("saml2.SubjectConfirmation.RecipientRequired", this.getRecipientRequired().test(input.getOperationContext()));
        staticParams.put("saml2.SubjectConfirmation.ValidRecipients", this.getValidRecipients(input));
        staticParams.put("saml2.SubjectConfirmation.AddressRequired", this.getAddressRequired().test(input.getOperationContext()));
        staticParams.put("saml2.SubjectConfirmation.ValidAddresses", validAddresses);
        staticParams.put("saml2.SubjectConfirmation.CheckAddress", checkAddressEnabled);
        staticParams.put("saml2.SubjectConfirmation.InResponseToIgnored", this.getInResponseToIgnored().test(input.getOperationContext()));
        staticParams.put("saml2.SubjectConfirmation.InResponseToRequired", this.getInResponseToRequired().test(input.getOperationContext()));
        Function<InOutOperationContext, String> irtFunc = this.getInResponseTo();
        if (irtFunc != null) {
            staticParams.put("saml2.SubjectConfirmation.ValidInResponseTo", irtFunc.apply(input.getOperationContext()));
        }
        staticParams.put("saml2.SubjectConfirmation.NotBeforeRequired", this.getNotBeforeRequired().test(input.getOperationContext()));
        staticParams.put("saml2.SubjectConfirmation.NoOnOrAfterRequired", this.getNotOnOrAfterRequired().test(input.getOperationContext()));
    }

    private void populateStatementParams(@Nonnull Map<String, Object> staticParams, @Nonnull AssertionValidationInput input, @Nonnull Set<InetAddress> validAddresses, @Nonnull Boolean checkAddressEnabled) {
        staticParams.put("saml2.Statement.Authn.SubjectLocality.ValidAddresses", validAddresses);
        staticParams.put("saml2.Statement.Authn.SubjectLocality.CheckAddress", checkAddressEnabled);
        Function<InOutOperationContext, Duration> maxTimeFunc = this.getMaximumTimeSinceAuthn();
        if (maxTimeFunc != null) {
            staticParams.put("saml2.Statement.Authn.MaxTimeSinceAuthn", maxTimeFunc.apply(input.getOperationContext()));
        }
    }

    @Nonnull
    protected Set<QName> getRequiredConditions(@Nonnull AssertionValidationInput input) {
        return this.getRequiredConditions();
    }

    @Nonnull
    protected CriteriaSet getSignatureCriteriaSet(@Nonnull AssertionValidationInput input) {
        MessageContext inboundContext;
        String issuer;
        Issuer issuerObj;
        CriteriaSet dynamicCriteria;
        CriteriaSet criteriaSet = new CriteriaSet();
        Function<Pair<InOutOperationContext, Assertion>, CriteriaSet> sigCritFunc = this.getSignatureCriteriaSetFunction();
        if (sigCritFunc != null && (dynamicCriteria = sigCritFunc.apply((Pair<InOutOperationContext, Assertion>)new Pair((Object)input.getOperationContext(), (Object)input.getAssertion()))) != null) {
            criteriaSet.addAll((Collection)dynamicCriteria);
        }
        if (!criteriaSet.contains(EntityIdCriterion.class) && (issuerObj = input.getAssertion().getIssuer()) != null && (issuer = StringSupport.trimOrNull((String)issuerObj.getValue())) != null) {
            this.log.debug("Adding internally-generated EntityIdCriterion with value of: {}", (Object)issuer);
            criteriaSet.add((Object)new EntityIdCriterion(issuer));
        }
        if (!criteriaSet.contains(UsageCriterion.class)) {
            this.log.debug("Adding internally-generated UsageCriterion with value of: {}", (Object)UsageType.SIGNING);
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        }
        if ((inboundContext = input.getOperationContext().getInboundMessageContext()) != null) {
            this.populateSignatureCriteriaFromInboundContext(criteriaSet, inboundContext);
        }
        this.log.debug("Resolved Signature validation CriteriaSet: {}", (Object)criteriaSet);
        return criteriaSet;
    }

    protected void populateSignatureCriteriaFromInboundContext(@Nonnull CriteriaSet criteriaSet, @Nonnull MessageContext inboundContext) {
        SignatureValidationParameters valParams;
        SecurityParametersContext secParamsContext;
        String protocol;
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)inboundContext.getSubcontext(SAMLPeerEntityContext.class);
        if (peerContext != null) {
            QName role;
            RoleDescriptor role2;
            SAMLMetadataContext metadataContext;
            if (!criteriaSet.contains(RoleDescriptorCriterion.class) && (metadataContext = (SAMLMetadataContext)peerContext.getSubcontext(SAMLMetadataContext.class)) != null && (role2 = metadataContext.getRoleDescriptor()) != null) {
                criteriaSet.add((Object)new RoleDescriptorCriterion(role2));
            }
            if (!criteriaSet.contains(EntityRoleCriterion.class) && (role = peerContext.getRole()) != null) {
                criteriaSet.add((Object)new EntityRoleCriterion(role));
            }
        }
        SAMLProtocolContext protocolContext = (SAMLProtocolContext)inboundContext.getSubcontext(SAMLProtocolContext.class);
        if (!criteriaSet.contains(ProtocolCriterion.class) && protocolContext != null && (protocol = protocolContext.getProtocol()) != null) {
            criteriaSet.add((Object)new ProtocolCriterion(protocol));
        }
        if (!criteriaSet.contains(SignatureValidationParametersCriterion.class) && (secParamsContext = (SecurityParametersContext)inboundContext.getSubcontext(SecurityParametersContext.class)) != null && (valParams = secParamsContext.getSignatureValidationParameters()) != null) {
            criteriaSet.add((Object)new SignatureValidationParametersCriterion(valParams));
        }
    }

    @Nullable
    protected X509Certificate getAttesterCertificate(@Nonnull AssertionValidationInput input) {
        X509Certificate cert = input.getNetworkInformationSupplier().getAttesterCertificate();
        if (cert != null) {
            return cert;
        }
        this.log.debug("Peer TLS X.509 certificate was not present. Holder-of-key proof-of-possession via client TLS cert will not be possible");
        return null;
    }

    @Nullable
    protected PublicKey getAttesterPublicKey(@Nonnull AssertionValidationInput input) {
        return null;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Set<String> getValidRecipients(@Nonnull AssertionValidationInput input) {
        String selfEntityID;
        LazySet validRecipients = new LazySet();
        try {
            String endpoint;
            String contextEndpoint = SAMLBindingSupport.getActualReceiverEndpointURI((MessageContext)input.getOperationContext().ensureInboundMessageContext());
            String string = endpoint = contextEndpoint != null ? contextEndpoint : input.getNetworkInformationSupplier().getReceiverEndpointURI();
            if (endpoint != null) {
                validRecipients.add((Object)endpoint);
            }
        }
        catch (MessageException e) {
            this.log.warn("Attempt to resolve recipient endpoint failed", (Throwable)e);
        }
        if (this.getIncludeSelfEntityIDAsRecipient().test(input.getOperationContext()) && (selfEntityID = this.getSelfEntityID().apply(input.getOperationContext())) != null) {
            validRecipients.add((Object)selfEntityID);
        }
        this.log.debug("Resolved valid subject confirmation recipients set: {}", (Object)validRecipients);
        return validRecipients;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Set<InetAddress> getValidAddresses(@Nonnull AssertionValidationInput input) {
        try {
            LazySet validAddresses = new LazySet();
            InetAddress[] addresses = null;
            String attesterIPAddress = this.getAttesterIPAddress(input);
            this.log.debug("Saw attester IP address: {}", (Object)attesterIPAddress);
            if (attesterIPAddress != null) {
                addresses = InetAddress.getAllByName(attesterIPAddress);
                validAddresses.addAll(Arrays.asList(addresses));
                this.log.debug("Resolved valid subject confirmation InetAddress set: {}", (Object)validAddresses);
                return validAddresses;
            }
            this.log.debug("Could not determine attester IP address. Validation of Assertion may or may not succeed");
            return CollectionSupport.emptySet();
        }
        catch (UnknownHostException e) {
            this.log.debug("Processing of attester IP address failed. Validation of Assertion may or may not succeed", (Throwable)e);
            return CollectionSupport.emptySet();
        }
    }

    @Nullable
    protected String getAttesterIPAddress(@Nonnull AssertionValidationInput input) {
        return input.getNetworkInformationSupplier().getAttesterIPAddress();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Set<String> getValidAudiences(@Nonnull AssertionValidationInput input) {
        Set<String> additional;
        Function<InOutOperationContext, Set<String>> audFunc;
        LazySet validAudiences = new LazySet();
        String selfEntityID = this.getSelfEntityID().apply(input.getOperationContext());
        if (selfEntityID != null) {
            validAudiences.add((Object)selfEntityID);
        }
        if ((audFunc = this.getAdditionalAudiences()) != null && (additional = audFunc.apply(input.getOperationContext())) != null) {
            validAudiences.addAll(additional);
        }
        this.log.debug("Resolved valid audiences set: {}", (Object)validAudiences);
        return validAudiences;
    }

    public static class DefaultValidInResponseToLookupFunction
    implements Function<InOutOperationContext, String> {
        @Nonnull
        private Function<MessageContext, String> delegate = new SAMLMessageInfoContextIDFunction().compose(new ChildContextLookup(SAMLMessageInfoContext.class, true).compose((Function)new MessageContextLookup(MessageContextLookup.Direction.OUTBOUND)));

        @Override
        @Nullable
        public String apply(@Nullable InOutOperationContext prc) {
            if (prc == null || prc.getInboundMessageContext() == null) {
                return null;
            }
            return this.delegate.apply(prc.getInboundMessageContext());
        }
    }

    public static class DefaultValidIssuersLookupFunction
    implements Function<InOutOperationContext, Set<String>> {
        @Nonnull
        private Function<MessageContext, String> delegate = new SAMLEntityIDFunction().compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new MessageContextLookup(MessageContextLookup.Direction.OUTBOUND)));

        @Override
        @Nullable
        @Unmodifiable
        @NotLive
        public Set<String> apply(@Nullable InOutOperationContext prc) {
            if (prc == null || prc.getInboundMessageContext() == null) {
                return null;
            }
            String entityID = this.delegate.apply(prc.getInboundMessageContext());
            if (entityID != null) {
                return CollectionSupport.singleton((Object)entityID);
            }
            return CollectionSupport.emptySet();
        }
    }

    public static class DefaultSelfEntityIDLookupFunction
    implements Function<InOutOperationContext, String> {
        @Nonnull
        private Function<MessageContext, String> delegate = new SAMLEntityIDFunction().compose(new ChildContextLookup(SAMLSelfEntityContext.class).compose((Function)new MessageContextLookup(MessageContextLookup.Direction.INBOUND)));

        @Override
        @Nullable
        @Unmodifiable
        @NotLive
        public String apply(@Nullable InOutOperationContext prc) {
            if (prc == null || prc.getInboundMessageContext() == null) {
                return null;
            }
            return this.delegate.apply(prc.getInboundMessageContext());
        }
    }
}

