/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.ObjectSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.AssertionValidationSupport;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.slf4j.Logger;

@ThreadSafe
public abstract class AbstractSubjectConfirmationValidator
implements SubjectConfirmationValidator {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractSubjectConfirmationValidator.class);

    @Nonnull
    public ValidationResult validate(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        boolean addressRequired = this.isAddressRequired(context);
        boolean inResponseToIgnored = this.isInResponseToIgnored(context);
        boolean inResponseToRequired = this.isInResponseToRequired(context);
        boolean recipientRequired = this.isRecipientRequired(context);
        boolean notOnOrAfterRequired = this.isNotOnOrAfterRequired(context);
        boolean notBeforeRequired = this.isNotBeforeRequired(context);
        SubjectConfirmationData confirmationData = confirmation.getSubjectConfirmationData();
        if (confirmationData != null) {
            ValidationResult result = this.validateNotBefore(confirmationData, assertion, context, notBeforeRequired);
            if (result != ValidationResult.VALID) {
                return result;
            }
            result = this.validateNotOnOrAfter(confirmationData, assertion, context, notOnOrAfterRequired);
            if (result != ValidationResult.VALID) {
                return result;
            }
            result = this.validateRecipient(confirmationData, assertion, context, recipientRequired);
            if (result != ValidationResult.VALID) {
                return result;
            }
            result = this.validateAddress(confirmationData, assertion, context, addressRequired);
            if (result != ValidationResult.VALID) {
                return result;
            }
            if (!inResponseToIgnored && (result = this.validateInResponseTo(confirmationData, assertion, context, inResponseToRequired)) != ValidationResult.VALID) {
                return result;
            }
        } else if (!inResponseToIgnored && inResponseToRequired || recipientRequired || notOnOrAfterRequired || notBeforeRequired || addressRequired) {
            context.getValidationFailureMessages().add("SubjectConfirmationData was null and one or more data elements were required");
            return ValidationResult.INVALID;
        }
        return this.doValidate(confirmation, assertion, context);
    }

    protected boolean isAddressRequired(ValidationContext context) {
        Boolean flag = (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.AddressRequired"), Boolean.FALSE});
        return flag != null ? flag : false;
    }

    protected boolean isRecipientRequired(ValidationContext context) {
        Boolean flag = (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.RecipientRequired"), Boolean.FALSE});
        return flag != null ? flag : false;
    }

    protected boolean isNotBeforeRequired(ValidationContext context) {
        Boolean flag = (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.NotBeforeRequired"), Boolean.FALSE});
        return flag != null ? flag : false;
    }

    protected boolean isNotOnOrAfterRequired(ValidationContext context) {
        Boolean flag = (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.NoOnOrAfterRequired"), Boolean.FALSE});
        return flag != null ? flag : false;
    }

    protected boolean isInResponseToIgnored(ValidationContext context) {
        Boolean flag = (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.InResponseToIgnored"), Boolean.FALSE});
        return flag != null ? flag : false;
    }

    protected boolean isInResponseToRequired(ValidationContext context) {
        Boolean flag = (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.InResponseToRequired"), Boolean.FALSE});
        return flag != null ? flag : false;
    }

    @Nonnull
    protected ValidationResult validateInResponseTo(@Nonnull SubjectConfirmationData confirmationData, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        String validInResponseTo;
        String inResponseTo = StringSupport.trimOrNull((String)confirmationData.getInResponseTo());
        this.log.debug("Evaluating SubjectConfirmationData@InResponseTo of: {}", (Object)inResponseTo);
        try {
            validInResponseTo = (String)context.getStaticParameters().get("saml2.SubjectConfirmation.ValidInResponseTo");
        }
        catch (ClassCastException e) {
            context.getValidationFailureMessages().add("Unable to determine valid subject confirmation InResponseTo");
            return ValidationResult.INDETERMINATE;
        }
        if (inResponseTo == null && required) {
            context.getValidationFailureMessages().add("SubjectConfirmationData/@InResponseTo was missing and was required");
            return ValidationResult.INVALID;
        }
        if (Objects.equals(inResponseTo, validInResponseTo)) {
            this.log.debug("Matched valid InResponseTo: {}", (Object)inResponseTo);
            return ValidationResult.VALID;
        }
        context.getValidationFailureMessages().add(String.format("SubjectConfirmationData/@InResponseTo for assertion '%s' did not match the valid value: %s", assertion.getID(), validInResponseTo));
        return ValidationResult.INVALID;
    }

    @Nonnull
    protected ValidationResult validateNotBefore(@Nonnull SubjectConfirmationData confirmationData, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        Instant notBefore = confirmationData.getNotBefore();
        if (notBefore == null) {
            if (required) {
                context.getValidationFailureMessages().add("SubjectConfirmationData/@NotBefore was missing and was required");
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        Instant skewedNow = Instant.now().plus(SAML20AssertionValidator.getClockSkew((ValidationContext)context));
        this.log.debug("Evaluating SubjectConfirmationData NotBefore '{}' against 'skewed now' time '{}'", (Object)notBefore, (Object)skewedNow);
        if (notBefore != null && notBefore.isAfter(skewedNow)) {
            context.getValidationFailureMessages().add(String.format("SubjectConfirmationData in assertion '%s', with NotBefore condition of '%s' is not yet valid", assertion.getID(), notBefore));
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    @Nonnull
    protected ValidationResult validateNotOnOrAfter(@Nonnull SubjectConfirmationData confirmationData, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        Instant notOnOrAfter = confirmationData.getNotOnOrAfter();
        if (notOnOrAfter == null) {
            if (required) {
                context.getValidationFailureMessages().add("SubjectConfirmationData/@NotOnOrAfter was missing and was required");
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        Instant skewedNow = Instant.now().minus(SAML20AssertionValidator.getClockSkew((ValidationContext)context));
        this.log.debug("Evaluating SubjectConfirmationData NotOnOrAfter '{}' against 'skewed now' time '{}'", (Object)notOnOrAfter, (Object)skewedNow);
        if (notOnOrAfter != null && notOnOrAfter.isBefore(skewedNow)) {
            context.getValidationFailureMessages().add(String.format("SubjectConfirmationData, in assertion '%s', with NotOnOrAfter condition of '%s' is no longer valid", assertion.getID(), notOnOrAfter));
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    @Nonnull
    protected ValidationResult validateRecipient(@Nonnull SubjectConfirmationData confirmationData, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        Set validRecipients;
        String recipient = StringSupport.trimOrNull((String)confirmationData.getRecipient());
        if (recipient == null) {
            if (required) {
                context.getValidationFailureMessages().add("SubjectConfirmationData/@Recipient was missing and was required");
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        this.log.debug("Evaluating SubjectConfirmationData@Recipient of: {}", (Object)recipient);
        try {
            validRecipients = (Set)context.getStaticParameters().get("saml2.SubjectConfirmation.ValidRecipients");
        }
        catch (ClassCastException e) {
            context.getValidationFailureMessages().add("Unable to determine list of valid subject confirmation recipient endpoints");
            return ValidationResult.INDETERMINATE;
        }
        if (validRecipients == null || validRecipients.isEmpty()) {
            context.getValidationFailureMessages().add("Set of valid recipient URI's was not available from the validation context, unable to evaluate SubjectConfirmationData@Recipient");
            return ValidationResult.INDETERMINATE;
        }
        if (validRecipients.contains(recipient)) {
            this.log.debug("Matched valid recipient: {}", (Object)recipient);
            return ValidationResult.VALID;
        }
        context.getValidationFailureMessages().add(String.format("SubjectConfirmationData/@Recipient for assertion '%s' did not match any valid recipients: %s", assertion.getID(), validRecipients));
        return ValidationResult.INVALID;
    }

    @Nonnull
    protected ValidationResult validateAddress(@Nonnull SubjectConfirmationData confirmationData, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        Boolean checkAddress = (Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.CheckAddress");
        if (checkAddress != null && !checkAddress.booleanValue()) {
            this.log.debug("SubjectConfirmationData/@Address check is disabled, skipping");
            return ValidationResult.VALID;
        }
        String address = StringSupport.trimOrNull((String)confirmationData.getAddress());
        if (address == null) {
            if (required) {
                context.getValidationFailureMessages().add("SubjectConfirmationData/@Address was missing and was required");
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        return AssertionValidationSupport.checkAddress(context, address, "saml2.SubjectConfirmation.ValidAddresses", assertion, "SubjectConfirmationData/@Address");
    }

    @Nonnull
    protected abstract ValidationResult doValidate(@Nonnull SubjectConfirmation var1, @Nonnull Assertion var2, @Nonnull ValidationContext var3) throws AssertionValidationException;
}

