/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.ProxyRestriction;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.saml.saml2.profile.impl.AddProxyRestrictionToAssertions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddProxyRestrictionToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private static final String AUDIENCE1 = "foo";
    private static final String AUDIENCE2 = "foo2";
    private AddProxyRestrictionToAssertions action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddProxyRestrictionToAssertions();
        this.action.setProxyAudiencesLookupStrategy((Function)new Function<ProfileRequestContext, Collection<String>>(){

            public Collection<String> apply(ProfileRequestContext input) {
                return ImmutableList.of((Object)AddProxyRestrictionToAssertionsTest.AUDIENCE1, (Object)AddProxyRestrictionToAssertionsTest.AUDIENCE2);
            }
        });
        this.action.setProxyCountLookupStrategy((Function)new Function<ProfileRequestContext, Long>(){

            public Long apply(ProfileRequestContext input) {
                return 1L;
            }
        });
        this.action.initialize();
    }

    @Test
    public void testNoResponse() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertion() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testSingleAssertion() throws Exception {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getProxyRestriction());
        ProxyRestriction proxy = assertion.getConditions().getProxyRestriction();
        Assert.assertEquals((Object)proxy.getProxyCount(), (Object)1);
        Assert.assertEquals((int)proxy.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((Audience)proxy.getAudiences().get(0)).getAudienceURI(), (String)AUDIENCE1);
        Assert.assertEquals((String)((Audience)proxy.getAudiences().get(1)).getAudienceURI(), (String)AUDIENCE2);
    }

    @Test
    public void testSingleAssertionWithExistingCondition() throws Exception {
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getProxyRestriction());
        ProxyRestriction proxy = assertion.getConditions().getProxyRestriction();
        Assert.assertEquals((Object)proxy.getProxyCount(), (Object)1);
        Assert.assertEquals((int)proxy.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((Audience)proxy.getAudiences().get(0)).getAudienceURI(), (String)AUDIENCE1);
        Assert.assertEquals((String)((Audience)proxy.getAudiences().get(1)).getAudienceURI(), (String)AUDIENCE2);
    }

    @Test
    public void testMultipleAssertion() throws Exception {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getConditions());
            Assert.assertNotNull((Object)assertion.getConditions().getProxyRestriction());
            ProxyRestriction proxy = assertion.getConditions().getProxyRestriction();
            Assert.assertEquals((Object)proxy.getProxyCount(), (Object)1);
            Assert.assertEquals((int)proxy.getAudiences().size(), (int)2);
            Assert.assertEquals((String)((Audience)proxy.getAudiences().get(0)).getAudienceURI(), (String)AUDIENCE1);
            Assert.assertEquals((String)((Audience)proxy.getAudiences().get(1)).getAudienceURI(), (String)AUDIENCE2);
        }
    }
}

