/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SingleLogoutServiceTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedBinding;
    protected String expectedLocation;
    protected String expectedResponseLocation;
    protected QName[] unknownAttributeNames = new QName[]{new QName("urn:foo:bar", "bar", "foo")};
    protected String[] unknownAttributeValues = new String[]{"fred"};

    public SingleLogoutServiceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/SingleLogoutService.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/SingleLogoutServiceChildElements.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/SingleLogoutServiceOptionalAttributes.xml";
        this.singleElementUnknownAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/SingleLogoutServiceUnknownAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedBinding = "urn:binding:foo";
        this.expectedLocation = "example.org";
        this.expectedResponseLocation = "example.org/response";
    }

    @Test
    public void testSingleElementUnmarshall() {
        SingleLogoutService service = (SingleLogoutService)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
    }

    @Test
    public void testSingleElementUnknownAttributesUnmarshall() {
        SingleLogoutService service = (SingleLogoutService)this.unmarshallElement(this.singleElementUnknownAttributesFile);
        AttributeMap attributes = service.getUnknownAttributes();
        Assert.assertEquals((int)attributes.entrySet().size(), (int)this.unknownAttributeNames.length);
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            Assert.assertEquals((String)attributes.get((Object)this.unknownAttributeNames[i]), (String)this.unknownAttributeValues[i]);
        }
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        SingleLogoutService service = (SingleLogoutService)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
        Assert.assertEquals((String)service.getResponseLocation(), (String)this.expectedResponseLocation, (String)"ResponseLocation was not expected value");
    }

    @Test
    public void testSingleElementMarshall() {
        SingleLogoutService service = (SingleLogoutService)this.buildXMLObject(SingleLogoutService.DEFAULT_ELEMENT_NAME);
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)service);
    }

    @Test
    public void testSingleElementUnknownAttributesMarshall() {
        SingleLogoutService service = new SingleLogoutServiceBuilder().buildObject();
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            service.getUnknownAttributes().put(this.unknownAttributeNames[i], this.unknownAttributeValues[i]);
        }
        this.assertXMLEquals(this.expectedUnknownAttributesDOM, (XMLObject)service);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        SingleLogoutService service = (SingleLogoutService)this.buildXMLObject(SingleLogoutService.DEFAULT_ELEMENT_NAME);
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        service.setResponseLocation(this.expectedResponseLocation);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)service);
    }

    @Test
    public void testChildElementsUnmarshall() {
        SingleLogoutService service = (SingleLogoutService)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)service.getUnknownXMLObjects().size(), (int)1);
    }

    @Test
    public void testChildElementsMarshall() {
        SingleLogoutService service = new SingleLogoutServiceBuilder().buildObject();
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        XMLObject obj = builderFactory.getBuilderOrThrow(XSAny.TYPE_NAME).buildObject(new QName("http://example.org/", "bar", "foo"));
        service.getUnknownXMLObjects().add(obj);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)service);
    }
}

