/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyDescriptorTest
extends XMLObjectProviderBaseTestCase {
    protected UsageType expectedUse;
    protected int expectedNumEncMethods;

    public KeyDescriptorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/KeyDescriptor.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/KeyDescriptorOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/KeyDescriptorChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedUse = UsageType.ENCRYPTION;
        this.expectedNumEncMethods = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        KeyDescriptor keyDescriptor = (KeyDescriptor)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)keyDescriptor, (String)"KeyDescriptor");
        Assert.assertEquals((Object)keyDescriptor.getUse(), (Object)UsageType.UNSPECIFIED, (String)"Unexpected use attribute value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        KeyDescriptor keyDescriptor = (KeyDescriptor)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)keyDescriptor, (String)"KeyDescriptor");
        Assert.assertEquals((Object)keyDescriptor.getUse(), (Object)this.expectedUse, (String)"Use attribute");
    }

    @Test
    public void testSingleElementUnknownAttribute() {
        this.unmarshallElement("/org/opensaml/saml/saml2/metadata/impl/KeyDescriptorUnknownAttribute.xml");
    }

    @Test
    public void testUsageEnum() {
        KeyDescriptor keyDescriptor = null;
        keyDescriptor = (KeyDescriptor)this.unmarshallElement("/org/opensaml/saml/saml2/metadata/impl/KeyDescriptorUseNotPresent.xml");
        Assert.assertEquals((Object)keyDescriptor.getUse(), (Object)UsageType.UNSPECIFIED);
        keyDescriptor = (KeyDescriptor)this.unmarshallElement("/org/opensaml/saml/saml2/metadata/impl/KeyDescriptorUseSigning.xml");
        Assert.assertEquals((Object)keyDescriptor.getUse(), (Object)UsageType.SIGNING);
        keyDescriptor = (KeyDescriptor)this.unmarshallElement("/org/opensaml/saml/saml2/metadata/impl/KeyDescriptorUseEncryption.xml");
        Assert.assertEquals((Object)keyDescriptor.getUse(), (Object)UsageType.ENCRYPTION);
        try {
            keyDescriptor = (KeyDescriptor)this.unmarshallElement("/org/opensaml/saml/saml2/metadata/impl/KeyDescriptorUseUnspecified.xml");
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            keyDescriptor = (KeyDescriptor)this.unmarshallElement("/org/opensaml/saml/saml2/metadata/impl/KeyDescriptorUseValueIllegal.xml");
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testChildElementsUnmarshall() {
        KeyDescriptor keyDescriptor = (KeyDescriptor)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)keyDescriptor, (String)"KeyDescriptor");
        Assert.assertNotNull((Object)keyDescriptor.getKeyInfo(), (String)"KeyInfo Child element");
        Assert.assertEquals((int)keyDescriptor.getEncryptionMethods().size(), (int)this.expectedNumEncMethods, (String)"# of EncryptionMethod child elements");
    }

    @Test
    public void testSingleElementMarshall() {
        KeyDescriptor keyDescriptor = new KeyDescriptorBuilder().buildObject();
        keyDescriptor.setUse(null);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)keyDescriptor);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "KeyDescriptor", "md");
        KeyDescriptor keyDescriptor = (KeyDescriptor)this.buildXMLObject(qname);
        keyDescriptor.setUse(UsageType.ENCRYPTION);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)keyDescriptor);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "KeyDescriptor", "md");
        KeyDescriptor keyDescriptor = (KeyDescriptor)this.buildXMLObject(qname);
        keyDescriptor.setKeyInfo((KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME));
        keyDescriptor.getEncryptionMethods().add((EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME));
        keyDescriptor.getEncryptionMethods().add((EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)keyDescriptor);
    }
}

