/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.saml.saml2.metadata.Company;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.TelephoneNumber;
import org.opensaml.saml.saml2.metadata.impl.ContactPersonBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ContactPersonTest
extends XMLObjectProviderBaseTestCase {
    protected ContactPersonTypeEnumeration expectedPersonType;
    protected int emailAddressCount = 2;
    protected int telephoneNumberCount = 3;
    protected QName[] unknownAttributeNames = new QName[]{new QName("urn:foo:bar", "bar", "foo")};
    protected String[] unknownAttributeValues = new String[]{"fred"};

    public ContactPersonTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/ContactPerson.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/ContactPersonChildElements.xml";
        this.singleElementUnknownAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/ContactPersonUnknownAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedPersonType = ContactPersonTypeEnumeration.TECHNICAL;
    }

    @Test
    public void testSingleElementUnmarshall() {
        ContactPerson person = (ContactPerson)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((Object)person.getType(), (Object)this.expectedPersonType, (String)"Contact type was not expected value");
    }

    @Test
    public void testSingleElementUnknownAttributesUnmarshall() {
        ContactPerson person = (ContactPerson)this.unmarshallElement(this.singleElementUnknownAttributesFile);
        AttributeMap attributes = person.getUnknownAttributes();
        Assert.assertEquals((int)attributes.entrySet().size(), (int)this.unknownAttributeNames.length);
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            Assert.assertEquals((String)attributes.get((Object)this.unknownAttributeNames[i]), (String)this.unknownAttributeValues[i]);
        }
    }

    @Test
    public void testChildElementsUnmarshall() {
        ContactPerson person = (ContactPerson)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)person.getExtensions(), (String)"Extension Element not present");
        Assert.assertNotNull((Object)person.getCompany(), (String)"Company Element not present");
        Assert.assertNotNull((Object)person.getSurName(), (String)"SurName not present");
        Assert.assertNotNull((Object)person.getGivenName(), (String)"GivenName not present");
        Assert.assertEquals((int)person.getEmailAddresses().size(), (int)this.emailAddressCount, (String)"Email address count");
        Assert.assertEquals((int)person.getTelephoneNumbers().size(), (int)this.telephoneNumberCount, (String)"Telephone Number count");
    }

    @Test
    public void testSingleElementMarshall() {
        ContactPerson person = (ContactPerson)this.buildXMLObject(ContactPerson.DEFAULT_ELEMENT_NAME);
        person.setType(this.expectedPersonType);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)person);
    }

    @Test
    public void testSingleElementUnknownAttributesMarshall() {
        ContactPerson person = (ContactPerson)this.buildXMLObject(ContactPerson.DEFAULT_ELEMENT_NAME);
        person.setType(ContactPersonTypeEnumeration.OTHER);
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            person.getUnknownAttributes().put(this.unknownAttributeNames[i], this.unknownAttributeValues[i]);
        }
        this.assertXMLEquals(this.expectedUnknownAttributesDOM, (XMLObject)person);
    }

    @Test
    public void testChildElementsMarshall() {
        ContactPerson person = new ContactPersonBuilder().buildObject();
        person.setType(this.expectedPersonType);
        QName extensionsQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md");
        person.setExtensions((Extensions)this.buildXMLObject(extensionsQName));
        QName companuQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Company", "md");
        person.setCompany((Company)this.buildXMLObject(companuQName));
        QName givenNameQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "GivenName", "md");
        person.setGivenName((GivenName)this.buildXMLObject(givenNameQName));
        QName surnameQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SurName", "md");
        person.setSurName((SurName)this.buildXMLObject(surnameQName));
        QName teleQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "TelephoneNumber", "md");
        for (int i = 0; i < this.telephoneNumberCount; ++i) {
            person.getTelephoneNumbers().add((TelephoneNumber)this.buildXMLObject(teleQName));
        }
        QName emailQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EmailAddress", "md");
        for (int i = 0; i < this.emailAddressCount; ++i) {
            person.getEmailAddresses().add((EmailAddress)this.buildXMLObject(emailQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)person);
    }
}

