/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.ServiceDescription;
import org.opensaml.saml.saml2.metadata.ServiceName;
import org.opensaml.saml.saml2.metadata.impl.AttributeConsumingServiceBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeConsumingServiceTest
extends XMLObjectProviderBaseTestCase {
    protected int expectedIndex;
    protected XSBooleanValue expectedIsDefault;
    protected int expectedServiceNameCount;
    protected int expectedServiceDecsriptionCount;
    protected int expectedRequestedAttributeCount;

    public AttributeConsumingServiceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/AttributeConsumingService.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/AttributeConsumingServiceOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/AttributeConsumingServiceChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedIndex = 1;
        this.expectedIsDefault = new XSBooleanValue(Boolean.TRUE, false);
        this.expectedServiceNameCount = 2;
        this.expectedServiceDecsriptionCount = 3;
        this.expectedRequestedAttributeCount = 1;
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeConsumingService service = (AttributeConsumingService)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((int)service.getIndex(), (int)this.expectedIndex, (String)"Index was not expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeConsumingService service = (AttributeConsumingService)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((int)service.getIndex(), (int)this.expectedIndex, (String)"Index was not expected value");
        Assert.assertEquals((Object)service.isDefaultXSBoolean(), (Object)this.expectedIsDefault, (String)"isDefault was not expected value");
    }

    @Test
    public void testChildElementsUnmarshall() {
        AttributeConsumingService service = (AttributeConsumingService)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)service.getNames().size(), (int)this.expectedServiceNameCount, (String)"<ServiceName> count");
        Assert.assertEquals((int)service.getDescriptions().size(), (int)this.expectedServiceDecsriptionCount, (String)"<ServiceDescription> count");
        Assert.assertEquals((int)service.getRequestAttributes().size(), (int)this.expectedRequestedAttributeCount, (String)"<ReqestAttribute> count");
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeConsumingService service = new AttributeConsumingServiceBuilder().buildObject();
        service.setIndex(this.expectedIndex);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)service);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AttributeConsumingService service = (AttributeConsumingService)this.buildXMLObject(AttributeConsumingService.DEFAULT_ELEMENT_NAME);
        service.setIndex(this.expectedIndex);
        service.setIsDefault(this.expectedIsDefault);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)service);
    }

    @Test
    public void testChildElementsMarshall() {
        int i;
        AttributeConsumingService service = (AttributeConsumingService)this.buildXMLObject(AttributeConsumingService.DEFAULT_ELEMENT_NAME);
        service.setIndex(this.expectedIndex);
        for (i = 0; i < this.expectedServiceNameCount; ++i) {
            service.getNames().add((ServiceName)this.buildXMLObject(ServiceName.DEFAULT_ELEMENT_NAME));
        }
        for (i = 0; i < this.expectedServiceDecsriptionCount; ++i) {
            service.getDescriptions().add((ServiceDescription)this.buildXMLObject(ServiceDescription.DEFAULT_ELEMENT_NAME));
        }
        service.getRequestAttributes().add((RequestedAttribute)this.buildXMLObject(RequestedAttribute.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)service);
    }

    @Test
    public void testXSBooleanAttributes() {
        AttributeConsumingService acs = (AttributeConsumingService)this.buildXMLObject(AttributeConsumingService.DEFAULT_ELEMENT_NAME);
        acs.setIsDefault(Boolean.TRUE);
        Assert.assertEquals((Object)acs.isDefault(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)acs.isDefaultXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)acs.isDefaultXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)acs.isDefaultXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        acs.setIsDefault(Boolean.FALSE);
        Assert.assertEquals((Object)acs.isDefault(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)acs.isDefaultXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)acs.isDefaultXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)acs.isDefaultXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        acs.setIsDefault((Boolean)null);
        Assert.assertEquals((Object)acs.isDefault(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)acs.isDefaultXSBoolean(), (String)"XSBooleanValue was not null");
    }
}

