/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.impl.AssertionIDRequestServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.AttributeAuthorityDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.AttributeProfileBuilder;
import org.opensaml.saml.saml2.metadata.impl.AttributeServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.NameIDFormatBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeAuthorityDescriptorTest
extends XMLObjectProviderBaseTestCase {
    public AttributeAuthorityDescriptorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/AttributeAuthorityDescriptor.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/AttributeAuthorityDescriptorChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeAuthorityDescriptor descriptor = (AttributeAuthorityDescriptor)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((int)descriptor.getAttributeServices().size(), (int)0);
        Assert.assertEquals((int)descriptor.getAssertionIDRequestServices().size(), (int)0);
        Assert.assertEquals((int)descriptor.getNameIDFormats().size(), (int)0);
        Assert.assertEquals((int)descriptor.getAttributeProfiles().size(), (int)0);
        Assert.assertEquals((int)descriptor.getAttributes().size(), (int)0);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AttributeAuthorityDescriptor descriptor = (AttributeAuthorityDescriptor)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)descriptor.getAttributeServices().size(), (int)1);
        Assert.assertEquals((int)descriptor.getAssertionIDRequestServices().size(), (int)2);
        Assert.assertEquals((int)descriptor.getNameIDFormats().size(), (int)1);
        Assert.assertEquals((int)descriptor.getAttributeProfiles().size(), (int)2);
        Assert.assertEquals((int)descriptor.getAttributes().size(), (int)3);
        Assert.assertEquals((int)descriptor.getEndpoints().size(), (int)3);
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AttributeService", "md");
        Assert.assertEquals((int)descriptor.getEndpoints(qname).size(), (int)1);
        qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AssertionIDRequestService", "md");
        Assert.assertEquals((int)descriptor.getEndpoints(qname).size(), (int)2);
        Assert.assertNull((Object)descriptor.getEndpoints(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME));
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeAuthorityDescriptor descriptor = new AttributeAuthorityDescriptorBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)descriptor);
    }

    @Test
    public void testChildElementsMarshall() {
        int i;
        AttributeAuthorityDescriptor descriptor = new AttributeAuthorityDescriptorBuilder().buildObject();
        for (i = 0; i < 1; ++i) {
            descriptor.getAttributeServices().add(new AttributeServiceBuilder().buildObject());
        }
        for (i = 0; i < 2; ++i) {
            descriptor.getAssertionIDRequestServices().add(new AssertionIDRequestServiceBuilder().buildObject());
        }
        for (i = 0; i < 1; ++i) {
            descriptor.getNameIDFormats().add(new NameIDFormatBuilder().buildObject());
        }
        for (i = 0; i < 2; ++i) {
            descriptor.getAttributeProfiles().add(new AttributeProfileBuilder().buildObject());
        }
        for (i = 0; i < 3; ++i) {
            descriptor.getAttributes().add((Attribute)this.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)descriptor);
    }
}

