/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.impl.ArtifactResolutionServiceBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ArtifactResolutionServiceTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedBinding;
    protected String expectedLocation;
    protected String expectedResponseLocation;
    protected Integer expectedIndex;
    protected XSBooleanValue expectedIsDefault;

    public ArtifactResolutionServiceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/ArtifactResolutionService.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/ArtifactResolutionServiceOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedBinding = "urn:binding:foo";
        this.expectedLocation = "example.org";
        this.expectedResponseLocation = "example.org/response";
        this.expectedIndex = new Integer(3);
        this.expectedIsDefault = new XSBooleanValue(Boolean.TRUE, false);
    }

    @Test
    public void testSingleElementUnmarshall() {
        ArtifactResolutionService service = (ArtifactResolutionService)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
        Assert.assertEquals((Object)service.getIndex(), (Object)this.expectedIndex, (String)"Index was not expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        ArtifactResolutionService service = (ArtifactResolutionService)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
        Assert.assertEquals((Object)service.getIndex(), (Object)this.expectedIndex, (String)"Index was not expected value");
        Assert.assertEquals((String)service.getResponseLocation(), (String)this.expectedResponseLocation, (String)"ResponseLocation was not expected value");
        Assert.assertEquals((Object)service.isDefaultXSBoolean(), (Object)this.expectedIsDefault, (String)"isDefault was not expected value");
    }

    @Test
    public void testSingleElementMarshall() {
        ArtifactResolutionService service = new ArtifactResolutionServiceBuilder().buildObject();
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        service.setIndex(this.expectedIndex);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)service);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        ArtifactResolutionService service = (ArtifactResolutionService)this.buildXMLObject(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        service.setIndex(this.expectedIndex);
        service.setResponseLocation(this.expectedResponseLocation);
        service.setIsDefault(this.expectedIsDefault);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)service);
    }

    @Test
    public void testXSBooleanAttributes() {
        ArtifactResolutionService ars = (ArtifactResolutionService)this.buildXMLObject(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        ars.setIsDefault(Boolean.TRUE);
        Assert.assertEquals((Object)ars.isDefault(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)ars.isDefaultXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)ars.isDefaultXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)ars.isDefaultXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        ars.setIsDefault(Boolean.FALSE);
        Assert.assertEquals((Object)ars.isDefault(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)ars.isDefaultXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)ars.isDefaultXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)ars.isDefaultXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        ars.setIsDefault((Boolean)null);
        Assert.assertEquals((Object)ars.isDefault(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)ars.isDefaultXSBoolean(), (String)"XSBooleanValue was not null");
    }
}

