/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DecryptionPlusSigningTest
extends XMLObjectBaseTestCase {
    private KeyInfoCredentialResolver keyResolver;
    private String encURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private DataEncryptionParameters encParams;
    private Encrypter encrypter;
    private Credential signingCred;

    @BeforeMethod
    protected void setUp() throws Exception {
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.encURI);
        encCred.getSecretKey();
        this.keyResolver = new StaticKeyInfoCredentialResolver(encCred);
        this.encParams = new DataEncryptionParameters();
        this.encParams.setAlgorithm(this.encURI);
        this.encParams.setEncryptionCredential(encCred);
        this.encrypter = new Encrypter(this.encParams);
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.signingCred = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
    }

    @Test
    public void testEncryptedAssertionInResponse() throws XMLParserException, EncryptionException, NoSuchAlgorithmException, NoSuchProviderException, SecurityException, MarshallingException, SignatureException, UnmarshallingException {
        String filename = "/org/opensaml/saml/saml2/encryption/Assertion.xml";
        Document targetDOM = this.getDOM(filename);
        Assertion assertion = (Assertion)this.unmarshallElement(filename);
        EncryptedAssertion encryptedAssertion = this.encrypter.encrypt(assertion);
        Response response = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        response.setID("def456");
        response.setIssueInstant(new DateTime());
        Issuer issuer = (Issuer)this.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue("urn:string:issuer");
        response.setIssuer(issuer);
        response.getEncryptedAssertions().add(encryptedAssertion);
        Signature responseSignature = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        response.setSignature(responseSignature);
        SignatureSigningParameters signingParams = new SignatureSigningParameters();
        signingParams.setSigningCredential(this.signingCred);
        signingParams.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signingParams.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        signingParams.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        SignatureSupport.prepareSignatureParams((Signature)responseSignature, (SignatureSigningParameters)signingParams);
        marshallerFactory.getMarshaller((XMLObject)response).marshall((XMLObject)response);
        Signer.signObject((Signature)responseSignature);
        Element marshalledResponse = marshallerFactory.getMarshaller((XMLObject)response).marshall((XMLObject)response);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)marshalledResponse, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        Document parsedDoc = parserPool.parse((InputStream)bais);
        Element parsedResponse = parsedDoc.getDocumentElement();
        Response newResponse = (Response)unmarshallerFactory.getUnmarshaller(parsedResponse).unmarshall(parsedResponse);
        try {
            SignatureValidator.validate((Signature)newResponse.getSignature(), (Credential)this.signingCred);
        }
        catch (SignatureException e1) {
            Assert.fail((String)"First Response signature validation failed");
        }
        EncryptedAssertion newEncryptedAssertion = (EncryptedAssertion)newResponse.getEncryptedAssertions().get(0);
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null);
        decrypter.setRootInNewDocument(true);
        Assertion decryptedAssertion = null;
        try {
            decryptedAssertion = decrypter.decrypt(newEncryptedAssertion);
        }
        catch (DecryptionException e) {
            Assert.fail((String)("Error on decryption of EncryptedAssertion: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)decryptedAssertion, (String)"Decrypted Assertion was null");
        this.assertXMLEquals(targetDOM, (XMLObject)decryptedAssertion);
        try {
            SignatureValidator.validate((Signature)newResponse.getSignature(), (Credential)this.signingCred);
        }
        catch (SignatureException e1) {
            Assert.fail((String)"Second Response signature validation failed");
        }
    }

    private Document getDOM(String filename) throws XMLParserException {
        Document targetDOM = parserPool.parse(DecryptionPlusSigningTest.class.getResourceAsStream(filename));
        return targetDOM;
    }
}

