/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.ecp.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.ecp.RequestAuthenticated;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequestAuthenticatedTest
extends XMLObjectProviderBaseTestCase {
    private String expectedSOAP11Actor;
    private Boolean expectedSOAP11MustUnderstand;

    public RequestAuthenticatedTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/ecp/impl/RequestAuthenticated.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedSOAP11Actor = "https://soap11actor.example.org";
        this.expectedSOAP11MustUnderstand = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        RequestAuthenticated ra = (RequestAuthenticated)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)ra);
        Assert.assertEquals((Object)this.expectedSOAP11MustUnderstand, (Object)ra.isSOAP11MustUnderstand(), (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)this.expectedSOAP11Actor, (String)ra.getSOAP11Actor(), (String)"SOAP actor had unxpected value");
    }

    @Test
    public void testSingleElementMarshall() {
        RequestAuthenticated ra = (RequestAuthenticated)this.buildXMLObject(RequestAuthenticated.DEFAULT_ELEMENT_NAME);
        ra.setSOAP11Actor(this.expectedSOAP11Actor);
        ra.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ra);
    }
}

