/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SubjectLocalityTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAddress;
    private String expectedDNSName;

    public SubjectLocalityTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/SubjectLocality.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/SubjectLocalityOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAddress = "ip address";
        this.expectedDNSName = "dns name";
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectLocality subjectLocality = (SubjectLocality)this.unmarshallElement(this.singleElementFile);
        String address = subjectLocality.getAddress();
        Assert.assertEquals((String)address, (String)this.expectedAddress, (String)("Address was " + address + ", expected " + this.expectedAddress));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        SubjectLocality subjectLocality = (SubjectLocality)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        String address = subjectLocality.getAddress();
        Assert.assertEquals((String)address, (String)this.expectedAddress, (String)("Address was " + address + ", expected " + this.expectedAddress));
        String dnsName = subjectLocality.getDNSName();
        Assert.assertEquals((String)dnsName, (String)this.expectedDNSName, (String)("DNSName was " + dnsName + ", expected " + this.expectedDNSName));
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectLocality", "saml2");
        SubjectLocality subjectLocality = (SubjectLocality)this.buildXMLObject(qname);
        subjectLocality.setAddress(this.expectedAddress);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)subjectLocality);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectLocality", "saml2");
        SubjectLocality subjectLocality = (SubjectLocality)this.buildXMLObject(qname);
        subjectLocality.setAddress(this.expectedAddress);
        subjectLocality.setDNSName(this.expectedDNSName);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)subjectLocality);
    }
}

