/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class SubjectConfirmationTest
extends XMLObjectProviderBaseTestCase {
    private String expectedMethod;
    private String childElementsWithEncryptedIDFile;

    public SubjectConfirmationTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/SubjectConfirmation.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/SubjectConfirmationChildElements.xml";
        this.childElementsWithEncryptedIDFile = "/org/opensaml/saml/saml2/core/impl/SubjectConfirmationChildElementsWithEncryptedID.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedMethod = "conf method";
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.unmarshallElement(this.singleElementFile);
        String method = subjectConfirmation.getMethod();
        Assert.assertEquals((String)method, (String)this.expectedMethod, (String)"Method not as expected");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmation", "saml2");
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.buildXMLObject(qname);
        subjectConfirmation.setMethod(this.expectedMethod);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)subjectConfirmation);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
    }

    @Test
    public void testChildElementsUnmarshall() {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)subjectConfirmation.getNameID(), (String)"Identifier elemement not present");
        Assert.assertNotNull((Object)subjectConfirmation.getSubjectConfirmationData(), (String)"SubjectConfirmationData element not present");
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmation", "saml2");
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.buildXMLObject(qname);
        QName nameIDQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml2");
        subjectConfirmation.setNameID((NameID)this.buildXMLObject(nameIDQName));
        QName subjectConfirmationDataQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmationData", "saml2");
        subjectConfirmation.setSubjectConfirmationData((SubjectConfirmationData)this.buildXMLObject(subjectConfirmationDataQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)subjectConfirmation);
    }

    @Test
    public void testChildElementsWithEncryptedIDUnmarshall() {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.unmarshallElement(this.childElementsWithEncryptedIDFile);
        Assert.assertNull((Object)subjectConfirmation.getBaseID(), (String)"BaseID element present");
        Assert.assertNull((Object)subjectConfirmation.getNameID(), (String)"NameID element present");
        Assert.assertNotNull((Object)subjectConfirmation.getEncryptedID(), (String)"EncryptedID element not present");
        Assert.assertNotNull((Object)subjectConfirmation.getSubjectConfirmationData(), (String)"SubjectConfirmationData element not present");
    }

    @Test
    public void testChildElementsWithEncryptedIDMarshall() throws XMLParserException {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmation", "saml2");
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.buildXMLObject(qname);
        QName encryptedIDQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedID", "saml2");
        subjectConfirmation.setEncryptedID((EncryptedID)this.buildXMLObject(encryptedIDQName));
        QName subjectConfirmationDataQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmationData", "saml2");
        subjectConfirmation.setSubjectConfirmationData((SubjectConfirmationData)this.buildXMLObject(subjectConfirmationDataQName));
        Document expectedChildElementsWithEncryptedID = parserPool.parse(SubjectConfirmationTest.class.getResourceAsStream(this.childElementsWithEncryptedIDFile));
        this.assertXMLEquals(expectedChildElementsWithEncryptedID, (XMLObject)subjectConfirmation);
    }
}

