/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequestedAuthnContextTest
extends XMLObjectProviderBaseTestCase {
    private AuthnContextComparisonTypeEnumeration expectedComparison;
    private int expectedNumClassRefs;

    public RequestedAuthnContextTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/RequestedAuthnContext.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/RequestedAuthnContextOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/RequestedAuthnContextChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedComparison = AuthnContextComparisonTypeEnumeration.EXACT;
        this.expectedNumClassRefs = 3;
    }

    @Test
    public void testSingleElementMarshall() {
        RequestedAuthnContext rac = (RequestedAuthnContext)this.buildXMLObject(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)rac);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        RequestedAuthnContext rac = (RequestedAuthnContext)this.buildXMLObject(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        rac.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)rac);
    }

    @Test
    public void testChildElementsMarshall() {
        RequestedAuthnContext rac = (RequestedAuthnContext)this.buildXMLObject(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        QName authnContextClassRefQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextClassRef", "saml2");
        for (int i = 0; i < this.expectedNumClassRefs; ++i) {
            rac.getAuthnContextClassRefs().add((AuthnContextClassRef)this.buildXMLObject(authnContextClassRefQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)rac);
    }

    @Test
    public void testSingleElementUnmarshall() {
        RequestedAuthnContext rac = (RequestedAuthnContext)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)rac, (String)"RequestedAuthnContext");
        Assert.assertNull((Object)rac.getComparison(), (String)"Comparison");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        RequestedAuthnContext rac = (RequestedAuthnContext)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)rac.getComparison(), (String)"Comparison");
        Assert.assertEquals((String)rac.getComparison().toString(), (String)this.expectedComparison.toString(), (String)"The unmarshalled Comparison attribute was not the expected value");
    }

    @Test
    public void testChildElementsUnmarshall() {
        RequestedAuthnContext rac = (RequestedAuthnContext)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)rac.getAuthnContextClassRefs().size(), (int)this.expectedNumClassRefs, (String)"AuthnContextClassRef");
    }
}

